/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.SystemSpecificCollection;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.InitiatorRecipe;

public class ListCollectionMemberRecipe
extends InitiatorRecipe {
    private static final String SCCS_ID = "@(#)ListCollectionMemberRecipe.java 1.2   03/08/21 SMI";
    private final StorageSystem myStorageSystem;
    private final String myCollectionName;
    private HardwareID[] myMembers = null;

    public ListCollectionMemberRecipe(StorageSystem storageSystem, String string) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theCollectionName != null");
        this.myStorageSystem = storageSystem;
        this.myCollectionName = string;
    }

    public final HardwareID[] getMembers() {
        if (this.myMembers == null) {
            this.traceStep(1, "Locate the HardwareIDManagementService");
            HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
            this.traceStep(2, "Get the collection instance from the given name.");
            SystemSpecificCollection systemSpecificCollection = hardwareIDManagementService.getCollection(this.myCollectionName);
            if (systemSpecificCollection == null) {
                this.failInvalidGroup(this.myCollectionName);
            }
            this.traceStep(3, "Get the collection members.");
            if (systemSpecificCollection != null) {
                this.myMembers = systemSpecificCollection.getHardwareIDs();
            }
        }
        return this.myMembers;
    }

    public final String[] getMemberNames() {
        HardwareID[] hardwareIDArray = this.getMembers();
        return HardwareID.toStringNames(hardwareIDArray);
    }

    protected void cookRecipe() {
        this.getMembers();
    }
}

