/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_StorageVolume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Recipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.FindVolumeRecipe;

public class FindVolumeInfoRecipe
extends Recipe {
    public static final String VOLUME_COULD_NOT_BE_FOUND = "failed to find storage volume";
    private final StorageSystem myStorageSystem;
    private final String myVolumeName;
    private Volume myVolume = null;

    public FindVolumeInfoRecipe(StorageSystem storageSystem, String string) {
        super(storageSystem);
        this.myStorageSystem = storageSystem;
        this.myVolumeName = string;
    }

    public final String getVolumeName() {
        return this.myVolumeName;
    }

    public final Volume getVolume() {
        return this.myVolume;
    }

    public final String getElementName() {
        String string = this.myVolume.getPropertyValue("ElementName").toString();
        return string;
    }

    public final String getName() {
        String string = this.myVolume.getPropertyValue("Name").toString();
        return string;
    }

    public final int getNameFormat() {
        int n = this.myVolume.getPropertyValue("NameFormat").intValue();
        return n;
    }

    public final boolean isNameVPD83NAA6() {
        int n = -1;
        int n2 = 0;
        while (n2 < CIM_StorageVolume.NameFormat.VALUES.length) {
            if (CIM_StorageVolume.NameFormat.VALUES[n2].equals("VPD83NAA6")) {
                n = n2;
                break;
            }
            ++n2;
        }
        return this.getNameFormat() == new Integer(CIM_StorageVolume.NameFormat.VALUE_MAP[n]).intValue();
    }

    public final boolean isNameNodeWWN() {
        int n = -1;
        int n2 = 0;
        while (n2 < CIM_StorageVolume.NameFormat.VALUES.length) {
            if (CIM_StorageVolume.NameFormat.VALUES[n2].equals("NodeWWN")) {
                n = n2;
                break;
            }
            ++n2;
        }
        return this.getNameFormat() == new Integer(CIM_StorageVolume.NameFormat.VALUE_MAP[n]).intValue();
    }

    public final long getBlockSize() {
        long l = this.myVolume.getPropertyValue("BlockSize").longValue();
        return l;
    }

    public final long getNumberOfBlocks() {
        long l = this.myVolume.getPropertyValue("NumberOfBlocks").longValue();
        return l;
    }

    public final long getVolumeSizeInBytes() {
        long l = this.myVolume.getPropertyValue("BlockSize").longValue();
        long l2 = this.myVolume.getPropertyValue("NumberOfBlocks").longValue();
        return l * l2;
    }

    protected final void failNoVolumeOfNameFound() {
        this.failRecipe(VOLUME_COULD_NOT_BE_FOUND);
    }

    protected final void cookRecipe() {
        FindVolumeRecipe findVolumeRecipe = new FindVolumeRecipe(this.myStorageSystem, this.myVolumeName);
        findVolumeRecipe.run();
        this.myVolume = findVolumeRecipe.getVolume();
        if (this.myVolume == null) {
            this.failNoVolumeOfNameFound();
        }
    }
}

