/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Recipe;

public class FindPoolRecipe
extends Recipe {
    private final StorageSystem myStorageSystem;
    private final String myPoolName;
    private Pool myPool = null;

    public FindPoolRecipe(StorageSystem storageSystem, String string) {
        super(storageSystem);
        this.myStorageSystem = storageSystem;
        this.myPoolName = string;
    }

    public final String getPoolName() {
        return this.myPoolName;
    }

    public final Pool getPool() {
        if (this.myPool == null) {
            this.myPool = this.myStorageSystem.getPool(this.myPoolName);
        }
        return this.myPool;
    }

    public final AllocatedPool getAllocatedPool() {
        Pool[] poolArray;
        AllocatedPool[] allocatedPoolArray;
        AllocatedPool allocatedPool = null;
        Pool pool = this.getPool();
        if (pool != null && pool.isAllocated() && (allocatedPoolArray = AllocatedPool.create(this.myStorageSystem, poolArray = new Pool[]{pool})) != null && allocatedPoolArray.length == 1 && allocatedPoolArray[0] != null) {
            allocatedPool = allocatedPoolArray[0];
        }
        return allocatedPool;
    }

    public final PrimordialPool getPrimordialPool() {
        Pool[] poolArray;
        PrimordialPool[] primordialPoolArray;
        PrimordialPool primordialPool = null;
        Pool pool = this.getPool();
        if (pool != null && pool.isPrimordial() && (primordialPoolArray = PrimordialPool.create(this.myStorageSystem, poolArray = new Pool[]{pool})) != null && primordialPoolArray.length == 1 && primordialPoolArray[0] != null) {
            primordialPool = primordialPoolArray[0];
        }
        return primordialPool;
    }

    protected final void cookRecipe() {
        this.getPool();
    }
}

