/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.ConfigRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;

public class DeleteVolumeRecipe
extends ConfigRecipe {
    private static final String SCCS_ID = "@(#)DeleteVolumeRecipe.java 1.2   03/08/08 SMI";
    public static final String DELETE_VOLUME_OPERATION = "volume deletion";
    private final Volume myVolume;

    public DeleteVolumeRecipe(StorageSystem storageSystem, Volume volume) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((volume != null ? 1 : 0) != 0, (String)"theVolume != null");
        this.myVolume = volume;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Determine configuration service capabilities");
        ConfigService configService = this.getStorageSystem().getConfigService();
        ConfigCapabilities configCapabilities = configService.getConfigCapabilities();
        if (!configCapabilities.getElementDeletion().isSupported() || !configCapabilities.isVolumeSupported()) {
            this.failOperationNotSupported("DELETE_VOLUME_OPERATION");
        }
        this.traceStep(2, "Verify the state of the volume will allow delete");
        this.traceStep(3, "Delete Storage Volume");
        ConfigJob[] configJobArray = new ConfigJob[1];
        configService.deleteVolume(this.myVolume, configJobArray);
        if (configJobArray[0] != null) {
            this.setConfigJob(configJobArray[0]);
        } else if (configCapabilities.getElementDeletion().isAsync()) {
            this.failOperationFailed("DELETE_VOLUME_OPERATION");
        }
    }
}

