/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.InitiatorRecipe;

public class DeleteHardwareIDRecipe
extends InitiatorRecipe {
    private static final String SCCS_ID = "@(#)DeleteHardwareIDRecipe.java 1.2   03/08/21 SMI";
    private final StorageSystem myStorageSystem;
    private final String myHardwareIDName;

    public DeleteHardwareIDRecipe(StorageSystem storageSystem, String string) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theHardwareIDName != null");
        this.myStorageSystem = storageSystem;
        this.myHardwareIDName = string;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Locate the StorageHardwareIDManagementService.");
        HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
        this.traceStep(2, "Find the hardware id instance from the given name.");
        HardwareID hardwareID = hardwareIDManagementService.getHardwareID(this.myHardwareIDName);
        if (hardwareID == null) {
            this.failInvalidInitiator(this.myHardwareIDName);
        }
        this.traceStep(3, "Delete the hardware id.");
        hardwareIDManagementService.DeleteStorageHardwareID(hardwareID);
    }
}

