/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ManagedElement;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.ConfigRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public class CreatePoolRecipe
extends ConfigRecipe {
    private static final String SCCS_ID = "@(#)CreatePoolRecipe.java 1.8   03/09/19 SMI";
    public static final String CREATE_POOL_OPERATION = "pool creation";
    public static final String CREATE_POOL_COULD_NOT_CREATE_SETTING = "failed to create storage setting";
    public static final String CREATE_POOL_SOURCE_LACKS_CAPACITY = "The specified source pool has insufficient available capacity to create a {0} byte pool";
    private final StorageSetting myRequestedSetting;
    private final long myRequestedSize;
    private final PrimordialPool myRequestedPool;
    private AllocatedPool myAllocatedPool = null;

    public CreatePoolRecipe(StorageSystem storageSystem, StorageSetting storageSetting, long l, PrimordialPool primordialPool) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((storageSetting != null ? 1 : 0) != 0, (String)"theRequestedSetting != null");
        Contract.requires((l > 0L ? 1 : 0) != 0, (String)"theRequestedSize > 0");
        this.myRequestedSetting = storageSetting;
        this.myRequestedSize = l;
        this.myRequestedPool = primordialPool;
    }

    public CreatePoolRecipe(StorageSystem storageSystem, StorageSetting storageSetting, long l) {
        this(storageSystem, storageSetting, l, null);
    }

    public final boolean hasAllocatedPool() {
        return this.myAllocatedPool != null;
    }

    public final AllocatedPool getAllocatedPool() {
        return this.myAllocatedPool;
    }

    protected final void setAllocatedPool(AllocatedPool allocatedPool) {
        this.myAllocatedPool = allocatedPool;
    }

    protected final void failCouldNotCreateGoalSetting() {
        this.failRecipe(Localization.RES_CREATE_POOL_COULD_NOT_CREATE_SETTING);
    }

    protected final void failSourcePoolLacksCapacity() {
        String[] stringArray = new String[]{String.valueOf(this.myRequestedSize)};
        this.failRecipe(Localization.RES_CREATE_POOL_SOURCE_LACKS_CAPACITY, stringArray);
    }

    protected void cookRecipe() {
        ManagedElement managedElement;
        PrimordialPool[] primordialPoolArray;
        PrimordialPool[] primordialPoolArray2;
        this.traceStep(1, "Determine configuration service capabilities");
        ConfigService configService = this.getStorageSystem().getConfigService();
        ConfigCapabilities configCapabilities = configService.getConfigCapabilities();
        if (!configCapabilities.getPoolCreation().isSupported()) {
            this.failOperationNotSupported("CREATE_POOL_OPERATION");
        }
        this.traceStep(2, "Find source pools from which a new pool may be created");
        if (this.myRequestedPool != null) {
            PrimordialPool[] primordialPoolArray3 = new PrimordialPool[1];
            primordialPoolArray2 = primordialPoolArray3;
            primordialPoolArray3[0] = this.myRequestedPool;
        } else {
            primordialPoolArray2 = primordialPoolArray = this.getStorageSystem().getPrimordialPools();
        }
        if (primordialPoolArray == null || primordialPoolArray.length == 0) {
            this.failNoSourcePoolFound();
        }
        this.traceStep(3, "Find a source pool that meets the specified criteria");
        ManagedElement managedElement2 = null;
        PoolCapabilities poolCapabilities = null;
        int n = 0;
        while (n < primordialPoolArray.length) {
            managedElement = primordialPoolArray[n];
            poolCapabilities = ((Pool)managedElement).getCapabilities();
            if (poolCapabilities.meetsCriteria(this.myRequestedSetting)) {
                managedElement2 = managedElement;
                break;
            }
            ++n;
        }
        if (managedElement2 == null) {
            this.failNoSourcePoolMeetsCriteria(this.myRequestedSetting);
        }
        this.traceStep(4, "Determine if the source pool has enough remaining capacity");
        managedElement = poolCapabilities.createGoalSetting();
        if (managedElement != null) {
            ((VolumeSetting)managedElement).init(this.myRequestedSetting);
        } else {
            this.failCouldNotCreateGoalSetting();
        }
        long l = ((Pool)managedElement2).getAvailableSize((VolumeSetting)managedElement, this.myRequestedSize);
        if (l <= 0L) {
            this.failSourcePoolLacksCapacity();
        }
        this.traceStep(5, "Create Storage Pool");
        AllocatedPool[] allocatedPoolArray = new AllocatedPool[1];
        ConfigJob[] configJobArray = new ConfigJob[1];
        ((PrimordialPool)managedElement2).createPool((VolumeSetting)managedElement, l, allocatedPoolArray, configJobArray);
        if (allocatedPoolArray[0] != null || configJobArray[0] != null) {
            this.setAllocatedPool(allocatedPoolArray[0]);
            this.setConfigJob(configJobArray[0]);
        } else {
            this.failOperationFailed("CREATE_POOL_OPERATION");
        }
    }
}

