/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.ConfigRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public abstract class CreateElementRecipe
extends ConfigRecipe {
    private static final String SCCS_ID = "@(#)CreateElementRecipe.java 1.5   04/03/16 SMI";
    protected final StorageSetting myRequestedSetting;
    protected final long myRequestedSize;

    public CreateElementRecipe(StorageSystem storageSystem, StorageSetting storageSetting, long l) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((storageSetting != null ? 1 : 0) != 0, (String)"theRequestedSetting != null");
        Contract.requires((l > 0L ? 1 : 0) != 0, (String)"theRequestedSize > 0");
        this.myRequestedSetting = storageSetting;
        this.myRequestedSize = l;
    }

    protected abstract void checkCreateSupported(ConfigCapabilities var1);

    protected abstract Pool[] getSourcePools();

    protected abstract void doCreate(Pool var1, VolumeSetting var2, long var3);

    protected final void failCouldNotCreateGoalSetting() {
        this.failRecipe(Localization.RES_CREATE_POOL_COULD_NOT_CREATE_SETTING);
    }

    protected final void failSourcePoolLacksCapacity() {
        String[] stringArray = new String[]{String.valueOf(this.myRequestedSize)};
        this.failRecipe(Localization.RES_CREATE_POOL_SOURCE_LACKS_CAPACITY, stringArray);
    }

    protected void cookRecipe() {
        this.traceStep(1, "Determine configuration service capabilities");
        ConfigService configService = this.getStorageSystem().getConfigService();
        ConfigCapabilities configCapabilities = configService.getConfigCapabilities();
        this.checkCreateSupported(configCapabilities);
        this.traceStep(2, "Find source pools from which a new volume may be created");
        Pool[] poolArray = this.getSourcePools();
        if (poolArray == null || poolArray.length == 0) {
            this.failNoSourcePoolFound();
        }
        this.traceStep(3, "Find a source pool that meets the specified criteria");
        Pool pool = null;
        PoolCapabilities poolCapabilities = null;
        int n = 0;
        while (n < poolArray.length) {
            Pool pool2 = poolArray[n];
            poolCapabilities = pool2.getCapabilities();
            if (poolCapabilities.meetsCriteria(this.myRequestedSetting)) {
                pool = pool2;
                break;
            }
            ++n;
        }
        if (pool == null) {
            this.failNoSourcePoolMeetsCriteria(this.myRequestedSetting);
        }
        this.traceStep(4, "Determine if the source pool has enough remaining capacity");
        long l = 0L;
        VolumeSetting volumeSetting = poolCapabilities.createDefaultSetting();
        if (volumeSetting != null) {
            l = pool.getAvailableSize(volumeSetting, this.myRequestedSize);
            if (l <= 0L) {
                this.failSourcePoolLacksCapacity();
            }
        } else {
            this.failCouldNotCreateGoalSetting();
        }
        this.traceStep(5, "Create Storage Volume");
        this.doCreate(pool, volumeSetting, l);
    }
}

