/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.SystemSpecificCollection;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.InitiatorRecipe;

public class CreateCollectionRecipe
extends InitiatorRecipe {
    private static final String SCCS_ID = "@(#)CreateCollectionRecipe.java 1.2   03/08/21 SMI";
    public static final String CREATE_COLLECTION_OPERATION = "create collection";
    private final StorageSystem myStorageSystem;
    private final String myCollectionName;
    private final String[] myHardwareIDs;
    private SystemSpecificCollection myCollection = null;

    public CreateCollectionRecipe(StorageSystem storageSystem, String string, String[] stringArray) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theCollectionName != null");
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theHardwareIDs != null");
        Contract.requires((stringArray.length > 0 ? 1 : 0) != 0, (String)"theHardwareIDs.length > 0");
        this.myStorageSystem = storageSystem;
        this.myCollectionName = string;
        this.myHardwareIDs = stringArray;
    }

    public final boolean hasCollection() {
        return this.myCollection != null;
    }

    public final SystemSpecificCollection getCollection() {
        return this.myCollection;
    }

    protected final void setCollection(SystemSpecificCollection systemSpecificCollection) {
        this.myCollection = systemSpecificCollection;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Locate the StorageHardwareIDManagementService.");
        HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
        this.traceStep(2, "Create the collection.");
        SystemSpecificCollection[] systemSpecificCollectionArray = new SystemSpecificCollection[1];
        hardwareIDManagementService.CreateHardwareIDCollection(this.myCollectionName, this.myHardwareIDs, systemSpecificCollectionArray);
        this.traceStep(3, "Retrive the new collection created from the output.");
        if (systemSpecificCollectionArray[0] != null) {
            this.setCollection(systemSpecificCollectionArray[0]);
        } else {
            this.failOperationFailed("CREATE_COLLECTION_OPERATION");
        }
    }
}

