/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.MaskingCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrivilegeManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Recipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.CreateHardwareIDRecipe;

public class AssignAccessRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)AssignAccessRecipe.java 1.8   04/05/10 SMI";
    public static final String ASSIGN_ACCESS_OPERATION = "assign access";
    private StorageSystem myStorageSystem;
    private String myInitiator;
    private boolean myRead;
    private boolean myWrite;

    public AssignAccessRecipe(StorageSystem storageSystem, Volume volume, String string, boolean bl, boolean bl2) {
        super(storageSystem, volume);
        this.init(storageSystem, string, bl, bl2);
    }

    public AssignAccessRecipe(StorageSystem storageSystem, String string, String string2, boolean bl, boolean bl2) {
        super(storageSystem, string);
        this.init(storageSystem, string2, bl, bl2);
    }

    private void init(StorageSystem storageSystem, String string, boolean bl, boolean bl2) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theInitiator != null");
        this.myStorageSystem = storageSystem;
        this.myInitiator = string;
        this.myRead = bl;
        this.myWrite = bl2;
    }

    protected void cookRecipe() {
        Object object;
        this.traceStep(1, "Locate the StorageHardwareIDManagementService and PrivilegeManagementService and determine the capabilities.");
        HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
        PrivilegeManagementService privilegeManagementService = this.myStorageSystem.getPrivilegeManagementService();
        MaskingCapabilities maskingCapabilities = this.myStorageSystem.getMaskingCapabilities();
        this.traceStep(2, "Get the existing Hardware ID.");
        HardwareID[] hardwareIDArray = new HardwareID[1];
        HardwareID hardwareID = hardwareIDManagementService.getHardwareID(this.myInitiator);
        if (hardwareID == null) {
            this.traceStep(3, "Create a new Hardware ID.");
            object = new CreateHardwareIDRecipe(this.getStorageSystem(), this.myInitiator);
            ((Recipe)object).run();
            if (((Recipe)object).wasSuccess()) {
                hardwareID = ((CreateHardwareIDRecipe)object).getHardwareID();
            }
            if (hardwareID == null) {
                this.failOperationFailed("CREATE_HARDWAREID_OPERATION");
            }
        }
        this.traceStep(4, "Setup the volume access.");
        object = new Privilege[1];
        privilegeManagementService.AssignAccess(hardwareID, this.getVolume(), this.myRead, this.myWrite, (Privilege[])object);
        if (object[0] == null) {
            this.failOperationFailed("ASSIGN_ACCESS_OPERATION");
        }
    }
}

