/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Recipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public abstract class ArrayRecipe
extends Recipe
implements Localization {
    private static final String SCCS_ID = "@(#)ArrayRecipe.java 1.6   03/08/29 SMI";
    public static final String OPERATION_NOT_SUPPORTED = "The storage system ({0}) does not support the {1} operation.";
    public static final String OPERATION_FAILED = "The storage system ({0}) failed to run the {1} operation.";
    private final StorageSystem myStorageSystem;

    public ArrayRecipe(StorageSystem storageSystem) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    protected final void failOperationNotSupported(String string) {
        String[] stringArray = new String[]{this.getStorageSystem().getName(), string};
        this.failRecipe(Localization.RES_OPERATION_NOT_SUPPORTED, stringArray);
    }

    protected final void failOperationFailed(String string) {
        String[] stringArray = new String[]{this.getStorageSystem().getName(), string};
        this.failRecipe(Localization.RES_OPERATION_FAILED, stringArray);
    }
}

