/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.FindVolumeRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.InitiatorRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public abstract class AccessRecipe
extends InitiatorRecipe {
    private static final String SCCS_ID = "@(#)AccessRecipe.java 1.4   04/04/13 SMI";
    public static final String NO_VOLUME_FOUND = "The storage system ({0}) does not have the volume ({1})";
    public static final String NO_PORT_FOUND = "The storage system ({0}) does not have the port ({1})";
    public static final String CREATE_CONTROLLER_FAILED = "Could not create the protocol controller.";
    private Volume myVolume;
    private String myVolumeName;
    private String[] myFCPortNames;
    private FCPort[] myFCPorts;

    public AccessRecipe(StorageSystem storageSystem) {
        super(storageSystem);
    }

    public AccessRecipe(StorageSystem storageSystem, Volume volume) {
        this(storageSystem, volume, (String)null);
    }

    public AccessRecipe(StorageSystem storageSystem, String string) {
        this(storageSystem, null, string);
    }

    public AccessRecipe(StorageSystem storageSystem, Volume volume, FCPort[] fCPortArray) {
        this(storageSystem, volume, null, fCPortArray, null);
    }

    public AccessRecipe(StorageSystem storageSystem, Volume volume, String[] stringArray) {
        this(storageSystem, volume, null, null, stringArray);
    }

    public AccessRecipe(StorageSystem storageSystem, String string, String[] stringArray) {
        this(storageSystem, null, string, null, stringArray);
    }

    public AccessRecipe(StorageSystem storageSystem, FCPort[] fCPortArray) {
        this(storageSystem, fCPortArray, null);
    }

    public AccessRecipe(StorageSystem storageSystem, String[] stringArray) {
        this(storageSystem, (FCPort[])null, stringArray);
    }

    private AccessRecipe(StorageSystem storageSystem, Volume volume, String string) {
        super(storageSystem);
        this.initVolume(volume, string);
    }

    private AccessRecipe(StorageSystem storageSystem, Volume volume, String string, FCPort[] fCPortArray, String[] stringArray) {
        super(storageSystem);
        this.initVolume(volume, string);
        this.initFCPorts(fCPortArray, stringArray);
    }

    private AccessRecipe(StorageSystem storageSystem, FCPort[] fCPortArray, String[] stringArray) {
        super(storageSystem);
        this.initFCPorts(fCPortArray, stringArray);
    }

    private void initVolume(Volume volume, String string) {
        Contract.requires((volume != null || string != null ? 1 : 0) != 0, (String)"theVolume != null || theVolumeName != null");
        this.myVolume = volume;
        this.myVolumeName = string;
        if (this.myVolumeName != null) {
            this.myVolume = this.findVolume(this.myVolumeName);
        }
    }

    private void initFCPorts(FCPort[] fCPortArray, String[] stringArray) {
        Contract.requires((fCPortArray != null || stringArray != null ? 1 : 0) != 0, (String)"theFCPorts != null || theFCPortNames != null");
        this.myFCPorts = fCPortArray;
        this.myFCPortNames = stringArray;
        if (stringArray != null) {
            this.myFCPorts = this.findFCPorts(stringArray);
        }
    }

    public final Volume getVolume() {
        return this.myVolume;
    }

    public final String getVolumeName() {
        return this.myVolumeName;
    }

    public final String[] getFCPortNames() {
        return this.myFCPortNames;
    }

    public final FCPort[] getFCPorts() {
        return this.myFCPorts;
    }

    protected final Volume findVolume(String string) {
        Volume volume = null;
        if (string != null) {
            StorageSystem storageSystem = this.getStorageSystem();
            FindVolumeRecipe findVolumeRecipe = new FindVolumeRecipe(storageSystem, string);
            findVolumeRecipe.run();
            if (findVolumeRecipe.wasSuccess()) {
                volume = findVolumeRecipe.getVolume();
            }
        }
        if (volume == null) {
            this.failNoVolumeFound(string);
        }
        return volume;
    }

    protected final FCPort findFCPort(String string) {
        FCPort fCPort = null;
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theFCPortName != null");
        if (string != null) {
            StorageSystem storageSystem = this.getStorageSystem();
            FCPort[] fCPortArray = storageSystem.getFCPorts();
            int n = 0;
            while (n < fCPortArray.length) {
                if (string.equalsIgnoreCase(fCPortArray[n].getPermanentAddress())) {
                    fCPort = fCPortArray[n];
                    break;
                }
                ++n;
            }
        }
        if (fCPort == null) {
            this.failNoPortFound(string);
        }
        return fCPort;
    }

    protected final FCPort[] findFCPorts(String[] stringArray) {
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theFCPortNames != null");
        FCPort[] fCPortArray = new FCPort[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fCPortArray[n] = this.findFCPort(stringArray[n]);
            ++n;
        }
        return fCPortArray;
    }

    protected final void failNoVolumeFound(String string) {
        String[] stringArray = new String[]{this.getStorageSystem().getName(), string};
        this.failRecipe(Localization.RES_NO_VOLUME_FOUND, stringArray);
    }

    protected final void failNoPortFound(String string) {
        String[] stringArray = new String[]{this.getStorageSystem().getName(), string};
        this.failRecipe(Localization.RES_NO_PORT_FOUND, stringArray);
    }

    protected final void failCreateController() {
        this.failRecipe(Localization.RES_CREATE_CONTROLLER_FAILED);
    }
}

