/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.net;

import com.sun.netstorage.mgmt.esm.model.cim.net.CimomURL;
import java.security.Principal;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public final class CimomURLConnection {
    private static final String SCCS_ID = "@(#)CimomURLConnection.java 1.4   03/12/04 SMI";
    private final CimomURL myURL;
    private final boolean myLocal;
    private transient CIMNameSpace myNameSpace = null;
    private transient Principal myPrincipal = null;
    private transient PasswordCredential myCredential = null;
    private transient String myProtocol = null;
    private transient CIMClient myClient = null;
    private CIMException myFailureCause = null;
    private CIMException myInvalidContext = null;

    public CimomURLConnection(CimomURL cimomURL, boolean bl) {
        this.myURL = cimomURL;
        this.myLocal = bl;
    }

    public CimomURLConnection(CimomURL cimomURL) {
        this(cimomURL, false);
    }

    public CimomURL getURL() {
        return this.myURL;
    }

    private boolean isLocal() {
        return this.myLocal;
    }

    public final CIMNameSpace getNameSpace() {
        if (this.myNameSpace == null) {
            String string = this.myURL.getHostWithPort();
            String string2 = this.myURL.getNameSpace();
            this.myNameSpace = string2 != null ? new CIMNameSpace(string, string2) : new CIMNameSpace(string);
        }
        return this.myNameSpace;
    }

    private Principal getPrincipal() {
        if (this.myPrincipal == null) {
            if (this.isLocal()) {
                throw new IllegalStateException("Local mode deprecated");
            }
            String string = this.myURL.getUser();
            this.myPrincipal = new UserPrincipal(string);
        }
        return this.myPrincipal;
    }

    private PasswordCredential getCredential() {
        if (this.myCredential == null) {
            if (this.isLocal()) {
                throw new IllegalStateException("Local mode deprecated");
            }
            String string = this.myURL.getPassword();
            this.myCredential = new PasswordCredential(string);
        }
        return this.myCredential;
    }

    public final String getProtocol() {
        if (this.myProtocol == null) {
            String string = this.myURL.getProtocol();
            this.myProtocol = string != null ? (string.indexOf("rmi") >= 0 ? "cim-rmi" : "cim-xml") : "cim-xml";
        }
        return this.myProtocol;
    }

    public final boolean isConnected() {
        return this.myClient != null;
    }

    private CIMClient getConnection() {
        return this.myClient;
    }

    public final void connect() {
        if (!this.isConnected()) {
            this.init();
        }
    }

    private void init() {
        try {
            this.open();
        }
        catch (CIMException cIMException) {
            this.setFailureCause(cIMException);
        }
    }

    private void open() throws CIMException {
        this.myClient = new CIMClient(this.getNameSpace(), this.getPrincipal(), (Object)this.getCredential(), this.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.myClient != null) {
            try {
                try {
                    this.myClient.close();
                }
                catch (CIMException cIMException) {
                    Object var3_2 = null;
                    this.myClient = null;
                }
                Object var3_1 = null;
                this.myClient = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.myClient = null;
                throw throwable;
            }
        }
    }

    void reset() throws CIMException {
        this.close();
        this.open();
    }

    void reset(CIMException cIMException) throws CIMException {
        if (this.hasInvalidContext()) {
            throw this.myInvalidContext;
        }
        if (!this.isRecoverable(cIMException)) {
            throw cIMException;
        }
        this.reset();
    }

    public final boolean hasFailureCause() {
        return this.myFailureCause != null;
    }

    public final CIMException getFailureCause() {
        return this.myFailureCause;
    }

    private void setFailureCause(CIMException cIMException) {
        this.myFailureCause = cIMException;
        if (this.isInvalidContext(cIMException)) {
            this.myInvalidContext = cIMException;
        }
    }

    public final boolean hasInvalidContext() {
        return this.myInvalidContext != null;
    }

    public final CIMException getInvalidContext() {
        return this.myInvalidContext;
    }

    private boolean isInvalidContext(CIMException cIMException) {
        String string;
        boolean bl = false;
        String string2 = string = cIMException != null ? cIMException.getID() : null;
        if ("NO_SUCH_PRINCIPAL".equals(string) || "NO_SUCH_ROLE".equals(string) || "CANNOT_ASSUME_ROLE".equals(string) || "INVALID_CREDENTIAL".equals(string) || "CIM_ERR_ACCESS_DENIED".equals(string) || "UNKNOWNHOST".equals(string) || "CIM_ERR_INVALID_NAMESPACE".equals(string)) {
            bl = true;
        }
        return bl;
    }

    boolean isRecoverable(CIMException cIMException) {
        return this.isClosed(cIMException) || this.isDisconnected(cIMException);
    }

    boolean isClosed(CIMException cIMException) {
        String string = cIMException != null ? cIMException.getID() : null;
        boolean bl = false;
        if ("NO_SUCH_SESSION".equals(string)) {
            bl = true;
        }
        return bl;
    }

    boolean isDisconnected(CIMException cIMException) {
        Object object;
        Object[] objectArray;
        boolean bl = false;
        String string = cIMException != null ? cIMException.getID() : null;
        Object[] objectArray2 = objectArray = cIMException != null ? cIMException.getParams() : null;
        if ("RMIERROR".equals(string) && objectArray != null && objectArray.length >= 2 && (object = objectArray[1]) != null) {
            String string2 = object.getClass().getName();
            bl = string2.equals("java.rmi.ConnectException");
        }
        return bl;
    }

    public CIMOMHandle getHandle() {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.getConnection();
    }

    public String toString() {
        String string = "" + this.myClient;
        return this.myURL.toString() + '#' + string;
    }
}

