/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.net;

import com.sun.netstorage.mgmt.esm.model.cim.net.CimomPassword;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;

public class CimomURL
implements Serializable {
    private static final String SCCS_ID = "@(#)CimomURL.java 1.12   04/02/26 SMI";
    static final long serialVersionUID = -179377217416596875L;
    public static final String USER_DEFAULT = "root";
    public static final String HOST_DEFAULT = "localhost";
    public static final String RMI_PROTOCOL = "cim-rmi";
    public static final String XML_PROTOCOL = "cim-xml";
    public static final String PROTOCOL_DEFAULT = "cim-xml";
    public static final String[] PROTOCOL_NAMES = new String[]{"cim-xml", "cim-rmi"};
    public static final int RMI_PORT_DEFAULT = 5987;
    public static final int XML_PORT_DEFAULT = 5988;
    public static final String URL_SPEC_DEFAULT = "cim-xml://root@localhost";
    private URI myURI;
    private String myProtocol = null;
    private String myNameSpace = null;
    private String myUser = null;
    private String myHost = null;
    private String myCanonicalHost = null;
    private String myPassword = null;

    public static String createAbsoluteNameSpace(String string) {
        String string2 = string;
        if (!string2.startsWith("/") && !string2.startsWith("\\")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    public static CimomURL createCanonicalURL(String string) {
        CimomURL cimomURL = CimomURL.create(string);
        if (cimomURL != null) {
            String string2 = cimomURL.toCanonicalString();
            cimomURL = CimomURL.create(string2);
        }
        return cimomURL;
    }

    public static CimomURL create(String string) {
        CimomURL cimomURL = null;
        try {
            cimomURL = new CimomURL(string);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return cimomURL;
    }

    public static CimomURL getDefaultURL() {
        CimomURL cimomURL = null;
        try {
            cimomURL = new CimomURL(URL_SPEC_DEFAULT);
        }
        catch (Exception exception) {}
        return cimomURL;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"cim-xml://root@localhost/root/cimv28?property=cimom.pw#cop", "//localhost", "cim-rmi://localhost", "cim-rmi://shagbag:1234", "cim-rmi://batman@shagbag:1234", "cim-rmi://batman@shagbag:1234/root/cimv28", "cim-rmi://batman@shagbag:1234?password=secret"};
        String[] stringArray3 = stringArray.length > 0 ? stringArray : stringArray2;
        try {
            int n = 0;
            while (n < stringArray3.length) {
                String string = stringArray3[n];
                CimomURL cimomURL = new CimomURL(string);
                CimomURL cimomURL2 = CimomURL.createCanonicalURL(string);
                System.out.println("raw input url = " + cimomURL);
                System.out.println("canonical url = " + cimomURL2);
                System.out.println();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("oops: " + exception);
        }
    }

    private static void print(CimomURL cimomURL) {
        System.out.println("url = " + cimomURL);
        System.out.println();
        System.out.println("hostname = " + cimomURL.getHost());
        System.out.println("namespace = " + cimomURL.getNameSpace());
        System.out.println("username = " + cimomURL.getUser());
        System.out.println("password = " + cimomURL.getPassword());
        System.out.println("proto = " + cimomURL.getProtocol());
        System.out.println("cop = " + cimomURL.getObjectPath());
    }

    public CimomURL(String string) throws URISyntaxException {
        this(new URI(string));
        this.checkProtocol();
    }

    public CimomURL(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URISyntaxException {
        this(new URI(string, string2, string3, n, string4, string5, string6));
        this.checkProtocol();
    }

    public CimomURL(CimomURL cimomURL, String string) throws URISyntaxException {
        this(cimomURL.getProtocol(), cimomURL.getUser(), cimomURL.getHost(), cimomURL.getPort(), CimomURL.createAbsoluteNameSpace(string), cimomURL.getPasswordSpec(), cimomURL.getObjectPath());
    }

    private CimomURL(URI uRI) {
        this.myURI = uRI;
    }

    private URI getURI() {
        return this.myURI;
    }

    public String getProtocol() {
        if (this.myProtocol == null) {
            this.myProtocol = this.getURI().getScheme();
            this.myProtocol = this.myProtocol != null ? this.myProtocol.toLowerCase() : "cim-xml";
        }
        return this.myProtocol;
    }

    private void checkProtocol() throws URISyntaxException {
        String string = this.getProtocol();
        int n = 0;
        while (n < PROTOCOL_NAMES.length) {
            if (PROTOCOL_NAMES[n].equalsIgnoreCase(string)) {
                return;
            }
            ++n;
        }
        throw new URISyntaxException(this.toString(), "invalid protocol");
    }

    public String getNameSpace() {
        String string;
        if (this.myNameSpace == null && (string = this.getURI().getPath()) != null) {
            this.myNameSpace = string.length() > 1 ? string.substring(1) : null;
        }
        return this.myNameSpace;
    }

    public String getUser() {
        if (this.myUser == null) {
            this.myUser = this.getURI().getUserInfo();
            if (this.myUser == null) {
                this.myUser = USER_DEFAULT;
            }
        }
        return this.myUser;
    }

    public String getHost() {
        if (this.myHost == null) {
            this.myHost = this.getURI().getHost();
            if (this.myHost == null) {
                this.myHost = HOST_DEFAULT;
            }
        }
        return this.myHost;
    }

    public String getCanonicalHost() {
        block2: {
            if (this.myCanonicalHost != null) break block2;
            String string = this.getHost();
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                this.myCanonicalHost = inetAddress.getHostAddress();
            }
            catch (Exception exception) {}
        }
        return this.myCanonicalHost;
    }

    public String getPassword() {
        String string;
        if (this.myPassword == null && (string = this.getURI().getQuery()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            this.myPassword = CimomPassword.getPassword(this, string2, string3);
        }
        return this.myPassword;
    }

    protected final String getPasswordSpec() {
        return this.getURI().getQuery();
    }

    public String getHostWithPort() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getPort();
        if (n > 0) {
            stringBuffer.append("http://");
        }
        stringBuffer.append(this.getHost());
        if (n > 0) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public int getPort() {
        return this.getURI().getPort();
    }

    public int getCanonicalPort() {
        int n = this.getPort();
        if (n < 0) {
            if ("cim-xml".equals(this.getProtocol())) {
                n = 5988;
            } else if (RMI_PROTOCOL.equals(this.getProtocol())) {
                n = 5987;
            }
        }
        return n;
    }

    public String getObjectPath() {
        return this.getURI().getFragment();
    }

    public CimomURL toCanonicalURL() {
        CimomURL cimomURL = null;
        try {
            String string = this.toCanonicalString();
            cimomURL = new CimomURL(string);
        }
        catch (Exception exception) {}
        return cimomURL;
    }

    public String toCanonicalString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(this.getUser());
        stringBuffer.append('@');
        stringBuffer.append(this.getCanonicalHost());
        if (this.getCanonicalPort() > 0) {
            stringBuffer.append(':');
            stringBuffer.append(this.getCanonicalPort());
        }
        if (this.getNameSpace() != null) {
            stringBuffer.append('/');
            stringBuffer.append(this.getNameSpace());
        }
        if (this.getPasswordSpec() != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.getPasswordSpec());
        }
        return stringBuffer.toString();
    }

    public CimomURL changeProtocol(String string) throws URISyntaxException {
        return new CimomURL(string, this.getUser(), this.getHost(), this.getPort(), this.getNameSpace(), this.getPasswordSpec(), this.getObjectPath());
    }

    public CimomURL changeUser(String string) throws URISyntaxException {
        return new CimomURL(this.getProtocol(), string, this.getHost(), this.getPort(), this.getNameSpace(), this.getPasswordSpec(), this.getObjectPath());
    }

    public CimomURL changeNameSpace(String string) throws URISyntaxException {
        return new CimomURL(this.getProtocol(), this.getUser(), this.getHost(), this.getPort(), CimomURL.createAbsoluteNameSpace(string), this.getPasswordSpec(), this.getObjectPath());
    }

    public CimomURL changePasswordSpec(String string) throws URISyntaxException {
        return new CimomURL(this.getProtocol(), this.getUser(), this.getHost(), this.getPort(), this.getNameSpace(), string, this.getObjectPath());
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CimomURL) {
            CimomURL cimomURL = (CimomURL)object;
            if (this.getURI().equals(cimomURL.getURI())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public String toString() {
        return this.getURI().toString();
    }

    static {
        System.setProperty("root@localhost", "secret");
        System.setProperty("cimom.pw", "keep-this");
    }
}

