/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.net;

import com.solers.slp.Locator;
import com.solers.slp.ServiceLocationAttribute;
import com.solers.slp.ServiceLocationEnumeration;
import com.solers.slp.ServiceLocationManager;
import com.solers.slp.ServiceType;
import com.solers.slp.ServiceURL;
import com.sun.netstorage.mgmt.esm.model.cim.net.CimomConstants;
import com.sun.netstorage.mgmt.esm.model.cim.net.CimomProperties;
import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class CimomLocator
implements CimomConstants {
    private static final String SCCS_ID = "@(#)CimomLocator.java 1.3   03/11/24 SMI";
    public static final String KEY_PROPERTY = "CimomLocator.key";
    public static final ServiceType SLP_SERVICE_TYPE = new ServiceType("service:wbem:http");
    public static final String[] SLP_SCOPES_DEFAULT = new String[]{"DEFAULT"};
    public static final String[] SLP_ATTRIBUTES_DEFAULT = null;
    private static boolean ourSlpLogging = false;
    private final String[] mySlpScopes;
    private final String[] mySlpAttributes;
    private Locator mySlpLocator = null;
    private ServiceLocationEnumeration mySlpServiceLocations = null;
    private ServiceLocationEnumeration mySlpServiceAttributes = null;
    private final HashMap mySlpServices = new HashMap();
    private final HashMap myCimomProperties = new HashMap();
    private String[] myCimomNames = null;

    private static void initSlpLogging() {
        if (!ourSlpLogging) {
            Properties properties = new Properties();
            String string = "false";
            Category.getRoot().addAppender((Appender)JavaLoggingAppender.getSingleton());
            properties.put("net.slp.traceDATraffic", string);
            properties.put("net.slp.traceMsg", string);
            properties.put("net.slp.traceDrop", string);
            properties.put("net.slp.traceReg", string);
            ServiceLocationManager.init((Properties)properties);
            ourSlpLogging = true;
        }
    }

    public static void main(String[] stringArray) {
        try {
            CimomLocator cimomLocator = new CimomLocator();
            long l = System.currentTimeMillis();
            String[] stringArray2 = cimomLocator.getCimomNames();
            long l2 = System.currentTimeMillis() - l;
            int n = 0;
            while (stringArray2 != null && n < stringArray2.length) {
                String string = stringArray2[n];
                CimomProperties cimomProperties = cimomLocator.getCimomProperties(string);
                System.out.println("CIMOM #" + n + ": " + string);
                System.out.println("CimomProperties:\n" + cimomProperties);
                System.out.println();
                ++n;
            }
            long l3 = System.currentTimeMillis() - l;
            System.out.println("getCimomNames: " + l2 + "ms");
            System.out.println("total time: " + l3 + "ms");
        }
        catch (Exception exception) {
            System.err.println("oops: " + exception);
            exception.printStackTrace();
        }
    }

    public static String getKey(CimomProperties cimomProperties) {
        String string = null;
        if (cimomProperties != null) {
            string = cimomProperties.getProperty(KEY_PROPERTY);
        }
        return string;
    }

    public static void setKey(CimomProperties cimomProperties, String string) {
        if (cimomProperties != null && string != null) {
            cimomProperties.setProperty(KEY_PROPERTY, string);
        }
    }

    private static String getCanonicalKey(String string) {
        String string2;
        block6: {
            string2 = string;
            if (string == null) break block6;
            try {
                int n = string.indexOf("http");
                if (n > 0) {
                    String string3 = string.substring(0, n);
                    String string4 = string.substring(n);
                    URI uRI = new URI(string4);
                    InetAddress inetAddress = InetAddress.getByName(uRI.getHost());
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(uRI.getScheme());
                    stringBuffer.append("://");
                    if (uRI.getUserInfo() != null) {
                        stringBuffer.append(uRI.getUserInfo());
                        stringBuffer.append("@");
                    }
                    stringBuffer.append(inetAddress.getHostAddress());
                    if (uRI.getPort() > 0) {
                        stringBuffer.append(":");
                        stringBuffer.append(uRI.getPort());
                    }
                    if (uRI.getPath() != null) {
                        stringBuffer.append(uRI.getPath());
                    }
                    string2 = stringBuffer.toString();
                }
            }
            catch (Exception exception) {
                string2 = string;
            }
        }
        return string2;
    }

    public CimomLocator(String[] stringArray, String[] stringArray2) {
        this.mySlpScopes = stringArray != null ? stringArray : SLP_SCOPES_DEFAULT;
        this.mySlpAttributes = stringArray2;
        CimomLocator.initSlpLogging();
    }

    public CimomLocator(String[] stringArray) {
        this(stringArray, SLP_ATTRIBUTES_DEFAULT);
    }

    public CimomLocator() {
        this(SLP_SCOPES_DEFAULT, SLP_ATTRIBUTES_DEFAULT);
    }

    private Vector getSlpScopesVector() {
        Vector<String> vector = new Vector<String>(Arrays.asList(this.mySlpScopes));
        return vector;
    }

    private Vector getSlpAttributesVector() {
        Vector<String> vector = new Vector<String>();
        if (this.mySlpAttributes != null && this.mySlpAttributes.length > 0) {
            vector.addAll(Arrays.asList(this.mySlpAttributes));
        }
        return vector;
    }

    private Locator getSlpLocator() throws Exception {
        if (this.mySlpLocator == null) {
            this.mySlpLocator = ServiceLocationManager.getLocator((Locale)Locale.getDefault());
        }
        return this.mySlpLocator;
    }

    private ServiceLocationEnumeration getSlpServiceLocations() throws Exception {
        if (this.mySlpServiceLocations == null) {
            String string = "";
            this.mySlpServiceLocations = this.getSlpLocator().findServices(SLP_SERVICE_TYPE, this.getSlpScopesVector(), string);
        }
        return this.mySlpServiceLocations;
    }

    private ServiceLocationEnumeration getSlpServiceAttributes(ServiceURL serviceURL) throws Exception {
        this.mySlpServiceAttributes = this.getSlpLocator().findAttributes(serviceURL, this.getSlpScopesVector(), this.getSlpAttributesVector());
        return this.mySlpServiceAttributes;
    }

    private ServiceURL getSlpService(String string) {
        ServiceURL serviceURL = null;
        if (string != null) {
            serviceURL = (ServiceURL)this.mySlpServices.get(string);
        }
        return serviceURL;
    }

    private void mapSlpService(String string, ServiceURL serviceURL) {
        if (string != null && serviceURL != null && !this.mySlpServices.containsKey(string)) {
            this.mySlpServices.put(string, serviceURL);
        }
    }

    private void mapCimomProperties(String string, CimomProperties cimomProperties) {
        if (string != null && cimomProperties != null) {
            this.myCimomProperties.put(string, cimomProperties);
        }
    }

    public final CimomProperties getCimomProperties(String string) throws Exception {
        CimomProperties cimomProperties = null;
        if (string != null && (cimomProperties = (CimomProperties)this.myCimomProperties.get(string)) == null && (cimomProperties = this.lookupCimomProperties(string)) != null) {
            this.mapCimomProperties(string, cimomProperties);
        }
        return cimomProperties;
    }

    private CimomProperties lookupCimomProperties(String string) throws Exception {
        CimomProperties cimomProperties = new CimomProperties();
        ServiceURL serviceURL = this.getSlpService(string);
        CimomLocator.setKey(cimomProperties, string);
        if (serviceURL != null) {
            ServiceLocationEnumeration serviceLocationEnumeration = this.getSlpServiceAttributes(serviceURL);
            while (serviceLocationEnumeration.hasMoreElements()) {
                Object object = serviceLocationEnumeration.nextElement();
                if (!(object instanceof ServiceLocationAttribute)) continue;
                ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)object;
                Vector vector = serviceLocationAttribute.getValues();
                String string2 = this.getPropertyValue(vector);
                String string3 = serviceLocationAttribute.getId();
                cimomProperties.setProperty(string3, string2);
            }
        }
        return cimomProperties;
    }

    private String getPropertyValue(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(vector.get(n2));
                ++n2;
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public final String[] getCimomNames() throws Exception {
        ServiceLocationEnumeration serviceLocationEnumeration;
        if (this.myCimomNames == null && (serviceLocationEnumeration = this.getSlpServiceLocations()) != null) {
            Vector<String> vector = new Vector<String>();
            while (serviceLocationEnumeration.hasMoreElements()) {
                Object object = serviceLocationEnumeration.nextElement();
                if (!(object instanceof ServiceURL)) continue;
                ServiceURL serviceURL = (ServiceURL)object;
                String string = serviceURL.toString();
                String string2 = CimomLocator.getCanonicalKey(string);
                this.mapSlpService(string2, serviceURL);
                vector.add(string2);
            }
            this.myCimomNames = vector.toArray(new String[vector.size()]);
        }
        return this.myCimomNames;
    }

    public final void flush() {
        this.myCimomNames = null;
        this.myCimomProperties.clear();
        this.mySlpServiceLocations = null;
        this.mySlpServiceAttributes = null;
        this.mySlpServices.clear();
    }

    public final void setLogger(Logger logger) {
        JavaLoggingAppender.getSingleton().setLogger(logger);
    }

    public static class JavaLoggingAppender
    extends AppenderSkeleton {
        private static final JavaLoggingAppender ourSingleton = new JavaLoggingAppender();
        private Logger myLogger = null;

        public static JavaLoggingAppender getSingleton() {
            return ourSingleton;
        }

        public static Level getLevel(LoggingEvent loggingEvent) {
            Level level = Level.FINEST;
            if (loggingEvent != null) {
                Priority priority = loggingEvent.priority;
                if (Priority.FATAL.equals(priority)) {
                    level = Level.SEVERE;
                } else if (Priority.ERROR.equals(priority)) {
                    level = Level.SEVERE;
                } else if (Priority.WARN.equals(priority)) {
                    level = Level.WARNING;
                } else if (Priority.INFO.equals(priority)) {
                    level = Level.INFO;
                } else if (Priority.DEBUG.equals(priority)) {
                    level = Level.FINE;
                }
            }
            return level;
        }

        public static Throwable getCause(LoggingEvent loggingEvent) {
            ThrowableInformation throwableInformation;
            Throwable throwable = null;
            if (loggingEvent != null && (throwableInformation = loggingEvent.getThrowableInformation()) != null) {
                throwable = throwableInformation.getThrowable();
            }
            return throwable;
        }

        public static String getMethod(LoggingEvent loggingEvent) {
            LocationInfo locationInfo;
            String string = "";
            if (loggingEvent != null && (locationInfo = loggingEvent.getLocationInformation()) != null) {
                string = locationInfo.getMethodName();
            }
            return string;
        }

        private JavaLoggingAppender() {
            this.setName("JavaLoggingAppender");
        }

        public final void setLogger(Logger logger) {
            this.myLogger = logger;
        }

        protected final void append(LoggingEvent loggingEvent) {
            if (loggingEvent != null && this.myLogger != null) {
                Level level = JavaLoggingAppender.getLevel(loggingEvent);
                Throwable throwable = JavaLoggingAppender.getCause(loggingEvent);
                String string = JavaLoggingAppender.getMethod(loggingEvent);
                String string2 = loggingEvent.categoryName;
                String string3 = loggingEvent.getRenderedMessage();
                if (throwable != null) {
                    this.myLogger.logp(level, string2, string, string3, throwable);
                } else {
                    this.myLogger.logp(level, string2, string, string3);
                }
            }
        }

        public void close() {
            this.closed = true;
        }

        public boolean requiresLayout() {
            return false;
        }
    }
}

