/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.net;

import com.sun.netstorage.mgmt.esm.model.cim.net.CimomURL;
import com.sun.netstorage.mgmt.esm.model.cim.net.CimomURLConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMSecurityException;

public final class CimomInvocationHandler
implements InvocationHandler {
    private static final String SCCS_ID = "@(#)CimomInvocationHandler.java 1.4   03/11/15 SMI";
    public static final String DEFAULT_ALGORITHM_NAME = "*";
    private final CimomURLConnection myConnection;
    private HashMap myAlgorithms = new HashMap(23);
    private final LinkedList myListeners = new LinkedList();

    public CimomInvocationHandler(CimomURL cimomURL, boolean bl) {
        this.myConnection = new CimomURLConnection(cimomURL, bl);
        this.initAlgorithms();
        this.initConnection();
    }

    public CimomInvocationHandler(CimomURL cimomURL) {
        this(cimomURL, false);
    }

    private CIMOMHandle getHandle() {
        return this.myConnection.getHandle();
    }

    private void checkInvalidContext() throws CIMException {
        if (this.myConnection.hasInvalidContext()) {
            throw this.myConnection.getInvalidContext();
        }
    }

    private void checkConnection() throws CIMException {
        this.checkInvalidContext();
        if (this.getHandle() == null) {
            this.resetConnection();
        }
        if (this.getHandle() == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    private void initConnection() {
        try {
            this.openConnection();
        }
        catch (CIMException cIMException) {}
    }

    private void openConnection() throws CIMException {
        this.myConnection.connect();
        if (this.myConnection.isConnected()) {
            this.addListeners();
        }
    }

    private void closeConnection() {
        try {
            if (this.myConnection.isConnected()) {
                this.removeListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myConnection.close();
    }

    private void resetConnection() throws CIMException {
        this.closeConnection();
        this.openConnection();
    }

    private void resetConnection(CIMException cIMException) throws CIMException {
        this.checkInvalidContext();
        if (!this.myConnection.isRecoverable(cIMException)) {
            throw cIMException;
        }
        this.resetConnection();
    }

    private Object invokeConnection(Method method, Object[] objectArray) throws CIMException {
        Object object = null;
        try {
            object = method.invoke((Object)this.getHandle(), objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED", (Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CIMException) {
                throw (CIMException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)throwable);
        }
        return object;
    }

    private Algorithm getAlgorithm(String string) {
        return (Algorithm)this.myAlgorithms.get(string);
    }

    private Algorithm getAlgorithm(Method method) {
        String string = method.getName();
        Algorithm algorithm = this.getAlgorithm(string);
        if (algorithm == null) {
            algorithm = this.getAlgorithm(DEFAULT_ALGORITHM_NAME);
        }
        return algorithm;
    }

    private void mapAlgorithm(String string, Algorithm algorithm) {
        this.myAlgorithms.put(string, algorithm);
    }

    private void initAlgorithms() {
        this.mapAlgorithm(DEFAULT_ALGORITHM_NAME, new RetryAlgorithm());
        this.mapAlgorithm("close", new CloseAlgorithm());
        this.mapAlgorithm("addCIMListener", new AddListenerAlgorithm());
        this.mapAlgorithm("removeCIMListener", new RemoveListenerAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasListeners() {
        LinkedList linkedList = this.myListeners;
        synchronized (linkedList) {
            return !this.myListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(CIMListener cIMListener) {
        LinkedList linkedList = this.myListeners;
        synchronized (linkedList) {
            this.myListeners.add(cIMListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(CIMListener cIMListener) {
        LinkedList linkedList = this.myListeners;
        synchronized (linkedList) {
            this.myListeners.remove(cIMListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        LinkedList linkedList = this.myListeners;
        synchronized (linkedList) {
            this.myListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListeners() throws CIMException {
        LinkedList linkedList = this.myListeners;
        synchronized (linkedList) {
            if (this.getHandle() != null && !this.myListeners.isEmpty()) {
                ListIterator listIterator = this.myListeners.listIterator();
                while (listIterator.hasNext()) {
                    CIMListener cIMListener = (CIMListener)listIterator.next();
                    this.getHandle().addCIMListener(cIMListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners() throws CIMException {
        LinkedList linkedList = this.myListeners;
        synchronized (linkedList) {
            if (this.getHandle() != null && !this.myListeners.isEmpty()) {
                ListIterator listIterator = this.myListeners.listIterator();
                while (listIterator.hasNext()) {
                    CIMListener cIMListener = (CIMListener)listIterator.next();
                    this.getHandle().removeCIMListener(cIMListener);
                }
            }
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Algorithm algorithm = this.getAlgorithm(method);
        return algorithm.invoke(method, objectArray);
    }

    public class RemoveListenerAlgorithm
    extends RetryAlgorithm {
        public Object invoke(Method method, Object[] objectArray) throws CIMException {
            Object object = super.invoke(method, objectArray);
            if (objectArray != null && objectArray.length == 1 && objectArray[0] instanceof CIMListener) {
                CIMListener cIMListener = (CIMListener)objectArray[0];
                CimomInvocationHandler.this.removeListener(cIMListener);
            }
            return object;
        }
    }

    public class AddListenerAlgorithm
    extends RetryAlgorithm {
        public Object invoke(Method method, Object[] objectArray) throws CIMException {
            Object object = super.invoke(method, objectArray);
            if (objectArray != null && objectArray.length == 1 && objectArray[0] instanceof CIMListener) {
                CIMListener cIMListener = (CIMListener)objectArray[0];
                CimomInvocationHandler.this.addListener(cIMListener);
            }
            return object;
        }
    }

    public class RetryAlgorithm
    implements Algorithm {
        public Object invoke(Method method, Object[] objectArray) throws CIMException {
            Object object = null;
            CimomInvocationHandler.this.checkConnection();
            try {
                object = CimomInvocationHandler.this.invokeConnection(method, objectArray);
            }
            catch (CIMException cIMException) {
                CimomInvocationHandler.this.resetConnection(cIMException);
                object = CimomInvocationHandler.this.invokeConnection(method, objectArray);
            }
            return object;
        }
    }

    public class CloseAlgorithm
    implements Algorithm {
        public Object invoke(Method method, Object[] objectArray) throws CIMException {
            CimomInvocationHandler.this.closeConnection();
            CimomInvocationHandler.this.clearListeners();
            return null;
        }
    }

    public static interface Algorithm {
        public Object invoke(Method var1, Object[] var2) throws CIMException;
    }
}

