/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractSetting;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeProfile;
import javax.wbem.cim.CIMObjectPath;

public class VolumeSetting
extends AbstractSetting {
    private static final String SCCS_ID = "@(#)VolumeSetting.java 1.10   04/03/09 SMI";
    private PoolCapabilities myCapabilities = null;
    private Volume myVolume = null;

    public static VolumeSetting create(PoolCapabilities poolCapabilities, CIMObjectPath cIMObjectPath) {
        Contract.requires((poolCapabilities != null ? 1 : 0) != 0, (String)"theParent != null");
        VolumeSetting volumeSetting = null;
        if (cIMObjectPath != null) {
            volumeSetting = new VolumeSetting(poolCapabilities, cIMObjectPath);
        }
        return volumeSetting;
    }

    public VolumeSetting(Volume volume, CIMObjectPath cIMObjectPath) {
        super(volume, cIMObjectPath);
        this.myVolume = volume;
    }

    public VolumeSetting(PoolCapabilities poolCapabilities, CIMObjectPath cIMObjectPath) {
        super(poolCapabilities, cIMObjectPath);
        this.myCapabilities = poolCapabilities;
    }

    public final PoolCapabilities getCapabilities() {
        if (this.myCapabilities == null) {
            // empty if block
        }
        return this.myCapabilities;
    }

    public final Volume getVolume() {
        CIMObjectPath cIMObjectPath;
        if (this.myVolume == null && (cIMObjectPath = this.getAssociatedName("CIM_ElementSettingData", "CIM_StorageVolume")) != null) {
            this.myVolume = new Volume(this, cIMObjectPath);
        }
        return this.myVolume;
    }

    public final void destroyInstance() {
        try {
            super.deleteInstance();
        }
        catch (Exception exception) {}
    }

    public final boolean isVolumeProfile() {
        boolean bl = false;
        Object object = this.getPropertyValue("StorageCostHint").getObjectValue();
        if (object != null && object instanceof Number) {
            bl = true;
        }
        return bl;
    }

    public final VolumeProfile toVolumeProfile() {
        VolumeProfile volumeProfile = null;
        if (this.isVolumeProfile()) {
            volumeProfile = new VolumeProfile(this.myCapabilities, this.getObjectPath());
        }
        return volumeProfile;
    }

    public final void init(StorageSetting storageSetting) {
        if (storageSetting != null) {
            this.setNoSinglePointOfFailure(storageSetting.isNoSinglePointOfFailure());
            this.setDataRedundancyGoal(storageSetting.getDataRedundancy());
            this.setPackageRedundancyGoal(storageSetting.getPackageRedundancy());
            this.setDeltaReservationGoal(storageSetting.getDeltaReservation());
            this.setInstance();
        }
    }

    public final boolean isNoSinglePointOfFailure() {
        boolean bl = this.getPropertyValue("NoSinglePointOfFailure").booleanValue();
        return bl;
    }

    public final void setNoSinglePointOfFailure(boolean bl) {
        this.getPropertyValue("NoSinglePointOfFailure").setValue(bl);
    }

    public final int getDataRedundancyMin() {
        int n = this.getPropertyValue("DataRedundancyMin").intValue();
        return n;
    }

    public final int getDataRedundancyMax() {
        int n = this.getPropertyValue("DataRedundancyMax").intValue();
        return n;
    }

    public final int getDataRedundancyGoal() {
        int n = this.getPropertyValue("DataRedundancyGoal").intValue();
        return n;
    }

    public final void setDataRedundancyGoal(int n) {
        this.getPropertyValue("DataRedundancyGoal").setValue(n, CimValue.NumberType.UINT16);
    }

    public final int getPackageRedundancyMin() {
        int n = this.getPropertyValue("PackageRedundancyMin").intValue();
        return n;
    }

    public final int getPackageRedundancyMax() {
        int n = this.getPropertyValue("PackageRedundancyMax").intValue();
        return n;
    }

    public final int getPackageRedundancyGoal() {
        int n = this.getPropertyValue("PackageRedundancyGoal").intValue();
        return n;
    }

    public final void setPackageRedundancyGoal(int n) {
        this.getPropertyValue("PackageRedundancyGoal").setValue(n, CimValue.NumberType.UINT16);
    }

    public final int getDeltaReservationMin() {
        int n = this.getPropertyValue("DeltaReservationMin").intValue();
        return n;
    }

    public final int getDeltaReservationMax() {
        int n = this.getPropertyValue("DeltaReservationMax").intValue();
        return n;
    }

    public final int getDeltaReservationGoal() {
        int n = this.getPropertyValue("DeltaReservationGoal").intValue();
        return n;
    }

    public final void setDeltaReservationGoal(int n) {
        this.getPropertyValue("DeltaReservationGoal").setValue(n, CimValue.NumberType.UINT16);
    }
}

