/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Extent;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolControllerForUnit;
import javax.wbem.cim.CIMObjectPath;

public final class Volume
extends Extent {
    private static final String SCCS_ID = "@(#)Volume.java 1.12   03/09/08 SMI";
    private StorageSystem myStorageSystem = null;
    private AllocatedPool myPool = null;
    private VolumeSetting mySetting = null;
    private ProtocolController[] myProtocolControllers = null;
    private ProtocolControllerForUnit[] myProtocolControllerForUnits = null;
    private Privilege[] myPrivileges = null;

    public static Volume create(AllocatedPool allocatedPool, CIMObjectPath cIMObjectPath) {
        Contract.requires((allocatedPool != null ? 1 : 0) != 0, (String)"theParent != null");
        Volume volume = null;
        if (cIMObjectPath != null) {
            volume = new Volume(allocatedPool, cIMObjectPath);
        }
        return volume;
    }

    public static Volume[] create(AllocatedPool allocatedPool, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((allocatedPool != null ? 1 : 0) != 0, (String)"theParent != null");
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        Volume[] volumeArray = new Volume[n];
        int n2 = 0;
        while (n2 < n) {
            volumeArray[n2] = new Volume(allocatedPool, cIMObjectPathArray[n2]);
            ++n2;
        }
        Contract.ensures((volumeArray != null ? 1 : 0) != 0, (String)"result != null");
        return volumeArray;
    }

    public static Volume[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        Volume[] volumeArray = new Volume[n];
        int n2 = 0;
        while (n2 < n) {
            volumeArray[n2] = new Volume(storageSystem, cIMObjectPathArray[n2]);
            ++n2;
        }
        Contract.ensures((volumeArray != null ? 1 : 0) != 0, (String)"result != null");
        return volumeArray;
    }

    public Volume(AllocatedPool allocatedPool, CIMObjectPath cIMObjectPath) {
        super(allocatedPool, cIMObjectPath);
        this.myPool = allocatedPool;
    }

    public Volume(VolumeSetting volumeSetting, CIMObjectPath cIMObjectPath) {
        super(volumeSetting, cIMObjectPath);
        this.mySetting = volumeSetting;
    }

    public Volume(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        if (this.myStorageSystem == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_SystemDevice", "CIM_ComputerSystem");
            this.myStorageSystem = StorageSystem.createSS(this, cIMObjectPath);
        }
        return this.myStorageSystem;
    }

    public final AllocatedPool getPool() {
        if (this.myPool == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            this.myPool = AllocatedPool.createAP(null, cIMObjectPath);
        }
        return this.myPool;
    }

    public final VolumeSetting getSetting() {
        if (this.mySetting == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementSettingData", "CIM_StorageSetting");
            this.mySetting = new VolumeSetting(this, cIMObjectPath);
        }
        return this.mySetting;
    }

    public final ProtocolController[] getProtocolControllers() {
        if (this.myProtocolControllers == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_ProtocolControllerForUnit", "CIM_ProtocolController");
            this.myProtocolControllers = ProtocolController.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        return this.myProtocolControllers;
    }

    public final ProtocolController findProtocolController(FCPort[] fCPortArray) {
        Contract.requires((fCPortArray != null ? 1 : 0) != 0, (String)"theFCPorts != null");
        ProtocolController protocolController = null;
        ProtocolControllerForUnit[] protocolControllerForUnitArray = this.getProtocolControllerForUnits();
        int n = 0;
        while (n < protocolControllerForUnitArray.length) {
            ProtocolController protocolController2 = protocolControllerForUnitArray[n].getProtocolController();
            FCPort[] fCPortArray2 = protocolController2.getFCPorts();
            if (fCPortArray2.length == fCPortArray.length) {
                int n2 = 0;
                while (n2 < fCPortArray2.length) {
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < fCPortArray.length) {
                        if (fCPortArray2[n2].equals(fCPortArray[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        this.traceFinest("FCPorts passed in did not match.");
                        return null;
                    }
                    protocolController = protocolController2;
                    ++n2;
                }
            }
            ++n;
        }
        this.traceFinest("Found the matching protocol controller: " + protocolController);
        return protocolController;
    }

    public final ProtocolControllerForUnit[] getProtocolControllerForUnits() {
        if (this.myProtocolControllerForUnits == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getReferenceNames("CIM_ProtocolControllerForUnit", "Dependent");
            this.myProtocolControllerForUnits = ProtocolControllerForUnit.create(this, cIMObjectPathArray);
        }
        return this.myProtocolControllerForUnits;
    }

    public final Privilege[] getPrivileges() {
        if (this.myPrivileges == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AuthorizedTarget", "CIM_Privilege", "TargetElement", "Privilege");
            this.myPrivileges = Privilege.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        return this.myPrivileges;
    }
}

