/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Collection;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public final class SystemSpecificCollection
extends Collection {
    private static final String SCCS_ID = "@(#)SystemSpecificCollection.java 1.3   03/08/27 SMI";
    private StorageSystem myStorageSystem;
    private HardwareID[] myHardwareIDs = null;
    private String myInstanceID = null;
    private String myName = null;

    public static SystemSpecificCollection create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        SystemSpecificCollection systemSpecificCollection = null;
        if (cIMObjectPath != null) {
            systemSpecificCollection = new SystemSpecificCollection(storageSystem, cIMObjectPath);
        }
        return systemSpecificCollection;
    }

    public static SystemSpecificCollection[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        Contract.requires((cIMObjectPathArray != null ? 1 : 0) != 0, (String)"theNames != null");
        SystemSpecificCollection[] systemSpecificCollectionArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<SystemSpecificCollection> arrayList = new ArrayList<SystemSpecificCollection>(cIMObjectPathArray.length);
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
                if (cIMObjectPath != null) {
                    SystemSpecificCollection systemSpecificCollection = new SystemSpecificCollection(storageSystem, cIMObjectPath);
                    arrayList.add(systemSpecificCollection);
                }
                ++n;
            }
            systemSpecificCollectionArray = arrayList.toArray(new SystemSpecificCollection[arrayList.size()]);
        } else {
            systemSpecificCollectionArray = new SystemSpecificCollection[]{};
        }
        Contract.ensures((systemSpecificCollectionArray != null ? 1 : 0) != 0, (String)"result != null");
        return systemSpecificCollectionArray;
    }

    public static String[] toStringNames(SystemSpecificCollection[] systemSpecificCollectionArray) {
        Contract.requires((systemSpecificCollectionArray != null ? 1 : 0) != 0, (String)"theCollections != null");
        String[] stringArray = new String[systemSpecificCollectionArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = systemSpecificCollectionArray[n].getCollectionName();
            ++n;
        }
        return stringArray;
    }

    static SystemSpecificCollection getCollection(SystemSpecificCollection[] systemSpecificCollectionArray, String string) {
        Contract.requires((systemSpecificCollectionArray != null ? 1 : 0) != 0, (String)"theCollections != null");
        Contract.requires((systemSpecificCollectionArray.length > 0 ? 1 : 0) != 0, (String)"theCollections.length > 0");
        SystemSpecificCollection systemSpecificCollection = null;
        int n = 0;
        while (n < systemSpecificCollectionArray.length) {
            String string2 = SystemSpecificCollection.getCollectionName(systemSpecificCollectionArray[n]);
            if (string2.equalsIgnoreCase(string)) {
                systemSpecificCollection = systemSpecificCollectionArray[n];
                break;
            }
            ++n;
        }
        return systemSpecificCollection;
    }

    static String getCollectionName(SystemSpecificCollection systemSpecificCollection) {
        String string = systemSpecificCollection.getInstanceID();
        int n = string.indexOf(58);
        n = n != -1 ? n + 1 : 0;
        return string.substring(n);
    }

    public SystemSpecificCollection(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final HardwareID[] getHardwareIDs() {
        if (this.myHardwareIDs == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_MemberOfCollection", "CIM_StorageHardwareID");
            this.myHardwareIDs = HardwareID.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        Contract.ensures((this.myHardwareIDs != null ? 1 : 0) != 0, (String)"myHardwareIDs != null");
        return this.myHardwareIDs;
    }

    public String getInstanceID() {
        if (this.myInstanceID == null) {
            this.myInstanceID = this.getPropertyValue("InstanceID").getStringValue();
        }
        return this.myInstanceID;
    }

    public String getCollectionName() {
        if (this.myName == null) {
            this.myName = SystemSpecificCollection.getCollectionName(this);
        }
        return this.myName;
    }
}

