/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.CimContext;
import com.sun.netstorage.mgmt.esm.model.cim.CimObject;
import com.sun.netstorage.mgmt.esm.model.cim.CimObjectManager;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ComputerSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ProductData;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ControllerConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.MaskingCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrivilegeManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import javax.wbem.cim.CIMObjectPath;

public final class StorageSystem
extends ComputerSystem {
    private static final String SCCS_ID = "@(#)StorageSystem.java 1.18   04/03/12 SMI";
    private ConfigService myConfigService = null;
    private ControllerConfigService myControllerConfigService = null;
    private MaskingCapabilities myMaskingCapabilities = null;
    private Pool[] myPools = null;
    private PrimordialPool[] myPrimordialPools = null;
    private AllocatedPool[] myAllocatedPools = null;
    private Volume[] myVolumes = null;
    private FCPort[] myFCPorts = null;
    private HardwareIDManagementService myHardwareIDManagementService = null;
    private PrivilegeManagementService myPrivilegeManagementService = null;
    private StorageSystem[] myComponentStorageSystems = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$model$cim$ingredients$array$StorageSystem;

    public static StorageSystem createSS(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        Contract.requires((cimContext != null ? 1 : 0) != 0, (String)"theContext != null");
        CimObjectManager cimObjectManager = new CimObjectManager(cimContext);
        StorageSystem storageSystem = null;
        if (cIMObjectPath != null) {
            storageSystem = new StorageSystem((CimContext)cimObjectManager, cIMObjectPath);
        }
        return storageSystem;
    }

    public static StorageSystem[] createSS(CimObjectManager cimObjectManager, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((cimObjectManager != null ? 1 : 0) != 0, (String)"theContext != null");
        Contract.requires((cIMObjectPathArray != null ? 1 : 0) != 0, (String)"theNames != null");
        StorageSystem[] storageSystemArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<StorageSystem> arrayList = new ArrayList<StorageSystem>(cIMObjectPathArray.length);
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
                if (cIMObjectPath != null) {
                    StorageSystem storageSystem = new StorageSystem((CimContext)cimObjectManager, cIMObjectPath);
                    arrayList.add(storageSystem);
                }
                ++n;
            }
            storageSystemArray = arrayList.toArray(new StorageSystem[arrayList.size()]);
        } else {
            storageSystemArray = new StorageSystem[]{};
        }
        Contract.ensures((storageSystemArray != null ? 1 : 0) != 0, (String)"result != null");
        return storageSystemArray;
    }

    public static StorageSystem[] create(CimObjectManager cimObjectManager, ComputerSystem[] computerSystemArray) {
        Contract.requires((cimObjectManager != null ? 1 : 0) != 0, (String)"theContext != null");
        StorageSystem[] storageSystemArray = null;
        if (computerSystemArray != null) {
            ArrayList<StorageSystem> arrayList = new ArrayList<StorageSystem>(computerSystemArray.length);
            int n = 0;
            while (n < computerSystemArray.length) {
                ComputerSystem computerSystem = computerSystemArray[n];
                if (computerSystem.isStorageSystem()) {
                    arrayList.add(new StorageSystem((CimContext)cimObjectManager, computerSystem));
                }
                ++n;
            }
            storageSystemArray = arrayList.toArray(new StorageSystem[arrayList.size()]);
        } else {
            storageSystemArray = new StorageSystem[]{};
        }
        Contract.ensures((storageSystemArray != null ? 1 : 0) != 0, (String)"result != null");
        return storageSystemArray;
    }

    protected static final CIMObjectPath[] toObjectPaths(Object object) {
        CIMObjectPath[] cIMObjectPathArray = null;
        if (object instanceof CimObject[]) {
            CimObject[] cimObjectArray = (CimObject[])object;
            cIMObjectPathArray = new CIMObjectPath[cimObjectArray.length];
            int n = 0;
            while (n < cimObjectArray.length) {
                cIMObjectPathArray[n] = cimObjectArray[n].getObjectPath();
                ++n;
            }
        } else if (object instanceof CimObject) {
            CimObject cimObject = (CimObject)object;
            cIMObjectPathArray = new CIMObjectPath[]{cimObject.getObjectPath()};
        } else if (object instanceof CIMObjectPath[]) {
            cIMObjectPathArray = (CIMObjectPath[])object;
        } else if (object instanceof CIMObjectPath) {
            cIMObjectPathArray = new CIMObjectPath[]{(CIMObjectPath)object};
        }
        return cIMObjectPathArray;
    }

    public StorageSystem(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        super(cimContext, cIMObjectPath);
    }

    public StorageSystem(CimContext cimContext, ComputerSystem computerSystem) {
        this(cimContext, computerSystem.getObjectPath());
    }

    public final ConfigService getConfigService() {
        if (this.myConfigService == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_HostedService", "CIM_StorageConfigurationService");
            this.myConfigService = ConfigService.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myConfigService != null ? 1 : 0) != 0, (String)"result != null");
        return this.myConfigService;
    }

    public final ControllerConfigService getControllerConfigService() {
        if (this.myControllerConfigService == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_HostedService", "CIM_ControllerConfigurationService");
            this.myControllerConfigService = ControllerConfigService.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myControllerConfigService != null ? 1 : 0) != 0, (String)"result != null");
        return this.myControllerConfigService;
    }

    public final MaskingCapabilities getMaskingCapabilities() {
        if (this.myMaskingCapabilities == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementCapabilities", "CIM_ProtocolControllerMaskingCapabilities");
            this.myMaskingCapabilities = MaskingCapabilities.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myMaskingCapabilities != null ? 1 : 0) != 0, (String)"result != null");
        return this.myMaskingCapabilities;
    }

    public final Pool[] getPools() {
        if (this.myPools == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_HostedStoragePool", "CIM_StoragePool");
            this.myPools = Pool.create(this, cIMObjectPathArray);
        }
        return this.myPools;
    }

    public final Pool getPool(String string) {
        Pool pool = null;
        if (string != null) {
            String[] stringArray = new String[]{"InstanceID='" + string + "'"};
            CIMObjectPath cIMObjectPath = this.queryName("CIM_StoragePool", stringArray);
            if (cIMObjectPath != null) {
                this.traceFinest("    found pool = " + cIMObjectPath);
                pool = new Pool(this, cIMObjectPath);
            } else {
                pool = this.findPool(string);
            }
        }
        return pool;
    }

    private Pool findPool(String string) {
        Pool pool = null;
        if (string != null) {
            Pool[] poolArray = this.getPools();
            int n = 0;
            while (n < poolArray.length) {
                Pool pool2 = poolArray[n];
                String string2 = pool2.getPropertyValue("InstanceID").getStringValue();
                this.traceFinest("    candidate pool: " + string2);
                if (string.equals(string2)) {
                    this.traceFinest("        found pool = " + string2);
                    pool = pool2;
                    break;
                }
                ++n;
            }
        }
        return pool;
    }

    public final PrimordialPool[] getPrimordialPools() {
        if (this.myPrimordialPools == null) {
            Pool[] poolArray = this.getPools();
            this.myPrimordialPools = PrimordialPool.create(this, poolArray);
        }
        return this.myPrimordialPools;
    }

    public final PrimordialPool getPrimordialPool(String string) {
        Pool pool;
        PrimordialPool primordialPool = null;
        if (string != null && (pool = this.getPool(string)).isPrimordial()) {
            primordialPool = new PrimordialPool(this, pool.getObjectPath());
        }
        return primordialPool;
    }

    public final AllocatedPool[] getAllocatedPools() {
        if (this.myAllocatedPools == null) {
            Pool[] poolArray = this.getPools();
            this.myAllocatedPools = AllocatedPool.create(this, poolArray);
        }
        return this.myAllocatedPools;
    }

    public final AllocatedPool getAllocatedPool(String string) {
        Pool pool;
        AllocatedPool allocatedPool = null;
        if (string != null && (pool = this.getPool(string)).isAllocated()) {
            allocatedPool = new AllocatedPool(this, pool.getObjectPath());
        }
        return allocatedPool;
    }

    public final StorageSystem clearVolumes() {
        this.myVolumes = null;
        return this;
    }

    public final Volume[] getVolumes() {
        if (this.myVolumes == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_StorageVolume");
            this.myVolumes = Volume.create(this, cIMObjectPathArray);
        }
        return this.myVolumes;
    }

    public final Volume getVolume(String string) {
        Volume volume = null;
        if (string != null) {
            String string2 = this.getName();
            String[] stringArray = new String[]{"SystemName='" + string2 + "'", "DeviceID='" + string + "'"};
            CIMObjectPath cIMObjectPath = this.queryName("CIM_StorageVolume", stringArray);
            if (cIMObjectPath != null) {
                this.traceFinest("    found volume = " + cIMObjectPath);
                volume = new Volume(this, cIMObjectPath);
            } else {
                volume = this.findVolume(string);
            }
        }
        return volume;
    }

    private Volume findVolume(String string) {
        Volume volume = null;
        if (string != null) {
            Volume[] volumeArray = this.getVolumes();
            int n = 0;
            while (n < volumeArray.length) {
                Volume volume2 = volumeArray[n];
                String string2 = volume2.getPropertyValue("Name").getStringValue();
                String string3 = volume2.getPropertyValue("DeviceID").getStringValue();
                this.traceFinest("    candidate volume: " + string2);
                if (string.equalsIgnoreCase(string2) || string.equalsIgnoreCase(string3)) {
                    this.traceFinest("        found volume = " + string2);
                    volume = volume2;
                    break;
                }
                ++n;
            }
        }
        return volume;
    }

    public final FCPort[] getFCPorts() {
        if (this.myFCPorts == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_FCPort", "getFCPorts");
            this.myFCPorts = FCPort.create(this, cIMObjectPathArray);
        }
        return this.myFCPorts;
    }

    public final long getArraySize() {
        long l = 0L;
        PrimordialPool[] primordialPoolArray = this.getPrimordialPools();
        int n = 0;
        while (n < primordialPoolArray.length) {
            l += primordialPoolArray[n].getTotalManagedSpace();
            ++n;
        }
        return l;
    }

    public final long getUnallocatedSpace() {
        long l = 0L;
        PrimordialPool[] primordialPoolArray = this.getPrimordialPools();
        int n = 0;
        while (n < primordialPoolArray.length) {
            l += primordialPoolArray[n].getUnallocatedSpace();
            ++n;
        }
        return l;
    }

    public ProductData getVitalProductData() {
        FCPort[] fCPortArray;
        ProductData productData = super.getVitalProductData();
        if (productData != null && (fCPortArray = this.getFCPorts()) != null && fCPortArray.length > 0) {
            String[] stringArray = FCPort.toNameStrings(fCPortArray);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            productData.setPortWWN(stringBuffer.toString());
            if (productData.getHostWWN() == null) {
                productData.setHostWWN(stringArray[0]);
            }
        }
        return productData;
    }

    public final HardwareIDManagementService getHardwareIDManagementService() {
        if (this.myHardwareIDManagementService == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_HostedService", "CIM_StorageHardwareIDManagementService");
            this.myHardwareIDManagementService = HardwareIDManagementService.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myHardwareIDManagementService != null ? 1 : 0) != 0, (String)"result != null");
        return this.myHardwareIDManagementService;
    }

    public final PrivilegeManagementService getPrivilegeManagementService() {
        if (this.myPrivilegeManagementService == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_HostedService", "CIM_PrivilegeManagementService");
            this.myPrivilegeManagementService = PrivilegeManagementService.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myPrivilegeManagementService != null ? 1 : 0) != 0, (String)"result != null");
        return this.myPrivilegeManagementService;
    }

    public final StorageSystem[] getComponentStorageSystems() {
        if (this.myComponentStorageSystems == null) {
            this.myComponentStorageSystems = StorageSystem.create((CimObjectManager)this.getContext(), this.getComponentSystems());
        }
        Contract.ensures((this.myComponentStorageSystems != null ? 1 : 0) != 0, (String)"result != null");
        return this.myComponentStorageSystems;
    }

    public final CIMObjectPath[] getAssociatedNames(String string, String string2, String string3) {
        String string4 = this.traceEntry("getAssociatedNames()", new Object[]{string, string2, string3});
        CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames(string, string2);
        if (this.isCluster()) {
            Object object;
            StorageSystem[] storageSystemArray = this.getComponentStorageSystems();
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            HashSet<String> hashSet = new HashSet<String>();
            if (cIMObjectPathArray != null && cIMObjectPathArray.length > 0) {
                int n = 0;
                while (n < cIMObjectPathArray.length) {
                    CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
                    object = cIMObjectPath.toString();
                    hashSet.add((String)object);
                    arrayList.add(cIMObjectPath);
                    ++n;
                }
            }
            try {
                Method method = (class$com$sun$netstorage$mgmt$esm$model$cim$ingredients$array$StorageSystem == null ? (class$com$sun$netstorage$mgmt$esm$model$cim$ingredients$array$StorageSystem = StorageSystem.class$("com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem")) : class$com$sun$netstorage$mgmt$esm$model$cim$ingredients$array$StorageSystem).getMethod(string3, null);
                if (method != null && storageSystemArray != null) {
                    this.traceFinest("Invoking " + string3 + " from each unit.");
                    int n = 0;
                    while (n < storageSystemArray.length) {
                        object = method.invoke((Object)storageSystemArray[n], null);
                        CIMObjectPath[] cIMObjectPathArray2 = StorageSystem.toObjectPaths(object);
                        if (cIMObjectPathArray2 != null && cIMObjectPathArray2.length > 0) {
                            int n2 = 0;
                            while (n2 < cIMObjectPathArray2.length) {
                                CIMObjectPath cIMObjectPath = cIMObjectPathArray2[n2];
                                String string5 = cIMObjectPath.toString();
                                if (!hashSet.contains(string5)) {
                                    hashSet.add(string5);
                                    arrayList.add(cIMObjectPath);
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                this.traceError("should never happen:" + exception);
            }
            cIMObjectPathArray = arrayList.toArray(new CIMObjectPath[arrayList.size()]);
        }
        return cIMObjectPathArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

