/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public final class PrimordialPool
extends Pool {
    private static final String SCCS_ID = "@(#)PrimordialPool.java 1.7   03/08/08 SMI";
    private AllocatedPool[] myAllocatedPools = null;

    public static PrimordialPool createPP(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        PrimordialPool primordialPool = null;
        if (cIMObjectPath != null) {
            primordialPool = new PrimordialPool(storageSystem, cIMObjectPath);
        }
        return primordialPool;
    }

    public static PrimordialPool[] create(StorageSystem storageSystem, Pool[] poolArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        PrimordialPool[] primordialPoolArray = null;
        if (poolArray != null) {
            ArrayList<PrimordialPool> arrayList = new ArrayList<PrimordialPool>(poolArray.length);
            int n = 0;
            while (n < poolArray.length) {
                Pool pool = poolArray[n];
                if (pool != null && pool.isPrimordial()) {
                    CIMObjectPath cIMObjectPath = pool.getObjectPath();
                    PrimordialPool primordialPool = new PrimordialPool(storageSystem, cIMObjectPath);
                    arrayList.add(primordialPool);
                }
                ++n;
            }
            primordialPoolArray = arrayList.toArray(new PrimordialPool[arrayList.size()]);
        } else {
            primordialPoolArray = new PrimordialPool[]{};
        }
        Contract.ensures((primordialPoolArray != null ? 1 : 0) != 0, (String)"result != null");
        return primordialPoolArray;
    }

    public PrimordialPool(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
    }

    public final void clearAllocatedPools() {
        this.myAllocatedPools = null;
    }

    public final AllocatedPool[] getAllocatedPools() {
        if (this.myAllocatedPools == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            this.myAllocatedPools = AllocatedPool.create(this, cIMObjectPathArray);
        }
        return this.myAllocatedPools;
    }

    public final void createPool(VolumeSetting volumeSetting, long l, AllocatedPool[] allocatedPoolArray, ConfigJob[] configJobArray) {
        this.getStorageSystem().getConfigService().createPool(this, volumeSetting, l, allocatedPoolArray, configJobArray);
    }

    public final void deletePool(AllocatedPool allocatedPool, ConfigJob[] configJobArray) {
        this.getStorageSystem().getConfigService().deletePool(allocatedPool, configJobArray);
        this.myAllocatedPools = null;
    }

    public final long[] getSupportedSizes(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizes(volumeSetting, 2);
        return lArray;
    }

    public final long[] getSupportedSizeRange(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizeRange(volumeSetting, 2);
        return lArray;
    }
}

