/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Identity;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public final class HardwareID
extends Identity {
    private static final String SCCS_ID = "@(#)HardwareID.java 1.5   04/02/25 SMI";
    private final StorageSystem myStorageSystem;
    private Privilege[] myPrivileges = null;

    public static HardwareID create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        HardwareID hardwareID = null;
        if (cIMObjectPath != null) {
            hardwareID = new HardwareID(storageSystem, cIMObjectPath);
        }
        return hardwareID;
    }

    public static HardwareID[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        Contract.requires((cIMObjectPathArray != null ? 1 : 0) != 0, (String)"theNames != null");
        HardwareID[] hardwareIDArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<HardwareID> arrayList = new ArrayList<HardwareID>(cIMObjectPathArray.length);
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
                if (cIMObjectPath != null) {
                    HardwareID hardwareID = new HardwareID(storageSystem, cIMObjectPath);
                    arrayList.add(hardwareID);
                }
                ++n;
            }
            hardwareIDArray = arrayList.toArray(new HardwareID[arrayList.size()]);
        } else {
            hardwareIDArray = new HardwareID[]{};
        }
        Contract.ensures((hardwareIDArray != null ? 1 : 0) != 0, (String)"result != null");
        return hardwareIDArray;
    }

    public static String[] toStringNames(HardwareID[] hardwareIDArray) {
        Contract.requires((hardwareIDArray != null ? 1 : 0) != 0, (String)"theHardwareIDs != null");
        String[] stringArray = new String[hardwareIDArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = hardwareIDArray[n].getStorageID();
            ++n;
        }
        return stringArray;
    }

    static HardwareID getHardwareID(HardwareID[] hardwareIDArray, String string) {
        Contract.requires((hardwareIDArray != null ? 1 : 0) != 0, (String)"theHardwareIDs != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theID != null");
        HardwareID hardwareID = null;
        int n = 0;
        while (n < hardwareIDArray.length) {
            if (hardwareIDArray[n].matches(string)) {
                hardwareID = hardwareIDArray[n];
                break;
            }
            ++n;
        }
        return hardwareID;
    }

    public HardwareID(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final Privilege[] getPrivileges() {
        if (this.myPrivileges == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AuthorizedSubject", "CIM_Privilege");
            this.myPrivileges = Privilege.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        Contract.ensures((this.myPrivileges != null ? 1 : 0) != 0, (String)"myPrivileges != null");
        return this.myPrivileges;
    }

    public String getStorageID() {
        return this.getPropertyValue("StorageID").getStringValue();
    }

    public int getIDType() {
        return this.getPropertyValue("IDType").intValue();
    }

    public boolean matches(String string) {
        return this.getStorageID().equalsIgnoreCase(string);
    }

    public String toString() {
        return this.getStorageID().toUpperCase();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof HardwareID) {
            HardwareID hardwareID = (HardwareID)object;
            if (this.getStorageID().equalsIgnoreCase(hardwareID.getStorageID())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

