/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_StorageConfigurationService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import javax.wbem.cim.CIMObjectPath;

public final class ConfigService
extends AbstractService {
    private static final String SCCS_ID = "@(#)ConfigService.java 1.9   03/08/12 SMI";
    private final StorageSystem myStorageSystem;
    private ConfigCapabilities myConfigCapabilities = null;
    private ConfigJob[] myConfigJobs = null;

    public static ConfigService create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        ConfigService configService = null;
        if (cIMObjectPath != null) {
            configService = new ConfigService(storageSystem, cIMObjectPath);
        }
        return configService;
    }

    public ConfigService(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final ConfigCapabilities getConfigCapabilities() {
        if (this.myConfigCapabilities == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementCapabilities", "CIM_StorageConfigurationCapabilities");
            this.myConfigCapabilities = ConfigCapabilities.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myConfigCapabilities != null ? 1 : 0) != 0, (String)"myConfigCapabilities != null");
        return this.myConfigCapabilities;
    }

    public final void clearConfigJobs() {
        this.myConfigJobs = null;
    }

    public final ConfigJob[] getConfigJobs() {
        if (this.myConfigJobs == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_OwningJobElement", "CIM_ConcreteJob");
            this.myConfigJobs = ConfigJob.create(this, cIMObjectPathArray);
        }
        return this.myConfigJobs;
    }

    private ConfigJob getConfigJob(CimArgumentMap cimArgumentMap, String string, boolean bl) {
        ConfigJob configJob = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            configJob = new ConfigJob(this, cIMObjectPath);
        } else if (bl) {
            // empty if block
        }
        return configJob;
    }

    private ConfigJob getConfigJob(CimArgumentMap cimArgumentMap, String string) {
        return this.getConfigJob(cimArgumentMap, string, true);
    }

    private AllocatedPool getAllocatedPool(PrimordialPool primordialPool, CimArgumentMap cimArgumentMap, String string) {
        AllocatedPool allocatedPool = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            allocatedPool = new AllocatedPool(primordialPool, cIMObjectPath);
        }
        return allocatedPool;
    }

    private Volume getVolume(AllocatedPool allocatedPool, CimArgumentMap cimArgumentMap, String string) {
        Volume volume = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            volume = new Volume(allocatedPool, cIMObjectPath);
        }
        return volume;
    }

    public final void createPool(PrimordialPool primordialPool, VolumeSetting volumeSetting, long l, AllocatedPool[] allocatedPoolArray, ConfigJob[] configJobArray) {
        Contract.requires((primordialPool != null ? 1 : 0) != 0, (String)"theSourcePool != null");
        Contract.requires((volumeSetting != null ? 1 : 0) != 0, (String)"theGoal != null");
        Contract.requires((l > 0L ? 1 : 0) != 0, (String)"theSize > 0");
        Contract.requires((allocatedPoolArray != null ? 1 : 0) != 0, (String)"thePool != null");
        Contract.requires((allocatedPoolArray.length == 1 ? 1 : 0) != 0, (String)"thePool.length == 1");
        Contract.requires((configJobArray != null ? 1 : 0) != 0, (String)"theJob != null");
        Contract.requires((configJobArray.length == 1 ? 1 : 0) != 0, (String)"theJob.length == 1");
        CimArgumentMap cimArgumentMap = CIM_StorageConfigurationService.CreateOrModifyStoragePool.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageConfigurationService.CreateOrModifyStoragePool.Factory.createOutputs();
        CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_StoragePool");
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("CIM_StorageExtent");
        Object[] objectArray = new String[]{cIMObjectPath2.toString()};
        Object[] objectArray2 = new String[]{primordialPool.getObjectPath().toString()};
        cimArgumentMap.getValue("Pool").setValue(cIMObjectPath);
        cimArgumentMap.getValue("Goal").setValue(volumeSetting);
        cimArgumentMap.getValue("Size").setValue(l, CimValue.NumberType.UINT64);
        cimArgumentMap.getValue("InPools").setValue(objectArray2);
        cimArgumentMap.getValue("InExtents").setValue(objectArray);
        int n = this.intMethod("CreateOrModifyStoragePool", cimArgumentMap, cimArgumentMap2);
        switch (n) {
            case 0: {
                allocatedPoolArray[0] = this.getAllocatedPool(primordialPool, cimArgumentMap2, "Pool");
                if (allocatedPoolArray[0] != null) break;
                break;
            }
            case 4096: {
                configJobArray[0] = this.getConfigJob(cimArgumentMap2, "Job");
                allocatedPoolArray[0] = this.getAllocatedPool(primordialPool, cimArgumentMap2, "Pool");
                break;
            }
            default: {
                this.handleReturnCode(n, CIM_StorageConfigurationService.CreateOrModifyStoragePool.VALUE_MAP, CIM_StorageConfigurationService.CreateOrModifyStoragePool.VALUES);
            }
        }
    }

    public final void deletePool(AllocatedPool allocatedPool, ConfigJob[] configJobArray) {
        Contract.requires((allocatedPool != null ? 1 : 0) != 0, (String)"thePool != null");
        Contract.requires((configJobArray != null ? 1 : 0) != 0, (String)"theJob != null");
        Contract.requires((configJobArray.length == 1 ? 1 : 0) != 0, (String)"theJob.length == 1");
        CimArgumentMap cimArgumentMap = CIM_StorageConfigurationService.DeleteStoragePool.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageConfigurationService.DeleteStoragePool.Factory.createOutputs();
        cimArgumentMap.getValue("Pool").setValue(allocatedPool);
        int n = this.intMethod("DeleteStoragePool", cimArgumentMap, cimArgumentMap2);
        switch (n) {
            case 0: {
                break;
            }
            case 4096: {
                configJobArray[0] = this.getConfigJob(cimArgumentMap2, "Job");
                break;
            }
            default: {
                this.handleReturnCode(n, CIM_StorageConfigurationService.DeleteStoragePool.VALUE_MAP, CIM_StorageConfigurationService.DeleteStoragePool.VALUES);
            }
        }
    }

    public final void createVolume(AllocatedPool allocatedPool, VolumeSetting volumeSetting, long l, Volume[] volumeArray, ConfigJob[] configJobArray) {
        Contract.requires((allocatedPool != null ? 1 : 0) != 0, (String)"theSourcePool != null");
        Contract.requires((volumeSetting != null ? 1 : 0) != 0, (String)"theGoal != null");
        Contract.requires((l > 0L ? 1 : 0) != 0, (String)"theSize > 0");
        Contract.requires((volumeArray != null ? 1 : 0) != 0, (String)"theVolume != null");
        Contract.requires((volumeArray.length == 1 ? 1 : 0) != 0, (String)"theVolume.length == 1");
        Contract.requires((configJobArray != null ? 1 : 0) != 0, (String)"theJob != null");
        Contract.requires((configJobArray.length == 1 ? 1 : 0) != 0, (String)"theJob.length == 1");
        CimArgumentMap cimArgumentMap = CIM_StorageConfigurationService.CreateOrModifyElementFromStoragePool.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageConfigurationService.CreateOrModifyElementFromStoragePool.Factory.createOutputs();
        cimArgumentMap.getValue("ElementName");
        cimArgumentMap.getValue("ElementType").setValue(2, CimValue.NumberType.UINT16);
        cimArgumentMap.getValue("Goal").setValue(volumeSetting);
        cimArgumentMap.getValue("Size").setValue(l, CimValue.NumberType.UINT64);
        cimArgumentMap.getValue("InPool").setValue(allocatedPool);
        int n = this.intMethod("CreateOrModifyElementFromStoragePool", cimArgumentMap, cimArgumentMap2);
        switch (n) {
            case 0: {
                volumeArray[0] = this.getVolume(allocatedPool, cimArgumentMap2, "TheElement");
                if (volumeArray[0] != null) break;
                break;
            }
            case 4096: {
                configJobArray[0] = this.getConfigJob(cimArgumentMap2, "Job");
                volumeArray[0] = this.getVolume(allocatedPool, cimArgumentMap2, "TheElement");
                break;
            }
            default: {
                this.handleReturnCode(n, CIM_StorageConfigurationService.CreateOrModifyElementFromStoragePool.VALUE_MAP, CIM_StorageConfigurationService.CreateOrModifyElementFromStoragePool.VALUES);
            }
        }
    }

    public final void deleteVolume(Volume volume, ConfigJob[] configJobArray) {
        Contract.requires((volume != null ? 1 : 0) != 0, (String)"theVolume != null");
        Contract.requires((configJobArray != null ? 1 : 0) != 0, (String)"theJob != null");
        Contract.requires((configJobArray.length == 1 ? 1 : 0) != 0, (String)"theJob.length == 1");
        CimArgumentMap cimArgumentMap = CIM_StorageConfigurationService.ReturnToStoragePool.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageConfigurationService.ReturnToStoragePool.Factory.createOutputs();
        cimArgumentMap.getValue("TheElement").setValue(volume);
        int n = this.intMethod("ReturnToStoragePool", cimArgumentMap, cimArgumentMap2);
        switch (n) {
            case 0: {
                break;
            }
            case 4096: {
                configJobArray[0] = this.getConfigJob(cimArgumentMap2, "Job");
                break;
            }
            default: {
                this.handleReturnCode(n, CIM_StorageConfigurationService.ReturnToStoragePool.VALUE_MAP, CIM_StorageConfigurationService.ReturnToStoragePool.VALUES);
            }
        }
    }
}

