/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public final class AllocatedPool
extends Pool {
    private static final String SCCS_ID = "@(#)AllocatedPool.java 1.7   03/10/27 SMI";
    private PrimordialPool myPrimordialPool = null;
    private Volume[] myVolumes = null;
    private VolumeSetting myVolumeSetting = null;

    public static AllocatedPool createAP(PrimordialPool primordialPool, CIMObjectPath cIMObjectPath) {
        Contract.requires((primordialPool != null ? 1 : 0) != 0, (String)"theParent != null");
        AllocatedPool allocatedPool = null;
        if (cIMObjectPath != null) {
            allocatedPool = new AllocatedPool(primordialPool, cIMObjectPath);
        }
        return allocatedPool;
    }

    public static AllocatedPool[] create(PrimordialPool primordialPool, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((primordialPool != null ? 1 : 0) != 0, (String)"theParent != null");
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        AllocatedPool[] allocatedPoolArray = new AllocatedPool[n];
        int n2 = 0;
        while (n2 < n) {
            allocatedPoolArray[n2] = new AllocatedPool(primordialPool, cIMObjectPathArray[n2]);
            ++n2;
        }
        Contract.ensures((allocatedPoolArray != null ? 1 : 0) != 0, (String)"result != null");
        return allocatedPoolArray;
    }

    public static AllocatedPool[] create(StorageSystem storageSystem, Pool[] poolArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        AllocatedPool[] allocatedPoolArray = null;
        if (poolArray != null) {
            ArrayList<AllocatedPool> arrayList = new ArrayList<AllocatedPool>(poolArray.length);
            int n = 0;
            while (n < poolArray.length) {
                Pool pool = poolArray[n];
                if (pool != null && pool.isAllocated()) {
                    CIMObjectPath cIMObjectPath = pool.getObjectPath();
                    AllocatedPool allocatedPool = new AllocatedPool(storageSystem, cIMObjectPath);
                    arrayList.add(allocatedPool);
                }
                ++n;
            }
            allocatedPoolArray = arrayList.toArray(new AllocatedPool[arrayList.size()]);
        } else {
            allocatedPoolArray = new AllocatedPool[]{};
        }
        Contract.ensures((allocatedPoolArray != null ? 1 : 0) != 0, (String)"result != null");
        return allocatedPoolArray;
    }

    public AllocatedPool(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
    }

    public AllocatedPool(PrimordialPool primordialPool, CIMObjectPath cIMObjectPath) {
        this(primordialPool.getStorageSystem(), cIMObjectPath);
        this.myPrimordialPool = primordialPool;
    }

    public final PrimordialPool getPrimordialPool() {
        if (this.myPrimordialPool == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            this.myPrimordialPool = PrimordialPool.createPP(this.getStorageSystem(), cIMObjectPath);
        }
        return this.myPrimordialPool;
    }

    public final Volume[] getVolumes() {
        if (this.myVolumes == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AllocatedFromStoragePool", "CIM_StorageVolume");
            this.myVolumes = Volume.create(this, cIMObjectPathArray);
        }
        return this.myVolumes;
    }

    public final VolumeSetting getVolumeSetting() {
        PoolCapabilities poolCapabilities;
        if (this.myVolumeSetting == null && (poolCapabilities = this.getCapabilities()) != null) {
            this.myVolumeSetting = poolCapabilities.createGoalSetting();
        }
        return this.myVolumeSetting;
    }

    public final void createVolume(VolumeSetting volumeSetting, long l, Volume[] volumeArray, ConfigJob[] configJobArray) {
        this.getStorageSystem().getConfigService().createVolume(this, volumeSetting, l, volumeArray, configJobArray);
    }

    public final void deleteVolume(Volume volume, ConfigJob[] configJobArray) {
        this.getStorageSystem().getConfigService().deleteVolume(volume, configJobArray);
        this.myVolumes = null;
    }

    public final long[] getSupportedSizes(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizes(volumeSetting, 3);
        return lArray;
    }

    public final long[] getSupportedSizeRange(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizeRange(volumeSetting, 3);
        return lArray;
    }
}

