/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class Tracer {
    private static final String SCCS_ID = "@(#)Tracer.java 1.2  03/12/01 SMI";
    public static final String LOGGER_NAME = (class$com$sun$netstorage$mgmt$esm$model$cim$Tracer == null ? (class$com$sun$netstorage$mgmt$esm$model$cim$Tracer = Tracer.class$("com.sun.netstorage.mgmt.esm.model.cim.Tracer")) : class$com$sun$netstorage$mgmt$esm$model$cim$Tracer).getPackage().getName();
    public static final int FILE_LIMIT = 512000;
    public static final int FILE_COUNT = 10;
    private static Tracer ourInstance = null;
    public static final String LEVEL_PROPERTY = "cim.trace.level";
    public static final String LEVEL_DEFAULT = null;
    public static final String DESTINATION_PROPERTY = "cim.trace.destination";
    public static final String DESTINATION_DEFAULT = "console";
    private final boolean myEnabled = Tracer.getLevelProperty() != null;
    private Logger myLogger = null;
    private Handler myHandler = null;
    private Level myLevel = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$model$cim$Tracer;

    public static Tracer getInstance() {
        if (ourInstance == null) {
            ourInstance = new Tracer();
        }
        return ourInstance;
    }

    public static String getLevelProperty() {
        return System.getProperty(LEVEL_PROPERTY, LEVEL_DEFAULT);
    }

    public static Level getLevelConfig() {
        Level level = null;
        String string = Tracer.getLevelProperty();
        if (string != null) {
            if ("all".equals(string)) {
                level = Level.ALL;
            } else if ("error".equals(string)) {
                level = Level.SEVERE;
            } else if ("warning".equals(string)) {
                level = Level.WARNING;
            } else if ("info".equals(string)) {
                level = Level.INFO;
            } else if ("fine".equals(string)) {
                level = Level.FINE;
            } else if ("finer".equals(string)) {
                level = Level.FINER;
            } else if ("finest".equals(string)) {
                level = Level.FINEST;
            }
        }
        return level;
    }

    public static String getDestinationProperty() {
        return System.getProperty(DESTINATION_PROPERTY, DESTINATION_DEFAULT);
    }

    public static Handler getDestinationHandler() {
        StreamHandler streamHandler;
        block4: {
            streamHandler = null;
            String string = Tracer.getDestinationProperty();
            if (string == null) break block4;
            if (DESTINATION_DEFAULT.equals(string) || "stdout".equals(string) || "stderr".equals(string)) {
                streamHandler = new ConsoleHandler();
            } else {
                try {
                    streamHandler = new FileHandler(string, 512000, 10);
                }
                catch (IOException iOException) {
                    System.err.println("CANNOT SETUP TRACE FILE: " + string);
                    iOException.printStackTrace(System.err);
                }
            }
        }
        return streamHandler;
    }

    private Tracer() {
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    protected final Logger getLogger() {
        if (this.myLogger == null) {
            this.myLogger = Logger.getLogger(LOGGER_NAME);
            this.myLogger.addHandler(this.getHandler());
            this.myLogger.setLevel(this.getLevel());
            this.myLogger.setUseParentHandlers(false);
        }
        return this.myLogger;
    }

    protected final Handler getHandler() {
        if (this.myHandler == null) {
            this.myHandler = Tracer.getDestinationHandler();
            this.myHandler.setFormatter(new SimpleFormatter());
        }
        return this.myHandler;
    }

    protected final Level getLevel() {
        if (this.myLevel == null) {
            this.myLevel = Tracer.getLevelConfig();
        }
        return this.myLevel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

