/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim;

import com.sun.netstorage.mgmt.esm.model.cim.CimObject;
import com.sun.netstorage.mgmt.esm.model.cim.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.constants.ConstantResources;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.BasicValue;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.LocalizableName;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.LocalizableValue;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Name;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Property;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Value;
import java.math.BigInteger;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public final class CimValue {
    private static final String SCCS_ID = "@(#)CimValue.java 1.7  03/09/30 SMI";
    private CIMValue myDelegate = null;
    private CIMArgument myAssociatedArgument = null;
    private CIMProperty myAssociatedProperty = null;

    public CimValue(CIMValue cIMValue) {
        this.myDelegate = cIMValue;
    }

    CimValue(CIMArgument cIMArgument) {
        this(cIMArgument.getValue());
        this.myAssociatedArgument = cIMArgument;
    }

    CimValue(CIMProperty cIMProperty) {
        this(cIMProperty.getValue());
        this.myAssociatedProperty = cIMProperty;
    }

    public final CIMValue getDelegate() {
        return this.myDelegate;
    }

    protected final void setDelegate(CIMValue cIMValue) {
        this.myDelegate = cIMValue;
        if (this.hasAssociatedArgument()) {
            this.getAssociatedArgument().setValue(this.myDelegate);
        } else if (this.hasAssociatedProperty()) {
            this.getAssociatedProperty().setValue(this.myDelegate);
        }
    }

    boolean hasAssociatedArgument() {
        return this.myAssociatedArgument != null;
    }

    CIMArgument getAssociatedArgument() {
        return this.myAssociatedArgument;
    }

    boolean hasAssociatedProperty() {
        return this.myAssociatedProperty != null;
    }

    CIMProperty getAssociatedProperty() {
        return this.myAssociatedProperty;
    }

    public Object getObjectValue() {
        Object object = null;
        if (this.myDelegate != null) {
            object = this.myDelegate.getValue();
        }
        return object;
    }

    public Vector getVectorValue() {
        Vector<Object> vector = null;
        Object object = this.getObjectValue();
        if (object instanceof Vector) {
            vector = (Vector<Object>)object;
        } else {
            vector = new Vector<Object>();
            if (object != null) {
                vector.add(object);
            }
        }
        return vector;
    }

    public CIMObjectPath getObjectPathValue() {
        CIMObjectPath cIMObjectPath = null;
        Object object = this.getObjectValue();
        if (object instanceof CIMObjectPath) {
            cIMObjectPath = (CIMObjectPath)object;
        }
        return cIMObjectPath;
    }

    public String getStringValue(String string) {
        String string2 = string;
        Object object = this.getObjectValue();
        if (object instanceof String) {
            string2 = (String)object;
        }
        return string2;
    }

    public String getStringValue() {
        return this.getStringValue(null);
    }

    public String[] getStringValues() {
        Vector vector = this.getVectorValue();
        int n = vector != null ? vector.size() : 0;
        String[] stringArray = new String[n];
        if (vector != null) {
            stringArray = vector.toArray(stringArray);
        }
        Contract.ensures((stringArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((stringArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return stringArray;
    }

    public Number getNumberValue(Number number) {
        Number number2;
        block3: {
            Object object;
            block2: {
                number2 = number;
                object = this.getObjectValue();
                if (!(object instanceof Number)) break block2;
                number2 = (Number)object;
                break block3;
            }
            if (!(object instanceof String)) break block3;
            String string = (String)object;
            try {
                number2 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return number2;
    }

    public Number getNumberValue() {
        return this.getNumberValue(null);
    }

    public Number[] getNumberValues() {
        Vector vector = this.getVectorValue();
        int n = vector != null ? vector.size() : 0;
        Number[] numberArray = new Number[n];
        if (vector != null) {
            numberArray = vector.toArray(numberArray);
        }
        Contract.ensures((numberArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((numberArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return numberArray;
    }

    private BigInteger toBigInteger(Number number) {
        return this.toBigInteger(number, BigInteger.ZERO);
    }

    private BigInteger toBigInteger(Number number, BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        if (number instanceof BigInteger) {
            bigInteger2 = (BigInteger)number;
        } else if (number instanceof UnsignedInt64) {
            UnsignedInt64 unsignedInt64 = (UnsignedInt64)number;
            bigInteger2 = unsignedInt64.bigIntValue();
        } else {
            bigInteger2 = number != null ? new BigInteger(number.toString()) : bigInteger;
        }
        return bigInteger2;
    }

    public BigInteger getBigIntegerValue(BigInteger bigInteger) {
        Number number = this.getNumberValue(bigInteger);
        BigInteger bigInteger2 = this.toBigInteger(number, bigInteger);
        return bigInteger2;
    }

    public BigInteger getBigIntegerValue() {
        return this.getBigIntegerValue(null);
    }

    public BigInteger[] getBigIntegerValues() {
        Number[] numberArray = this.getNumberValues();
        BigInteger[] bigIntegerArray = new BigInteger[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            bigIntegerArray[n] = this.toBigInteger(numberArray[n]);
            ++n;
        }
        Contract.ensures((bigIntegerArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((bigIntegerArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return bigIntegerArray;
    }

    byte byteValue(Byte by) {
        Contract.requires((by != null ? 1 : 0) != 0, (String)"theDefault != null");
        Number number = this.getNumberValue(by);
        return number.byteValue();
    }

    public byte byteValue(byte by) {
        return this.byteValue(new Byte(by));
    }

    public byte byteValue() {
        return this.byteValue((byte)-128);
    }

    public byte[] byteValues() {
        Number[] numberArray = this.getNumberValues();
        byte[] byArray = new byte[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            byArray[n] = numberArray[n].byteValue();
            ++n;
        }
        Contract.ensures((byArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((byArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return byArray;
    }

    short shortValue(Short s) {
        Contract.requires((s != null ? 1 : 0) != 0, (String)"theDefault != null");
        Number number = this.getNumberValue(s);
        return number.shortValue();
    }

    public short shortValue(short s) {
        return this.shortValue(new Short(s));
    }

    public short shortValue() {
        return this.shortValue((short)Short.MIN_VALUE);
    }

    public short[] shortValues() {
        Number[] numberArray = this.getNumberValues();
        short[] sArray = new short[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            sArray[n] = numberArray[n].shortValue();
            ++n;
        }
        Contract.ensures((sArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((sArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return sArray;
    }

    int intValue(Integer n) {
        Contract.requires((n != null ? 1 : 0) != 0, (String)"theDefault != null");
        Number number = this.getNumberValue(n);
        return number.intValue();
    }

    public int intValue(int n) {
        return this.intValue(new Integer(n));
    }

    public int intValue() {
        return this.intValue(Integer.MIN_VALUE);
    }

    public int[] intValues() {
        Number[] numberArray = this.getNumberValues();
        int[] nArray = new int[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            nArray[n] = numberArray[n].intValue();
            ++n;
        }
        Contract.ensures((nArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((nArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return nArray;
    }

    long longValue(Long l) {
        Contract.requires((l != null ? 1 : 0) != 0, (String)"theDefault != null");
        Number number = this.getNumberValue(l);
        return number.longValue();
    }

    public long longValue(long l) {
        return this.longValue(new Long(l));
    }

    public long longValue() {
        return this.longValue(Long.MIN_VALUE);
    }

    public long[] longValues() {
        Number[] numberArray = this.getNumberValues();
        long[] lArray = new long[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            lArray[n] = numberArray[n].longValue();
            ++n;
        }
        Contract.ensures((lArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((lArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return lArray;
    }

    float floatValue(Float f) {
        Contract.requires((f != null ? 1 : 0) != 0, (String)"theDefault != null");
        Number number = this.getNumberValue(f);
        return number.floatValue();
    }

    public float floatValue(float f) {
        return this.floatValue(new Float(f));
    }

    public float floatValue() {
        return this.floatValue(Float.MIN_VALUE);
    }

    public float[] floatValues() {
        Number[] numberArray = this.getNumberValues();
        float[] fArray = new float[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            fArray[n] = numberArray[n].floatValue();
            ++n;
        }
        Contract.ensures((fArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((fArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return fArray;
    }

    double doubleValue(Double d) {
        Contract.requires((d != null ? 1 : 0) != 0, (String)"theDefault != null");
        Number number = this.getNumberValue(d);
        return number.doubleValue();
    }

    public double doubleValue(double d) {
        return this.doubleValue(new Double(d));
    }

    public double doubleValue() {
        return this.doubleValue(Double.MIN_VALUE);
    }

    public double[] doubleValues() {
        Number[] numberArray = this.getNumberValues();
        double[] dArray = new double[numberArray.length];
        int n = 0;
        while (n < numberArray.length) {
            dArray[n] = numberArray[n].doubleValue();
            ++n;
        }
        Contract.ensures((dArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((dArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return dArray;
    }

    public boolean booleanValue(boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        Object object = this.getObjectValue();
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        return bl2;
    }

    public boolean booleanValue() {
        return this.booleanValue(false);
    }

    public boolean[] booleanValues() {
        Vector vector = this.getVectorValue();
        int n = vector != null ? vector.size() : 0;
        boolean[] blArray = new boolean[n];
        if (vector != null) {
            int n2 = 0;
            while (n2 < n) {
                Boolean bl = (Boolean)vector.get(n2);
                blArray[n2] = bl;
                ++n2;
            }
        }
        Contract.ensures((blArray != null ? 1 : 0) != 0, (String)"result != null");
        Contract.ensures((blArray.length >= 0 ? 1 : 0) != 0, (String)"result.length >= 0");
        return blArray;
    }

    public void setValue(Object object) {
        this.setDelegate(new CIMValue(object));
    }

    public void setValue(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                vector.add(objectArray[n]);
                ++n;
            }
        }
        this.setValue(vector);
    }

    public void setValue(CimObject cimObject) {
        this.setValue(cimObject.getObjectPath());
    }

    public void setValue(CimObject[] cimObjectArray) {
        this.setValue(cimObjectArray, true);
    }

    public void setValue(CimObject[] cimObjectArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (cimObjectArray != null) {
            int n = 0;
            while (n < cimObjectArray.length) {
                if (bl) {
                    vector.add(cimObjectArray[n].getObjectPath().toString());
                } else {
                    vector.add((String)cimObjectArray[n].getObjectPath());
                }
                ++n;
            }
        }
        this.setValue(vector);
    }

    public void setValue(boolean bl) {
        this.setValue(new Boolean(bl));
    }

    private Number toNumber(Number number, NumberType numberType) {
        Contract.requires((number != null ? 1 : 0) != 0, (String)"theNumber != null");
        Contract.requires((numberType != null ? 1 : 0) != 0, (String)"theNumberType != null");
        Number number2 = null;
        boolean bl = numberType.isSigned();
        switch (numberType.getBits()) {
            case 8: {
                number2 = bl ? new Byte(number.byteValue()) : new UnsignedInt8(number.shortValue());
                break;
            }
            case 16: {
                number2 = bl ? new Short(number.shortValue()) : new UnsignedInt16(number.intValue());
                break;
            }
            case 32: {
                number2 = bl ? new Integer(number.intValue()) : new UnsignedInt32(number.longValue());
                break;
            }
            case 64: {
                number2 = bl ? new Long(number.longValue()) : new UnsignedInt64(number.toString());
            }
        }
        Contract.ensures((number2 != null ? 1 : 0) != 0, (String)"result != null");
        return number2;
    }

    public void setValue(byte by) {
        this.setValue(by, NumberType.SINT8);
    }

    public void setValue(byte by, NumberType numberType) {
        Byte by2 = new Byte(by);
        Number number = this.toNumber(by2, numberType);
        this.setValue(number);
    }

    public void setValue(byte[] byArray) {
        this.setValue(byArray, NumberType.SINT8);
    }

    public void setValue(byte[] byArray, NumberType numberType) {
        int n = byArray != null ? byArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        int n2 = 0;
        while (n2 < n) {
            Byte by = new Byte(byArray[n2]);
            Number number = this.toNumber(by, numberType);
            vector.add(number);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(short s) {
        this.setValue(s, NumberType.SINT16);
    }

    public void setValue(short s, NumberType numberType) {
        Short s2 = new Short(s);
        Number number = this.toNumber(s2, numberType);
        this.setValue(number);
    }

    public void setValue(short[] sArray) {
        this.setValue(sArray, NumberType.SINT16);
    }

    public void setValue(short[] sArray, NumberType numberType) {
        int n = sArray != null ? sArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        int n2 = 0;
        while (n2 < n) {
            Short s = new Short(sArray[n2]);
            Number number = this.toNumber(s, numberType);
            vector.add(number);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(int n) {
        this.setValue(n, NumberType.SINT32);
    }

    public void setValue(int n, NumberType numberType) {
        Integer n2 = new Integer(n);
        Number number = this.toNumber(n2, numberType);
        this.setValue(number);
    }

    public void setValue(int[] nArray) {
        this.setValue(nArray, NumberType.SINT32);
    }

    public void setValue(int[] nArray, NumberType numberType) {
        int n = nArray != null ? nArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = new Integer(nArray[n2]);
            Number number = this.toNumber(n3, numberType);
            vector.add(number);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(long l) {
        this.setValue(l, NumberType.SINT64);
    }

    public void setValue(long l, NumberType numberType) {
        Long l2 = new Long(l);
        Number number = this.toNumber(l2, numberType);
        this.setValue(number);
    }

    public void setValue(long[] lArray) {
        this.setValue(lArray, NumberType.SINT64);
    }

    public void setValue(long[] lArray, NumberType numberType) {
        int n = lArray != null ? lArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        int n2 = 0;
        while (n2 < n) {
            Long l = new Long(lArray[n2]);
            Number number = this.toNumber(l, numberType);
            vector.add(number);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(BigInteger bigInteger) {
        this.setValue(bigInteger, NumberType.UINT64);
    }

    public void setValue(BigInteger bigInteger, NumberType numberType) {
        BigInteger bigInteger2 = bigInteger;
        Number number = this.toNumber(bigInteger2, numberType);
        this.setValue(number);
    }

    public void setValue(BigInteger[] bigIntegerArray) {
        this.setValue(bigIntegerArray, NumberType.UINT64);
    }

    public void setValue(BigInteger[] bigIntegerArray, NumberType numberType) {
        int n = bigIntegerArray != null ? bigIntegerArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        int n2 = 0;
        while (n2 < n) {
            BigInteger bigInteger = bigIntegerArray[n2] != null ? bigIntegerArray[n2] : BigInteger.ZERO;
            Number number = this.toNumber(bigInteger, numberType);
            vector.add(number);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(String string, NumberType numberType) {
        BigInteger bigInteger = string != null ? new BigInteger(string) : BigInteger.ZERO;
        Number number = this.toNumber(bigInteger, numberType);
        this.setValue(number);
    }

    public void setValue(String[] stringArray, NumberType numberType) {
        int n = stringArray != null ? stringArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        int n2 = 0;
        while (n2 < n) {
            BigInteger bigInteger = stringArray[n2] != null ? new BigInteger(stringArray[n2]) : BigInteger.ZERO;
            Number number = this.toNumber(bigInteger, numberType);
            vector.add(number);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(float f) {
        this.setValue(new Float(f));
    }

    public void setValue(float[] fArray) {
        int n = fArray != null ? fArray.length : 0;
        Vector<Float> vector = new Vector<Float>(n);
        int n2 = 0;
        while (n2 < n) {
            Float f = new Float(fArray[n2]);
            vector.add(f);
            ++n2;
        }
        this.setValue(vector);
    }

    public void setValue(double d) {
        this.setValue(new Double(d));
    }

    public void setValue(double[] dArray) {
        int n = dArray != null ? dArray.length : 0;
        Vector<Double> vector = new Vector<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            Double d = new Double(dArray[n2]);
            vector.add(d);
            ++n2;
        }
        this.setValue(vector);
    }

    public Property toProperty() {
        Property property = null;
        if (this.hasAssociatedProperty()) {
            String string = this.getAssociatedProperty().getName();
            Resource resource = ConstantResources.getResource(string);
            LocalizableName localizableName = new LocalizableName(resource);
            BasicValue basicValue = null;
            String string2 = this.getStringValue();
            if (string2 != null) {
                resource = ConstantResources.getResource(string2);
                basicValue = new LocalizableValue(resource);
            } else {
                basicValue = new BasicValue(this.getObjectValue());
            }
            property = new Property((Name)localizableName, (Value)basicValue);
        }
        return property;
    }

    public String toString() {
        return "" + this.getObjectValue();
    }

    public static class NumberType {
        public static final int _8 = 8;
        public static final int _16 = 16;
        public static final int _32 = 32;
        public static final int _64 = 64;
        public static final NumberType SINT8 = new NumberType(8, true);
        public static final NumberType SINT16 = new NumberType(16, true);
        public static final NumberType SINT32 = new NumberType(32, true);
        public static final NumberType SINT64 = new NumberType(64, true);
        public static final NumberType UINT8 = new NumberType(8, false);
        public static final NumberType UINT16 = new NumberType(16, false);
        public static final NumberType UINT32 = new NumberType(32, false);
        public static final NumberType UINT64 = new NumberType(64, false);
        private final int myBits;
        private final boolean mySigned;

        private NumberType(int n, boolean bl) {
            this.myBits = n;
            this.mySigned = bl;
        }

        public final int getBits() {
            return this.myBits;
        }

        public final boolean isSigned() {
            return this.mySigned;
        }
    }
}

