/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim;

import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimConnectionException;
import com.sun.netstorage.mgmt.esm.model.cim.CimContext;
import com.sun.netstorage.mgmt.esm.model.cim.CimObjectException;
import com.sun.netstorage.mgmt.esm.model.cim.CimReturnCodeException;
import com.sun.netstorage.mgmt.esm.model.cim.CimSecurityException;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.CimValueMap;
import com.sun.netstorage.mgmt.esm.model.cim.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.Localization;
import com.sun.netstorage.mgmt.esm.model.cim.TraceableObject;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Property;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.PropertyMap;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.CIMTransportException;

public abstract class CimObject
extends TraceableObject
implements CimContext {
    private static final String SCCS_ID = "@(#)CimObject.java 1.22  03/12/04 SMI";
    public static final String WQL = "WQL";
    private final CimContext myContext;
    private final CIMObjectPath myObjectPath;
    private CIMInstance myInstance = null;

    protected static CIMObjectPath[] toObjectPathArray(Enumeration enumeration) {
        CIMObjectPath[] cIMObjectPathArray = null;
        ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                CIMObjectPath cIMObjectPath = null;
                if (e instanceof CIMObjectPath) {
                    cIMObjectPath = (CIMObjectPath)e;
                } else if (e instanceof CIMInstance) {
                    CIMInstance cIMInstance = (CIMInstance)e;
                    cIMObjectPath = cIMInstance.getObjectPath();
                }
                if (cIMObjectPath == null) continue;
                arrayList.add(cIMObjectPath);
            }
        }
        cIMObjectPathArray = arrayList.toArray(new CIMObjectPath[arrayList.size()]);
        return cIMObjectPathArray;
    }

    public static CIMObjectPath toNameSpacePath(String string, String string2) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        if (string == null) {
            string = "";
        }
        if (string2 != null) {
            if (!string2.startsWith("/") && !string2.startsWith("\\")) {
                string2 = "/" + string2;
            }
            cIMObjectPath = new CIMObjectPath(string, string2);
        } else {
            cIMObjectPath = new CIMObjectPath(string);
        }
        return cIMObjectPath;
    }

    public static CIMObjectPath toNameSpacePath(String string) {
        return CimObject.toNameSpacePath(null, string);
    }

    public static boolean equals(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) {
        boolean bl;
        block10: {
            bl = false;
            if (cIMObjectPath != null && cIMObjectPath2 != null) {
                if (cIMObjectPath == cIMObjectPath2) {
                    bl = true;
                } else if (cIMObjectPath.getObjectName().equalsIgnoreCase(cIMObjectPath2.getObjectName()) && cIMObjectPath.getNameSpace().equalsIgnoreCase(cIMObjectPath2.getNameSpace())) {
                    int n;
                    Vector vector = cIMObjectPath.getKeys();
                    Vector vector2 = cIMObjectPath2.getKeys();
                    int n2 = vector.size();
                    if (n2 == (n = vector2.size())) {
                        int n3 = 0;
                        while (n3 < n2) {
                            CIMProperty cIMProperty = (CIMProperty)vector.get(n3);
                            boolean bl2 = false;
                            int n4 = 0;
                            while (n4 < n) {
                                CIMProperty cIMProperty2 = (CIMProperty)vector2.get(n4);
                                if (cIMProperty.getName().equalsIgnoreCase(cIMProperty2.getName())) {
                                    String string;
                                    String string2;
                                    CIMValue cIMValue = cIMProperty.getValue();
                                    CIMValue cIMValue2 = cIMProperty2.getValue();
                                    if (!(cIMValue.getValue() instanceof String && cIMValue2.getValue() instanceof String ? !(string2 = (String)cIMValue.getValue()).equalsIgnoreCase(string = (String)cIMValue2.getValue()) : cIMValue.getValue() != null && !cIMValue.getValue().equals(cIMValue2.getValue()))) {
                                        bl2 = true;
                                        break;
                                    }
                                    break block10;
                                }
                                ++n4;
                            }
                            if (bl2) {
                                ++n3;
                                continue;
                            }
                            break block10;
                        }
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    protected static int canonicalCode(Object object) {
        int n = 0;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object != null) {
            string = object.toString();
        }
        if (string != null) {
            n = string.toLowerCase().hashCode();
        }
        return n;
    }

    protected static final boolean contains(List list, CIMObjectPath cIMObjectPath) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)iterator.next();
            if (!CimObject.equals(cIMObjectPath2, cIMObjectPath)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String createQueryExpr(String string, String string2, String string3) {
        String string4 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(string3);
            stringBuffer.append(' ');
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("'");
            string4 = stringBuffer.toString();
        }
        return string4;
    }

    public static String createQueryEQ(String string, String string2) {
        return CimObject.createQueryExpr(string, string2, "=");
    }

    public CimObject(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        Contract.requires((cimContext != null ? 1 : 0) != 0, (String)"theContext != null");
        this.myContext = cimContext;
        this.myObjectPath = cIMObjectPath;
    }

    protected CimObject(CimObject cimObject) {
        this(cimObject, cimObject.getObjectPath());
    }

    protected final CimContext getContext() {
        return this.myContext;
    }

    public final CIMObjectPath getObjectPath() {
        return this.myObjectPath;
    }

    public final String getNameSpace() {
        return this.myObjectPath != null ? this.myObjectPath.getNameSpace() : null;
    }

    public final boolean hasNameSpace() {
        return this.getNameSpace() != null;
    }

    protected final CIMInstance getInstance() {
        if (this.myInstance == null) {
            String string;
            block3: {
                string = this.traceEntry("getInstance()");
                try {
                    this.checkHandleAndObjectPath();
                    this.myInstance = this.getHandle().getInstance(this.getObjectPath(), false, false, false, null);
                }
                catch (CIMException cIMException) {
                    if ("CIM_ERR_NOT_FOUND".equals(cIMException.getID())) break block3;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("getInstance( ");
                    stringBuffer.append(this.getObjectPath().toString());
                    stringBuffer.append(" )");
                    this.handleException(cIMException, stringBuffer.toString());
                }
            }
            this.traceReturn(string, this.myInstance);
        }
        return this.myInstance;
    }

    protected final void deleteInstance(CIMObjectPath cIMObjectPath) {
        String string = super.traceEntry("deleteInstance(rawInstance)");
        try {
            this.checkHandle();
            CIMOMHandle cIMOMHandle = this.getHandle();
            cIMOMHandle.deleteInstance(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("deleteInstance(" + cIMObjectPath + ")");
            this.handleException(cIMException, stringBuffer.toString());
        }
        super.traceReturn(string);
    }

    protected final void deleteInstance() {
        if (this.myInstance != null) {
            String string = super.traceEntry("deleteInstance()");
            try {
                this.checkHandleAndObjectPath();
                CIMOMHandle cIMOMHandle = this.getHandle();
                CIMObjectPath cIMObjectPath = this.getObjectPath();
                cIMOMHandle.deleteInstance(cIMObjectPath);
            }
            catch (CIMException cIMException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("deleteInstance( ");
                stringBuffer.append(this.getObjectPath().toString());
                stringBuffer.append(", ");
                stringBuffer.append(this.myInstance.toString());
                stringBuffer.append(" )");
                this.handleException(cIMException, stringBuffer.toString());
            }
            super.traceReturn(string);
        }
    }

    protected final void deleteInstances(CIMObjectPath[] cIMObjectPathArray) {
        String string = super.traceEntry("deleteInstances()");
        this.checkHandleAndObjectPath();
        CIMOMHandle cIMOMHandle = this.getHandle();
        CIMObjectPath cIMObjectPath = this.getObjectPath();
        int n = 0;
        while (n < cIMObjectPathArray.length) {
            if (cIMObjectPathArray[n] != null) {
                try {
                    cIMOMHandle.deleteInstance(cIMObjectPathArray[n]);
                    super.traceStep(n, "instance deleted");
                }
                catch (CIMException cIMException) {
                    super.traceStep(n, "instance deletion failed");
                }
            }
            ++n;
        }
        super.traceReturn(string);
    }

    protected final void setInstance() {
        if (this.myInstance != null) {
            String string = this.traceEntry("setInstance()");
            try {
                this.checkHandleAndObjectPath();
                this.getHandle().setInstance(this.getObjectPath(), this.myInstance);
            }
            catch (CIMException cIMException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("setInstance( ");
                stringBuffer.append(this.getObjectPath().toString());
                stringBuffer.append(", ");
                stringBuffer.append(this.myInstance.toString());
                stringBuffer.append(" )");
                this.handleException(cIMException, stringBuffer.toString());
            }
            this.traceReturn(string);
        }
    }

    public final CimValue getPropertyValue(String string, boolean bl) {
        if (bl) {
            this.myInstance = null;
        }
        return this.getPropertyValue(string);
    }

    public final CimValue getPropertyValue(String string) {
        CIMProperty cIMProperty;
        CIMInstance cIMInstance;
        String string2 = this.traceEntry("getPropertyValue()", new Object[]{string});
        CimValue cimValue = null;
        if (string != null && (cIMInstance = this.getInstance()) != null && (cIMProperty = cIMInstance.getProperty(string)) != null) {
            cimValue = new CimValue(cIMProperty);
        }
        if (cimValue == null) {
            cIMInstance = new CIMValue(null);
            cimValue = new CimValue((CIMValue)cIMInstance);
        }
        this.traceReturn(string2, cimValue);
        return cimValue;
    }

    public final PropertyMap toPropertyMap() {
        PropertyMap propertyMap = new PropertyMap();
        CIMInstance cIMInstance = this.getInstance();
        if (cIMInstance != null) {
            Vector vector = cIMInstance.getProperties();
            int n = 0;
            while (n < vector.size()) {
                CimValue cimValue;
                Property property;
                CIMProperty cIMProperty = (CIMProperty)vector.get(n);
                if (cIMProperty != null && (property = (cimValue = new CimValue(cIMProperty)).toProperty()) != null) {
                    propertyMap.put(property);
                }
                ++n;
            }
        }
        return propertyMap;
    }

    public final boolean exists() {
        boolean bl = false;
        this.myInstance = null;
        if (this.getInstance() != null) {
            bl = true;
        }
        return bl;
    }

    protected final void checkHandle() {
        Contract.guarantees((this.getHandle() != null ? 1 : 0) != 0, (String)"getHandle() != null");
    }

    protected final void checkHandleAndObjectPath() {
        Contract.guarantees((this.getHandle() != null ? 1 : 0) != 0, (String)"getHandle() != null");
        Contract.guarantees((this.getObjectPath() != null ? 1 : 0) != 0, (String)"getObjectPath() != null");
    }

    protected final CIMObjectPath[] getNames(String string, String string2) {
        String string3 = this.traceEntry("getNames()", new Object[]{string, string2});
        CIMObjectPath[] cIMObjectPathArray = null;
        CIMObjectPath cIMObjectPath = CimObject.toNameSpacePath(string, string2);
        try {
            this.checkHandle();
            Enumeration enumeration = this.getHandle().enumerateInstanceNames(cIMObjectPath);
            cIMObjectPathArray = CimObject.toObjectPathArray(enumeration);
        }
        catch (CIMException cIMException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("enumerateInstanceNames( namespace=");
            stringBuffer.append(string2);
            stringBuffer.append(", classname=");
            stringBuffer.append(string);
            stringBuffer.append(" )");
            this.handleException(cIMException, stringBuffer.toString());
        }
        this.traceReturn(string3, cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    protected final CIMObjectPath[] getNames(String string) {
        String string2 = this.traceEntry("getNames()", new Object[]{string});
        CIMObjectPath[] cIMObjectPathArray = this.getNames(string, this.getNameSpace());
        this.traceReturn(string2, cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    protected final CIMObjectPath[] queryNames(String string, String string2, String[] stringArray) {
        String string3 = this.traceEntry("queryNames()", new Object[]{string, string2, stringArray});
        CIMObjectPath[] cIMObjectPathArray = null;
        CIMObjectPath cIMObjectPath = CimObject.toNameSpacePath(null, string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT * FROM ");
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(" WHERE ");
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        try {
            this.checkHandle();
            String string4 = stringBuffer.toString();
            Enumeration enumeration = this.getHandle().execQuery(cIMObjectPath, string4, WQL);
            cIMObjectPathArray = CimObject.toObjectPathArray(enumeration);
        }
        catch (CIMException cIMException) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("queryNames( ");
            stringBuffer2.append(cIMObjectPath);
            stringBuffer2.append(", ");
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(" )");
            this.handleException(cIMException, stringBuffer2.toString());
        }
        this.traceReturn(string3, cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    protected final CIMObjectPath[] queryNames(String string, String[] stringArray) {
        String string2 = this.traceEntry("queryNames()", new Object[]{string, stringArray});
        CIMObjectPath[] cIMObjectPathArray = this.queryNames(string, this.getNameSpace(), stringArray);
        this.traceReturn(string2, cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    protected final CIMObjectPath queryName(String string, String[] stringArray) {
        String string2 = this.traceEntry("queryName()", new Object[]{string, stringArray});
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath[] cIMObjectPathArray = this.queryNames(string, stringArray);
        if (cIMObjectPathArray != null && cIMObjectPathArray.length > 0) {
            cIMObjectPath = cIMObjectPathArray[0];
        }
        this.traceReturn(string2, cIMObjectPath);
        return cIMObjectPath;
    }

    protected final CIMObjectPath getAssociatedName(String string, String string2, String string3, String string4) {
        String string5 = this.traceEntry("getAssociatedName()", new Object[]{string, string2, string3, string4});
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames(string, string2, string3, string4);
        if (cIMObjectPathArray != null && cIMObjectPathArray.length > 0) {
            cIMObjectPath = cIMObjectPathArray[0];
        }
        this.traceReturn(string5, cIMObjectPath);
        return cIMObjectPath;
    }

    protected final CIMObjectPath getAssociatedName(String string, String string2) {
        return this.getAssociatedName(string, string2, null, null);
    }

    protected final CIMObjectPath[] getAssociatedNames(String string, String string2, String string3, String string4) {
        String string5 = this.traceEntry("getAssociatedNames()", new Object[]{string, string2, string3, string4});
        CIMObjectPath[] cIMObjectPathArray = null;
        try {
            this.checkHandleAndObjectPath();
            Enumeration enumeration = this.getHandle().associatorNames(this.getObjectPath(), string, string2, string3, string4);
            cIMObjectPathArray = CimObject.toObjectPathArray(enumeration);
        }
        catch (CIMException cIMException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("associatorNames( ");
            stringBuffer.append(this.getObjectPath().toString());
            stringBuffer.append(", ");
            stringBuffer.append(string);
            stringBuffer.append(", ");
            stringBuffer.append(string2);
            stringBuffer.append(", ");
            stringBuffer.append(string3);
            stringBuffer.append(", ");
            stringBuffer.append(string4);
            stringBuffer.append(" )");
            this.handleException(cIMException, stringBuffer.toString());
        }
        this.traceReturn(string5, cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    protected final CIMObjectPath[] getAssociatedNames(String string, String string2) {
        return this.getAssociatedNames(string, string2, null, null);
    }

    protected final CIMObjectPath[] getReferenceNames(String string, String string2) {
        String string3 = this.traceEntry("getReferenceNames()", new Object[]{string, string2});
        CIMObjectPath[] cIMObjectPathArray = null;
        try {
            this.checkHandleAndObjectPath();
            Enumeration enumeration = this.getHandle().referenceNames(this.getObjectPath(), string, string2);
            cIMObjectPathArray = CimObject.toObjectPathArray(enumeration);
        }
        catch (CIMException cIMException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("referenceNames( ");
            stringBuffer.append(this.getObjectPath().toString());
            stringBuffer.append(", ");
            stringBuffer.append(string);
            stringBuffer.append(", ");
            stringBuffer.append(string2);
            stringBuffer.append(" )");
            this.handleException(cIMException, stringBuffer.toString());
        }
        this.traceReturn(string3, cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    protected final CIMObjectPath[] getReferenceNames(String string) {
        return this.getReferenceNames(string, null);
    }

    protected final CIMObjectPath getReferenceName(String string, String string2) {
        String string3 = this.traceEntry("getReferenceName()", new Object[]{string, string2});
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath[] cIMObjectPathArray = this.getReferenceNames(string, string2);
        if (cIMObjectPathArray != null && cIMObjectPathArray.length > 0) {
            cIMObjectPath = cIMObjectPathArray[0];
        }
        this.traceReturn(string3, cIMObjectPath);
        return cIMObjectPath;
    }

    protected final CIMObjectPath getReferenceName(String string) {
        return this.getReferenceName(string, null);
    }

    protected final CimValue invokeMethod(String string, CimArgumentMap cimArgumentMap, CimArgumentMap cimArgumentMap2) {
        String string2;
        String string3 = this.traceEntry("invokeMethod()", new Object[]{string});
        CimValue cimValue = null;
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theMethodName != null");
        Contract.requires((cimArgumentMap != null ? 1 : 0) != 0, (String)"theInputs != null");
        Contract.requires((cimArgumentMap2 != null ? 1 : 0) != 0, (String)"theOutputs != null");
        if (this.isTraceFinest()) {
            string2 = this.toString(string, cimArgumentMap, cimArgumentMap2);
            this.traceFinest(string2);
        }
        try {
            this.checkHandleAndObjectPath();
            string2 = this.getHandle().invokeMethod(this.getObjectPath(), string, cimArgumentMap.toArray(), cimArgumentMap2.toArray());
            if (string2 != null) {
                cimValue = new CimValue((CIMValue)string2);
            }
        }
        catch (CIMException cIMException) {
            String string4 = this.toString(string, cimArgumentMap, cimArgumentMap2);
            this.handleException(cIMException, string4);
        }
        this.traceReturn(string3, cimValue);
        return cimValue;
    }

    private String toString(String string, CimArgumentMap cimArgumentMap, CimArgumentMap cimArgumentMap2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("invokeMethod( ");
        stringBuffer.append(this.getObjectPath().toString());
        stringBuffer.append(", ");
        stringBuffer.append(string);
        stringBuffer.append(",\n\t");
        stringBuffer.append(cimArgumentMap.toString());
        stringBuffer.append(",\n\t");
        stringBuffer.append(cimArgumentMap2.toString());
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected final int intMethod(String string, CimArgumentMap cimArgumentMap, CimArgumentMap cimArgumentMap2) {
        String string2 = this.traceEntry("intMethod()", new Object[]{string});
        int n = Integer.MIN_VALUE;
        CimValue cimValue = this.invokeMethod(string, cimArgumentMap, cimArgumentMap2);
        this.traceFinest("ReturnCode instance: " + cimValue);
        if (cimValue != null) {
            this.traceFinest("ReturnCode type: " + cimValue.getObjectValue().getClass());
            n = cimValue.intValue();
        }
        this.traceReturn(string2, new Integer(n));
        return n;
    }

    protected final long longMethod(String string, CimArgumentMap cimArgumentMap, CimArgumentMap cimArgumentMap2) {
        String string2 = this.traceEntry("longMethod()", new Object[]{string});
        long l = Long.MIN_VALUE;
        CimValue cimValue = this.invokeMethod(string, cimArgumentMap, cimArgumentMap2);
        if (cimValue != null) {
            l = cimValue.longValue();
        }
        this.traceReturn(string2, new Long(l));
        return l;
    }

    protected final void handleReturnCode(int n, String[] stringArray, String[] stringArray2) {
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theValueNumbers != null");
        Contract.requires((stringArray2 != null ? 1 : 0) != 0, (String)"theValueStrings != null");
        Contract.requires((stringArray.length == stringArray2.length ? 1 : 0) != 0, (String)"theValueNumbers.length == theValueStrings.length");
        CimValueMap cimValueMap = new CimValueMap(stringArray, stringArray2);
        Resource resource = cimValueMap.getResource(n);
        this.handleReturnCode(n, resource);
    }

    protected final void handleReturnCode(int n, Resource resource) {
        throw new CimReturnCodeException(n, resource);
    }

    protected final void handleException(Throwable throwable) {
        Resource resource = Localization.RES_INTERNAL_ERROR;
        String[] stringArray = new String[]{throwable.getMessage()};
        throw new CimObjectException(throwable, resource, stringArray);
    }

    protected final void handleException(CIMException cIMException, String string) {
        String string2;
        CimObjectException cimObjectException = null;
        String string3 = this.myContext.toString();
        String string4 = string2 = this.getObjectPath() != null ? this.getObjectPath().toString() : "CIMOM";
        if (this.isTraceError()) {
            this.traceError("\toperation: " + string);
            this.traceError("\texception: " + cIMException.getMessage());
        }
        if (this.isConnectionProblem(cIMException)) {
            cimObjectException = new CimConnectionException((Throwable)cIMException, string3);
        } else if (this.isSecurityProblem(cIMException)) {
            cimObjectException = new CimSecurityException((Throwable)cIMException, string3);
        } else {
            Resource resource = this.toResource(cIMException);
            cimObjectException = new CimObjectException(cIMException, resource);
        }
        this.traceThrowing("transform a CIMException to an unchecked form", (Throwable)((Object)cimObjectException));
        throw cimObjectException;
    }

    private Resource toResource(CIMException cIMException) {
        Resource resource = null;
        resource = Localization.RES_INTERNAL_ERROR;
        return resource;
    }

    private boolean isConnectionProblem(CIMException cIMException) {
        boolean bl = false;
        if (cIMException instanceof CIMTransportException) {
            bl = true;
        } else {
            Object[] objectArray = cIMException.getParams();
            int n = 0;
            while (objectArray != null && n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof ConnectException || object instanceof CIMTransportException) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isSecurityProblem(CIMException cIMException) {
        boolean bl = false;
        if (cIMException instanceof CIMSecurityException) {
            bl = true;
        }
        return bl;
    }

    protected final boolean isDebug() {
        return Boolean.getBoolean("debug");
    }

    public final CIMOMHandle getHandle() {
        return this.myContext.getHandle();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CimObject) {
            CIMObjectPath cIMObjectPath;
            CimObject cimObject = (CimObject)object;
            CIMObjectPath cIMObjectPath2 = this.getObjectPath();
            if (CimObject.equals(cIMObjectPath2, cIMObjectPath = cimObject.getObjectPath())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.myObjectPath != null) {
            Iterator iterator = this.myObjectPath.getKeys().iterator();
            while (iterator.hasNext()) {
                CIMProperty cIMProperty = (CIMProperty)iterator.next();
                if (cIMProperty == null || cIMProperty.getValue() == null) continue;
                n += CimObject.canonicalCode(cIMProperty.getValue());
            }
            if (this.myObjectPath.getHost() != null) {
                n += CimObject.canonicalCode(this.myObjectPath.getHost());
            }
            if (this.myObjectPath.getObjectName() != null) {
                n += CimObject.canonicalCode(this.myObjectPath.getObjectName());
            }
            if (this.myObjectPath.getNameSpace() != null) {
                n += CimObject.canonicalCode(this.myObjectPath.getNameSpace());
            }
        } else {
            n = this.myContext.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.myContext.toString());
        if (this.myObjectPath != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.myObjectPath.toString());
        }
        return stringBuffer.toString();
    }
}

