/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.common;

import com.sun.portal.rewriter.Data;
import com.sun.portal.rewriter.DataRule;
import com.sun.portal.rewriter.RewriterTestInputs;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.ListMap;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TagText
extends DataRule {
    private Data tag;
    private Data attributePatterns;
    private Map parsedAttributePatterns;

    private TagText(String string) {
        super("TextStrings", null);
        this.tag = new Data(StringHelper.normalize(string));
    }

    public TagText(String string, Map map) {
        this(string);
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        this.parsedAttributePatterns = map;
    }

    public TagText(String string, String string2) {
        this(string);
        this.attributePatterns = new Data(StringHelper.normalize(string2));
    }

    public TagText(Node node) {
        this(node.getAttributeValue("tag"), node.getAttributeValue("attributePatterns"));
    }

    public String getTag() {
        return this.tag.value;
    }

    public String getAttributePatterns() {
        if (this.attributePatterns == null) {
            return this.parsedAttributePatterns.toString();
        }
        return this.attributePatterns.value;
    }

    private Map getParsedAttributePatterns() {
        if (this.parsedAttributePatterns == null) {
            this.parsedAttributePatterns = TagText.parseAttributes(this.attributePatterns.value);
        }
        return this.parsedAttributePatterns;
    }

    public boolean matches(DataRule dataRule) {
        if (dataRule == null && !(dataRule instanceof TagText)) {
            return false;
        }
        TagText tagText = (TagText)dataRule;
        if (DataRule.match(this.tag, tagText.tag.value)) {
            Map map = tagText.getParsedAttributePatterns();
            Map map2 = this.getParsedAttributePatterns();
            Object[] objectArray = map2.keySet().toArray();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                Data data = TagText.findMatchingKey(objectArray, string);
                if (data == null) {
                    return false;
                }
                if (DataRule.match((Data)map2.get(data), map.get(string).toString())) continue;
                return false;
            }
            return map.size() >= map2.size();
        }
        return false;
    }

    public boolean isValid() {
        return DataRule.doBasicValidation(new String[]{this.tag.value});
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("<").append("TagText").append(" ").append("tag").append("=").append("\"").append(this.tag).append("\"").append(" ").append("attributePatterns").append("=").append("\"").append(this.getAttributePatterns()).append("\"").append(" ").append("/>").append("\n");
        return stringBuffer.toString();
    }

    private static final Map parseAttributes(String string) {
        List list = DataRule.parsePatterns(string);
        ListMap listMap = new ListMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = StringHelper.splitString(iterator.next().toString(), "=", 2);
            listMap.put(new Data(stringArray[0].trim()), new Data(stringArray[1].trim()));
        }
        return listMap;
    }

    private static Data findMatchingKey(Object[] objectArray, String string) {
        int n = 0;
        while (n < objectArray.length) {
            if (DataRule.match((Data)objectArray[n], string)) {
                return (Data)objectArray[n];
            }
            ++n;
        }
        return null;
    }

    public static TagText cycleMatche(TagText tagText, String string, Map map) {
        tagText.tag.value = string;
        tagText.parsedAttributePatterns = map;
        return tagText;
    }

    public static void main(String[] stringArray) {
        TagText[] tagTextArray = RewriterTestInputs.defaultXMLTextStrings;
        int n = 0;
        while (n < tagTextArray.length) {
            Debug.println(tagTextArray[n].toXML());
            ++n;
        }
    }
}

