/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.GWDebug;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class BasicAuthentication {
    private static final String HOST_ALREADY_DONE_LIST = "list-Hosts-Basic-Authentication-Done";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getPassword(Request req, String destinationHost) {
        String password = null;
        if (destinationHost == null) {
            return false;
        }
        try {
            boolean doSSOPerSess;
            String sid = req.getSessionID();
            sid = URLDecoder.decode(sid).trim();
            UserProfile _userProfile = new UserProfile(sid);
            String destHost = destinationHost.trim().toLowerCase();
            boolean doSSO = _userProfile.getBoolean("sunPortalGatewayEnableSSO", true);
            if (!doSSO) {
                return false;
            }
            List disableList = _userProfile.getStringList("sunPortalGatewayWWWDisableSSOHostList");
            if (disableList != null && disableList.size() > 0) {
                Iterator iter = disableList.iterator();
                while (iter.hasNext()) {
                    String host;
                    Object nextEle = iter.next();
                    if (nextEle == null || !(host = nextEle.toString().trim().toLowerCase()).equals(destHost)) continue;
                    return false;
                }
            }
            if (doSSOPerSess = _userProfile.getBoolean("sunPortalGatewayWWWDoSSOPerSession", false)) {
                try {
                    try {
                        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                        SSOToken ssoToken = ssoTokenManager.createSSOToken(sid);
                        String hostsDone = ssoToken.getProperty(HOST_ALREADY_DONE_LIST);
                        if (hostsDone == null) return false;
                        if ((hostsDone = hostsDone.trim()).length() <= 0) return false;
                        StringTokenizer st = new StringTokenizer(hostsDone, "|");
                        StringBuffer passwdList = new StringBuffer();
                        while (st.hasMoreElements()) {
                            String hostName = st.nextToken();
                            if (hostName.equals(destHost)) {
                                req.setRequestHeader("Authorization", st.nextToken().trim() + "\r\n");
                                return false;
                            }
                            st.nextToken();
                        }
                        return false;
                    }
                    catch (SSOException ex) {
                        if (!GWDebug.debug.messageEnabled()) return false;
                        GWDebug.debug.message("Exception getting User attribute from Session ", ex);
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
            List _list = _userProfile.getStringList("sunPortalGatewayWWWAuthorization");
            Iterator it = _list.iterator();
            while (it.hasNext()) {
                String tmp = (String)it.next();
                StringTokenizer st = new StringTokenizer(tmp, "|");
                String url = st.nextToken().trim();
                if (url.compareTo(destinationHost) != 0) continue;
                password = st.nextToken().trim();
                break;
            }
        }
        catch (Exception ex) {
            return false;
        }
        if (password == null) {
            return false;
        }
        req.setRequestHeader("Authorization", password + "\r\n");
        return true;
    }

    public static void storePassword(Request req, String destinationHost) {
        block20: {
            String authorization = req.getRequestHeader("Authorization").trim();
            if (destinationHost == null) {
                return;
            }
            String destHost = null;
            if (authorization == null) {
                return;
            }
            destHost = destinationHost.trim().toLowerCase();
            String password = destHost + "|" + authorization;
            try {
                boolean doSSOPerSess;
                String sid = req.getSessionID();
                sid = URLDecoder.decode(sid).trim();
                UserProfile profile = new UserProfile(sid);
                boolean doSSO = profile.getBoolean("sunPortalGatewayEnableSSO", true);
                if (!doSSO) {
                    return;
                }
                List disableList = profile.getStringList("sunPortalGatewayWWWDisableSSOHostList");
                if (disableList != null && destinationHost != null) {
                    Iterator iter = disableList.iterator();
                    while (iter.hasNext()) {
                        String host;
                        Object nextEle = iter.next();
                        if (nextEle == null || !(host = nextEle.toString().trim().toLowerCase()).equals(destHost)) continue;
                        return;
                    }
                }
                if (doSSOPerSess = profile.getBoolean("sunPortalGatewayWWWDoSSOPerSession", false)) {
                    try {
                        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                        SSOToken ssoToken = ssoTokenManager.createSSOToken(sid);
                        String hostsDone = ssoToken.getProperty(HOST_ALREADY_DONE_LIST);
                        if (hostsDone != null) {
                            hostsDone = hostsDone.trim();
                            boolean found = false;
                            if (hostsDone.length() > 0) {
                                StringTokenizer st = new StringTokenizer(hostsDone, "|");
                                StringBuffer passwdList = new StringBuffer();
                                while (st.hasMoreElements()) {
                                    String hostName = st.nextToken();
                                    if (found) {
                                        if (!st.hasMoreElements()) continue;
                                        passwdList.append(hostName).append("|").append(st.nextToken()).append("|");
                                        continue;
                                    }
                                    if (hostName.equals(destHost)) {
                                        found = true;
                                        if (!st.hasMoreElements()) continue;
                                        st.nextToken();
                                        continue;
                                    }
                                    if (!st.hasMoreElements()) continue;
                                    passwdList.append(hostName).append("|").append(st.nextToken()).append("|");
                                }
                                passwdList.append(password);
                                hostsDone = passwdList.toString();
                            } else {
                                hostsDone = password;
                            }
                        } else {
                            hostsDone = password;
                        }
                        ssoToken.setProperty(HOST_ALREADY_DONE_LIST, hostsDone);
                    }
                    catch (SSOException ex) {
                        // empty catch block
                    }
                    return;
                }
                Vector<String> passwordVector = new Vector<String>();
                passwordVector.add(password);
                List list = profile.getStringList("sunPortalGatewayWWWAuthorization");
                String pass = null;
                String host = null;
                if (list != null) {
                    ListIterator iter = list.listIterator();
                    while (iter.hasNext()) {
                        pass = (String)iter.next();
                        StringTokenizer st = new StringTokenizer(pass, "|");
                        host = st.nextToken().trim();
                        String auth = st.nextToken().trim();
                        if (host.equalsIgnoreCase(destinationHost)) {
                            if (!authorization.equals(auth)) continue;
                            return;
                        }
                        passwordVector.add(pass);
                    }
                }
                UserProfile.setAttributes(sid, "sunPortalGatewayWWWAuthorization", new HashSet(passwordVector));
            }
            catch (Exception ex) {
                if (!GWDebug.debug.messageEnabled()) break block20;
                GWDebug.debug.message("Cannot store in profile", ex);
            }
        }
    }
}

