/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.StandardURI;
import com.sun.portal.rewriter.util.uri.URIHelper;
import com.sun.portal.rewriter.util.uri.URIIntf;
import java.net.MalformedURLException;
import java.util.Map;

public abstract class AbstractURI
implements URIIntf {
    protected String uriString;
    private boolean valid = false;
    private String fileURI;
    private String dirURI;
    private String fileName;

    protected AbstractURI(String string) {
        this.uriString = StringHelper.normalize(string);
    }

    public final int getDefaultPort() {
        return URIHelper.getDefaultPort(this.getProtocol());
    }

    private Map getQueryMap() {
        return URIHelper.parseQueryString(this.getQuery());
    }

    public final String getParameterValue(String string) {
        Object v = this.getQueryMap().get(string);
        if (v == null) {
            return "";
        }
        return ((String[])v)[0];
    }

    public final String getFileURI() {
        if (this.fileURI == null) {
            this.fileURI = this.getPath();
            if (this.fileURI.trim().length() == 0) {
                this.fileURI = "/";
            }
        }
        return this.fileURI;
    }

    public final String getDirURI() {
        if (this.dirURI == null) {
            int n;
            String string = this.getFileURI();
            if (URIHelper.needsToAppendDirectorySeperator(string)) {
                string = string + "/";
            }
            this.dirURI = (n = string.lastIndexOf("/")) != -1 ? this.getFileURI().substring(0, n + 1) : "/";
        }
        return this.dirURI;
    }

    public final String getFileName() {
        if (this.fileName == null) {
            String string = this.getFileURI();
            this.fileName = string.substring(this.getDirURI().length());
        }
        return this.fileName;
    }

    public final String getInputString() {
        return this.uriString;
    }

    public final String toExternalForm() {
        if (!this.isValid() & !this.isAbsolute()) {
            return this.uriString;
        }
        return this.getProtocol() + "://" + (this.getUserInfo().equals("") ? "" : this.getUserInfo() + "@") + this.getHost() + (this.getPort() != -1 ? ":" + this.getPort() : "") + this.getPath() + (this.getQuery().equals("") ? "" : "?" + this.getQuery()) + (this.getReference().equals("") ? "" : "#" + this.getReference());
    }

    protected final void setValid(boolean bl) {
        this.valid = bl;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String appendParams(String string, Map map) {
        return URIHelper.parameterize(string, map);
    }

    public static URIIntf[] getAvailableURIImpl(String string) throws MalformedURLException {
        return new URIIntf[]{new StandardURI(string)};
    }

    public abstract String getImplID();

    public abstract boolean isAbsolute();

    public abstract String getQuery();

    public abstract String getReference();

    public abstract String getPath();

    public abstract String getUserInfo();

    public abstract int getPort();

    public abstract String getHost();

    public abstract String getProtocol();
}

