/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netlet.util.AttributeExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserAttributes {
    private String attributePrefix;
    protected AMUser user = null;
    protected Map userAttributes;
    public boolean applyDefault;

    public UserAttributes(SSOToken token, String attributePrefix1) {
        try {
            AMStoreConnection connection = new AMStoreConnection(token);
            this.user = connection.getUser(token.getPrincipal().getName());
            this.userAttributes = this.user.getAttributes();
            this.attributePrefix = attributePrefix1;
            this.applyDefault = false;
        }
        catch (SSOException ssoe) {
            this.applyDefault = true;
        }
        catch (AMException dpe) {
            this.applyDefault = true;
        }
    }

    public String getString(String name, String defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getString(this.userAttributes, this.attributePrefix + name, defaultValue);
    }

    public int getInt(String name, int defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getInt(this.userAttributes, this.attributePrefix + name, defaultValue);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getBoolean(this.userAttributes, this.attributePrefix + name, defaultValue);
    }

    public List getStringList(String name) {
        return this.applyDefault ? new ArrayList() : AttributeExtractor.getStringList(this.userAttributes, this.attributePrefix + name);
    }

    public String getPreferredLocale(String defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getString(this.userAttributes, "preferredlocale", defaultValue);
    }

    public void setStringList(String name, List value) {
        HashSet hs = new HashSet(value);
        HashMap changedMap = new HashMap();
        changedMap.put(this.attributePrefix + name, hs);
        try {
            this.user.setAttributes(changedMap);
            this.user.store();
        }
        catch (SSOException ssoe) {
        }
        catch (AMException ame) {
            // empty catch block
        }
    }

    public void setString(String name, String value) {
        HashSet<String> hs = new HashSet<String>(1);
        hs.add(value);
        HashMap<String, HashSet<String>> changedMap = new HashMap<String, HashSet<String>>();
        changedMap.put(this.attributePrefix + name, hs);
        try {
            this.user.setAttributes(changedMap);
            this.user.store();
        }
        catch (SSOException ssoe) {
        }
        catch (AMException ame) {
            // empty catch block
        }
    }
}

