/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.sso.SSOToken;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.util.GWLocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class HeaderResponse
implements Response {
    protected final String crlf = "\r\n";
    protected SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private String statusCode;
    private String statusText;
    private byte[] responseContent;
    private Map _headerLines;
    private static final String CONTENT_ENCODING = "html";
    private static final String CONTENT_TYPE = "text";
    private static final String SERVER = "sun.net";
    private static final String HTTP_VERSION = "HTTP/1.0";
    private static final String SUBST_STRING = "$$";
    private static final String space = " ";
    private static String defaultLocale = "en_US";
    private static String defaultCharset = "ISO-8859-1";
    private static final String HTMLCHARSET_ATTRIBUTE = "HTML-CharSets";
    private String language = null;
    private String userLocale;
    private String userCharset;
    protected String keepAliveToken = null;
    protected String _cookie = null;

    public HeaderResponse(String field, String message, String statusCode, String statusText, SSOToken token) {
        this.getLocaleCharset(token);
        StringBuffer contents = new StringBuffer(GWLocale.getString(field, this.userLocale));
        this._headerLines = new HashMap();
        if (message.length() > 0) {
            contents.append(space);
            contents.append(message);
        }
        this.responseContent = contents.toString().getBytes();
        this.statusCode = statusCode;
        this.statusText = statusText;
        this._headerLines.put("ndate", "Date: " + this.df.format(new Date()));
        this._headerLines.put("pragma", "Pragma: no-cache");
        this._headerLines.put("server", "Server: sun.net");
        this._headerLines.put("allow", "Allow: GET");
        this._headerLines.put("content-length", "Content-Length: " + this.responseContent.length);
        this._headerLines.put("content-type", "Content-Type: text/html;charset=" + this.userCharset);
    }

    public HeaderResponse(String message, String statusCode, String statusText, SSOToken token) {
        this(message, statusCode, statusText, token, null);
    }

    public HeaderResponse(String message, String statusCode, String statusText, SSOToken token, String language) {
        this.language = language;
        this.getLocaleCharset(token);
        this._headerLines = new HashMap();
        this.responseContent = message.getBytes();
        this.statusCode = statusCode;
        this.statusText = statusText;
        this._headerLines.put("ndate", "Date: " + this.df.format(new Date()));
        this._headerLines.put("pragma", "Pragma: no-cache");
        this._headerLines.put("server", "Server: sun.net");
        this._headerLines.put("allow", "Allow: GET");
        this._headerLines.put("content-length", "Content-Length: " + this.responseContent.length);
        this._headerLines.put("content-type", "Content-Type: text/html;charset=" + this.userCharset);
    }

    public HeaderResponse(String message, String statusCode, String statusText) {
        this.getLocaleCharset(null);
        this._headerLines = new HashMap();
        this.responseContent = message.getBytes();
        this.statusCode = statusCode;
        this.statusText = statusText;
        this._headerLines.put("ndate", "Date: " + this.df.format(new Date()));
        this._headerLines.put("pragma", "Pragma: no-cache");
        this._headerLines.put("server", "Server: sun.net");
        this._headerLines.put("allow", "Allow: GET");
        this._headerLines.put("content-length", "Content-Length: " + this.responseContent.length);
        this._headerLines.put("content-type", "Content-Type: text/html;charset=" + this.userCharset);
    }

    public void substituteContent(String sub) {
        String s = new String(this.responseContent);
        StringBuffer sb = new StringBuffer();
        int i = s.indexOf(SUBST_STRING);
        if (i != -1) {
            sb.append(s.substring(0, i));
            sb.append(sub);
            sb.append(s.substring(i + 2));
            this.responseContent = sb.toString().getBytes();
        }
        this._headerLines.put("content-length", "Content-Length: " + this.getContentLength());
    }

    public String getHTTPVersion() {
        return HTTP_VERSION;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getContentType() {
        return "text/html";
    }

    public String getContentEncoding() {
        return CONTENT_ENCODING;
    }

    public String getResponseHeader(String headerLine) {
        return (String)this._headerLines.get(headerLine.toLowerCase());
    }

    public void setResponseHeader(String header, String value) {
        if (header != null) {
            this._headerLines.remove(header.toLowerCase());
            this._headerLines.put(header.toLowerCase(), value);
            if (header.toLowerCase().startsWith("set-cookie")) {
                this._cookie = value;
            }
        }
    }

    public void setContentLength(int i) {
        this._headerLines.remove("content-length");
        this._headerLines.put("content-length", "Content-Length: " + i + "\r\n");
    }

    public void setConnectionClose() {
        this._headerLines.remove("Connection");
        this.keepAliveToken = "Connection: close\r\n";
        this._headerLines.put("Connection", "Connection: close");
    }

    public void setConnectionAlive(String token) {
        String header = this.getResponseHeader("Connection");
        if (header != null) {
            this._headerLines.remove("Connection");
        }
        if ((header = this.getResponseHeader("Keep-Alive")) != null) {
            this._headerLines.remove("Keep-Alive");
        }
        this.keepAliveToken = "Keep-Alive: " + token;
        this._headerLines.put("Keep-Alive", this.keepAliveToken);
        this._headerLines.put("Connection", "Connection: Keep-Alive");
        this.keepAliveToken = "Connection: Keep-Alive\r\n" + this.keepAliveToken + "\r\n";
    }

    public void setLocation(String location) {
    }

    public int getContentLength() {
        String header = (String)this._headerLines.get("content-length");
        if (null == header) {
            return this.responseContent.length;
        }
        int start = header.indexOf(58);
        if (start == -1) {
            return this.responseContent.length;
        }
        if (header.endsWith("\r\n")) {
            return Integer.parseInt(header.substring(start + 1, header.length() - 2).trim());
        }
        return Integer.parseInt(header.substring(start + 1, header.length()).trim());
    }

    public byte[] getHeaderBytes() {
        ByteArrayOutputStream outBAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(outBAOS);
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(this.getHTTPVersion());
            strBuffer.append(space);
            strBuffer.append(this.getStatusCode());
            strBuffer.append(space);
            strBuffer.append(this.getStatusText());
            strBuffer.append("\r\n");
            strBuffer.append("Date: ");
            strBuffer.append(this.df.format(new Date()));
            strBuffer.append("\r\n");
            strBuffer.append("Pragma: no-cache");
            strBuffer.append("\r\n");
            strBuffer.append("Server: ");
            strBuffer.append(SERVER);
            strBuffer.append("\r\n");
            strBuffer.append("Allow: GET");
            strBuffer.append("\r\n");
            strBuffer.append("Content-Length: ");
            strBuffer.append(this.getContentLength());
            strBuffer.append("\r\n");
            strBuffer.append("Content-Type: ");
            strBuffer.append(this.getContentType());
            strBuffer.append(";charset=");
            strBuffer.append(this.userCharset);
            strBuffer.append("\r\n");
            out.writeBytes(strBuffer.toString());
            if (this.keepAliveToken != null) {
                out.writeBytes(this.keepAliveToken);
            }
            if (this._cookie != null) {
                out.writeBytes(this._cookie + "\r\n");
            }
            out.writeBytes("\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outBAOS.toByteArray();
    }

    public BufferedInputStream getContentStream() {
        ByteArrayOutputStream outBAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(outBAOS);
            out.write(this.responseContent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new BufferedInputStream(new ByteArrayInputStream(outBAOS.toByteArray()));
    }

    public String toString() {
        return new String(this.getHeaderBytes());
    }

    public void setStatusText(String st) {
        this.statusText = st;
    }

    private void getLocaleCharset(SSOToken token) {
        if (token == null) {
            if (this.language != null) {
                this.userLocale = this.language = this.language.substring(this.language.indexOf(58) + 1).trim();
                this.userCharset = this.getHTMLCharset(this.userLocale);
                if (this.userCharset == null) {
                    this.userLocale = defaultLocale;
                    this.userCharset = defaultCharset;
                }
            } else {
                this.userLocale = defaultLocale;
                this.userCharset = defaultCharset;
            }
            return;
        }
        try {
            String sid = URLDecoder.decode(token.getTokenID().toString());
            UserProfile _userProfile = new UserProfile(sid);
            this.userLocale = _userProfile.getString("preferredlocale", "en_US");
            this.userCharset = this.getHTMLCharset(this.userLocale);
            if (this.userCharset == null) {
                this.userLocale = defaultLocale;
                this.userCharset = defaultCharset;
            }
        }
        catch (Exception ex) {
            this.userLocale = defaultLocale;
            this.userCharset = defaultCharset;
        }
    }

    private String getHTMLCharset(String locale) {
        String charsetString = GWLocale.getString(HTMLCHARSET_ATTRIBUTE, locale);
        if (charsetString == null || charsetString.equals(HTMLCHARSET_ATTRIBUTE)) {
            charsetString = null;
        }
        return charsetString;
    }

    public void setSocket(CachedSocket sock) {
    }

    public void closeSocket() {
    }

    public void setClientCaching() {
    }
}

