/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class DomainWebProxyConfig {
    private static final char PIPE = '|';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static final String STAR_DOT_STRING = "*.";
    private static final String STAR_STRING = "*";
    public static final String DOMAINS_AND_SUBDOMAINS = "DomainsAndSubdomains";
    public static final String DEFAULT_DOMAIN_AND_SUBDOMAINS = "DefaultDomainAndSubdomains";
    private static final HashMap proxyMap = new HashMap();
    private static String defaultDomain;
    private static String defaultSubDomainAndDomain;
    private static final String TRANSLATE_ALL_NAME = "TranslateAll";
    private static boolean translateAll;

    private static void populateDefaultDomainSubDomain() {
        String defaultDomainSubDomain = GatewayProfile.getString(DEFAULT_DOMAIN_AND_SUBDOMAINS, "").toLowerCase();
        String[] splitEntry = DomainWebProxyConfig.split(defaultDomainSubDomain, '|');
        if (splitEntry.length == 0) {
            defaultDomain = "";
            defaultSubDomainAndDomain = "";
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("The default sub-domain / domain not specified in gateway profile!");
            }
        } else if (splitEntry.length == 1) {
            defaultSubDomainAndDomain = defaultDomain = '.' + splitEntry[0];
        } else {
            defaultDomain = '.' + splitEntry[0];
            defaultSubDomainAndDomain = '.' + splitEntry[1] + defaultDomain;
        }
    }

    private static void populateProxyList(String entry) {
        String domainProxy;
        String[] splitEntry = DomainWebProxyConfig.split(entry, '|');
        if (splitEntry.length == 0) {
            return;
        }
        String[] domainEntry = DomainWebProxyConfig.split(splitEntry[0], ' ');
        String domainName = domainEntry.length > 0 ? domainEntry[0].toLowerCase() : null;
        String string = domainProxy = domainEntry.length > 1 ? domainEntry[1] : null;
        if (proxyMap.get(domainName) == null) {
            proxyMap.put(domainName, domainProxy);
        }
        int i = 1;
        while (i < splitEntry.length) {
            String subDomainName;
            String[] temp = DomainWebProxyConfig.split(splitEntry[i], ' ');
            if (temp.length != 0 && proxyMap.get(subDomainName = temp[0].toLowerCase()) == null) {
                String subDomainProxy = temp.length > 1 ? temp[1] : domainProxy;
                proxyMap.put(subDomainName + '.' + domainName, subDomainProxy);
            }
            ++i;
        }
    }

    public static String getWebProxy(String host) {
        if (host == null) {
            return null;
        }
        String entry = DomainWebProxyConfig.getFQDNEntry(host = host.trim().toLowerCase());
        return entry == null ? (String)proxyMap.get(STAR_STRING) : (String)proxyMap.get(entry);
    }

    private static String getFQDNEntry(String host) {
        String entry = DomainWebProxyConfig.getMapEntry(host);
        if (entry != null) {
            return entry;
        }
        int index = host.indexOf(46);
        String newHost = null;
        if (index == -1) {
            newHost = host + defaultSubDomainAndDomain;
        }
        return newHost == null ? null : DomainWebProxyConfig.getMapEntry(newHost);
    }

    private static String getMapEntry(String host) {
        int index = 0;
        do {
            if (proxyMap.containsKey(host)) {
                return host;
            }
            index = host.indexOf(46);
            host = host.substring(index + 1);
            String starHost = STAR_DOT_STRING + host;
            if (!proxyMap.containsKey(starHost)) continue;
            return starHost;
        } while (index != -1);
        return null;
    }

    public static boolean containHost(String host) {
        if (host == null) {
            return false;
        }
        if (translateAll) {
            return true;
        }
        String entry = DomainWebProxyConfig.getFQDNEntry(host = host.trim().toLowerCase());
        return entry != null;
    }

    private static String[] split(String source, char delimiter) {
        StringTokenizer st = new StringTokenizer(source.trim(), "" + delimiter);
        String[] ret = new String[st.countTokens()];
        int index = 0;
        while (index < ret.length) {
            ret[index] = st.nextToken().trim();
            ++index;
        }
        return ret;
    }

    static {
        List domainsAndSubDomainsList = GatewayProfile.getStringList(DOMAINS_AND_SUBDOMAINS);
        int i = 0;
        while (i < domainsAndSubDomainsList.size()) {
            DomainWebProxyConfig.populateProxyList(domainsAndSubDomainsList.get(i).toString());
            ++i;
        }
        DomainWebProxyConfig.populateDefaultDomainSubDomain();
        translateAll = GatewayProfile.getBoolean(TRANSLATE_ALL_NAME, false);
    }
}

