/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.authentication.AuthPrincipal;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Map;

public class GlobalAttributesServiceHandler
implements ServiceHandler {
    public Response handleRequest(Request request) throws RemoteException {
        try {
            SSOToken token = this.getSSOToken(request);
            AMStoreConnection connection = new AMStoreConnection(token);
            AMSchema schema = connection.getSchema(request.getServiceName(), AMSchema.Type.GLOBAL);
            Map attrs = schema.getAttributeDefaults();
            Response response = new Response(request.getServiceName(), request.getRequestType(), attrs);
            return response;
        }
        catch (SSOException ssoe) {
            throw new RemoteException("Not able to get Global Attributes", ssoe);
        }
        catch (AMException dpe) {
            throw new RemoteException("Not able to get Global Attributes", dpe);
        }
    }

    private SSOToken getSSOToken(Request request) throws RemoteException {
        try {
            String bindDN = AdminUtils.getAdminDN();
            String password = new String(AdminUtils.getAdminPassword());
            AuthPrincipal ap = new AuthPrincipal(bindDN);
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            return tokenManager.createSSOToken((Principal)ap, password);
        }
        catch (SSOException ssoe) {
            throw new RemoteException("Not able to get the token", ssoe);
        }
    }
}

