/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.EProxyConnection;
import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.server.ConnectionManager;
import com.sun.portal.rproxy.server.ReverseProxy;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.LogInfoContainer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.mozilla.jss.ssl.SSLServerSocket;

public class RProxyConnection
extends EProxyConnection {
    private ConnectionManager cm = null;
    private String threadName = null;
    private boolean httpsConnection = true;
    private ServerSocket ss = null;
    private int port = 0;

    public RProxyConnection(ConnectionManager cm) {
        this.cm = cm;
        this.threadName = "RProxyHTTPSThread";
        this.httpsConnection = true;
        this.ss = cm.getServerSocket();
        if (this.ss != null) {
            this.port = this.ss.getLocalPort();
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("RProxyConnection for https created at port : " + this.port);
        }
    }

    public RProxyConnection(ConnectionManager cm, int port) {
        this.cm = cm;
        this.ss = this.makeServerSocket(port);
        this.port = port;
        this.threadName = "RProxyHTTPThread";
        this.httpsConnection = false;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("RProxyConnection for http created at port : " + this.port);
        }
    }

    public void accept() {
        Thread.currentThread().setName(this.threadName);
        Integer logid = new Integer(0);
        boolean go = this.ss != null;
        GW.run_GW();
        boolean isHTTPS = this.ss instanceof SSLServerSocket;
        while (go) {
            Socket inconnection = null;
            try {
                try {
                    inconnection = this.ss.accept();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (isHTTPS) {
                            SocketCount.incrementSSLSockets();
                        } else {
                            SocketCount.incrementPlainSockets();
                        }
                    }
                }
                catch (SocketException se) {
                    continue;
                }
                catch (IOException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("RProxyConnection cannot accept new connection on " + this.ss, e);
                    }
                    if (this.ss != null) {
                        Object var9_17;
                        try {
                            block35: {
                                try {
                                    this.ss.close();
                                    if (!PerfContextObject.ENABLE_PERF) break block35;
                                    SocketCount.decrementServerSockets();
                                }
                                catch (IOException ee) {
                                    if (GWDebug.debug.errorEnabled()) {
                                        GWDebug.debug.error("RProxyConnection cannot close server socket", e);
                                    }
                                    var9_17 = null;
                                    this.ss = null;
                                }
                            }
                            var9_17 = null;
                            this.ss = null;
                        }
                        catch (Throwable throwable) {
                            var9_17 = null;
                            this.ss = null;
                            throw throwable;
                        }
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ee) {
                        // empty catch block
                    }
                    String string = "dummy";
                    synchronized (string) {
                        GW.unrun_GW();
                        GW.setNumberOfInstances(1);
                        if (this.httpsConnection) {
                            ReverseProxy rprxy = new ReverseProxy();
                            this.cm = rprxy.getConnectionManager();
                            this.ss = this.cm.getServerSocket();
                            if (this.ss == null) {
                                go = false;
                            }
                        } else {
                            this.ss = this.makeServerSocket(this.port);
                            if (this.ss == null) {
                                go = false;
                            }
                        }
                        GW.run_GW();
                        continue;
                    }
                }
                if (GWLogManager.loggingEnabled) {
                    logid = new Integer(GWLogManager.getLogId());
                    GWLogManager.write("EProxy", GWLocale.getPFString("epc1", new Object[]{logid, inconnection.getInetAddress().toString(), new Integer(inconnection.getPort())}));
                }
                try {
                    inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    Object var12_18;
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("RProxyConnection cannot set TcpNoDelay on " + inconnection, e);
                    }
                    if (inconnection == null) continue;
                    try {
                        block37: {
                            try {
                                inconnection.close();
                                if (!PerfContextObject.ENABLE_PERF) break block37;
                                if (isHTTPS) {
                                    SocketCount.decrementSSLSockets();
                                    break block37;
                                }
                                SocketCount.decrementPlainSockets();
                            }
                            catch (IOException ee) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("EProxy: IO Exception while closing server socket:", ee);
                                }
                                var12_18 = null;
                                inconnection = null;
                                continue;
                            }
                        }
                        var12_18 = null;
                        inconnection = null;
                        continue;
                    }
                    catch (Throwable throwable) {
                        var12_18 = null;
                        inconnection = null;
                        throw throwable;
                    }
                }
                GWLogManager.logIdMap.put(new Integer(inconnection.getPort()), new LogInfoContainer(logid, inconnection));
                this.cm.acceptConnection(inconnection, logid, null);
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error("EProxy: Uncaught exception:", t);
            }
        }
        this.stop();
    }
}

