# Copyright 05/17/04 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)perftool-d.prc	1.18 04/05/17 Sun Microsystems"
#
#       File:   perftool-d.prc
#       Version: 1.0
#
#       Perftool Procedures
#

#
# create file when load
#

proc createFile {} {
	global env
	set rtn [ file exists "$env(ESDIR)/PRM/agent/data/system.dat" ]
        if { $rtn == "0" } {
                set file "$env(ESDIR)/PRM/agent/data/system.dat"
                set f [ open $file w+ ]
                close $f
        }

        set rtn [ file exists "$env(ESDIR)/PRM/agent/data/systemdelta.dat" ]
        if { $rtn == "0" } {
                set file "$env(ESDIR)/PRM/agent/data/systemdelta.dat"
                set f [ open $file w+ ]
                close $f
        }
} 

#
# system information process
proc systeminfo {} {
	global env
	set rtn 0
	set hwfile "$env(ESDIR)/PRM/agent/data/hardware.cfg"
        set rtn [ file exists "$env(ESDIR)/PRM/agent/data/hardware.cfg" ]
	
	if { $rtn == "0" } {
        } else {
		set fcfg [ open $hwfile r ]
		set rtn [ gets $fcfg line ]
		if { $rtn < 0 } {
			return "$rtn"
		}
		set Location [ lindex $line 0 ]
		close $fcfg
		set rtn [ catch { locate $Location.*system } obj ]
                if { $rtn == "1" } {
                        return "$rtn"
		}
		set Port 161
		set Hostname	"--"
		catch { set Hostname  [ toe_send $obj valueOf hostname ] }
		set Port	"--"
		catch { set Port      [ toe_send [ locate ._config.agent ] lookup value snmpPort ] }
		set Os		"--"
		catch { set Os	[ toe_send $obj valueOf os ] }
		set Osversion	"--"
		catch { set Osversion  [ toe_send $obj valueOf OS_version ] }
		set Clockf	"--"
		catch { set Clockf     [ toe_send $obj valueOf System_clock_frequency ] }
		set Arch	"--"
		catch { set Arch       [ toe_send $obj valueOf architecture ] }
		set Machinetype	"--"
		catch { set Machinetype	[ toe_send $obj valueOf machine ] }
		set Platform "--"
		catch { set Platform	[ toe_send [ locate iso.*agent.base.info.system ] valueOf familytype ] }
		set Serial	"--"
		catch { set Serial	[ toe_send $obj valueOf serial_number ] }
		set Disks	"--"
		catch { set Disks	[ toe_send $obj valueOf total_disks ] }
		set Memory      "--"
		catch { set Memory	[ toe_send $obj valueOf total_memory ] }
		set Processors	"--"
		catch { set Processors	[ toe_send $obj valueOf total_processors ] }
		set Tapes	"--"
		catch { set Tapes	[ toe_send $obj valueOf total_tape_devices ] }
		set string "{$Hostname} {$Port} {$Os} {$Osversion} {$Clockf} {$Arch} {$Machinetype} {$Platform} {$Serial} {$Disks} {$Memory} {$Processors} {$Tapes}"
		
		set empty [ file size "$env(ESDIR)/PRM/agent/data/system.dat" ]
		set file_old "$env(ESDIR)/PRM/agent/data/system.dat"
		set file_new "$env(ESDIR)/PRM/agent/data/systemdelta.dat"
		if { $empty == "0" } {
			set fd_old [ open $file_old w+ ]
			puts $fd_old $string
			close $fd_old
			set fd_new [ open $file_new w+ ]
			puts $fd_new $string
			close $fd_new
		} else {
			set fd_old [ open $file_old r ]
			gets $fd_old tmpstring
			set com [ string compare $string $tmpstring ]
			close $fd_old
			if { $com != "0" } {
				set fd_new [ open $file_new w+ ]
				puts $fd_new $string
				close $fd_new

				set fd_old [ open $file_old w+ ]
				puts $fd_old $string
				close $fd_old
			}
		}
		setAttribute refreshInterval 43200
                if {[existsAttributeTimer refresh]} {
                	resetAttributeTimer refresh refreshValue ""
                }
	}
	return "$rtn"
}

#
# get hardware information 
proc hw {} {
        set rtn 0
	global env
	set hwfile "$env(ESDIR)/PRM/agent/data/hardware.cfg"
	set rtn [ file exists "$env(ESDIR)/PRM/agent/data/hardware.cfg" ]
	 
        if { $rtn == "1" } {
		set obj [ locate ._config.agent ] 
		set Port [ toe_send $obj lookup value snmpPort ]
		set Hostname [ toe_send $obj lookup value agentServer ]
		set fileout  "$env(ESDIR)/PRM/agent/data/hardwaredelta.dat"
		set empty [ file exists $fileout ]
		if { $empty == "0" } {
			set fileout  "$env(ESDIR)/PRM/agent/data/hardware.dat"
			set fpout [ open $fileout w+ ]
		} else {
			set fileout "$env(ESDIR)/PRM/agent/data/tmp/hardwaretmp.dat"
			set fpout [ open $fileout w+ ]  
		}  
		
		set fphw [ open $hwfile  ]
		while { [ gets $fphw line ] >=0 } {
			set Location [ lindex $line 0 ]
			set Module [ lindex $line 1 ]
			set TableName [ lindex $line 2 ]
			set tmp [ lindex $line 3 ]
			set lst [ split $tmp | ]
			set len [ llength $lst ]
			set table [ lindex $lst 0 ]
			set entry [ lindex $lst 1 ]
			set rtn [ catch { locate $Location.*system } ]
			if { $rtn == "1" } {
				close $fphw
				close $fpout
				return "$rtn"
			}
			set rtn [ catch { locate $Location.*$table.$entry } ]
			if { $rtn == "1" } {
				for {set i "2"} {$i < $len} {incr i} {
					set num "1"
					for {set j "0"} {$j < $num} {incr j} {
						set index($j) "--"
                                        	set outtmp "--"
                                                append out($j) "$outtmp|"
                                        }
				}
				for {set j "0"} {$j < $num} {incr j} {
                                	set long [ string length $out($j) ]
                                	set value [ string range $out($j) 0 [ expr $long-2 ] ]
                                	puts $fpout "{$TableName} {$index($j)} {$value}"
                                	unset index($j)
                                	unset out($j)
                        	}
				continue
			}
			for {set i "2"} {$i < $len} {incr i} {
				set prop [ lindex $lst $i ]
				set rtn [ catch { locate $Location.*$table.$entry.$prop } ]
				if { $rtn == "1" } {
					set rtn [ toe_send [ locate $Location.*$table.$entry ] lookup -d "scalar" internal childdimension ]
					if { $rtn == "scalar" } {
						set num "1"
						for {set j "0"} {$j < $num} {incr j} {
							if { $prop == "sunSmNodeName" } {
                                                		set index($j) "--"
                                        		}
                                                        set outtmp "--" 
                                                        append out($j) "$outtmp|"
                                                }
					} else {
						set num [ toe_send [ locate $Location.*$table.$entry ]  slicelength indexByOid ]
						for {set j "0"} {$j < $num} {incr j} {
							if { $prop == "sunSmNodeName" } {
                                                                set index($j) "--"
                                                        }
							set outtmp "--" 
                                        		append out($j) "$outtmp|"
                                		}
					}
					continue
				}
				set col [ toe_send [ locate $Location.*$table.$entry.$prop ] getValues ]
				set num [ llength $col ]
				for {set j "0"} {$j < $num} {incr j} {
					if { $prop == "sunSmNodeName" } {
						set index($j) [ lindex $col $j ]
					}
					set outtmp [ lindex $col $j ]
					if { $outtmp == "" } {
                                                set outtmp "--"
                                        }
					append out($j) "$outtmp|"
				}
			}
			for {set j "0"} {$j < $num} {incr j} {
				set long [ string length $out($j) ]
				set value [ string range $out($j) 0 [ expr $long-2 ] ] 
				puts $fpout "{$TableName} {$index($j)} {$value}"
				unset index($j)
				unset out($j)
			}	
			
		}
		close $fphw
		close $fpout

		if { $fileout == "$env(ESDIR)/PRM/agent/data/tmp/hardwaretmp.dat" } {
			set empty [ file size "$env(ESDIR)/PRM/agent/data/hardwaredelta.dat" ]
			if { $empty == "0" } {
				perftool_hardware DELTA $Hostname $Port $env(ESDIR)
			}
		} else {
			perftool_hardware NEW $Hostname $Port $env(ESDIR)
			setAttribute refreshInterval 43200 
			if {[existsAttributeTimer refresh]} {
				resetAttributeTimer refresh refreshValue ""
			}
		}
		set rtn "0"
	} else {
		set cfg "$env(ESDIR)/PRM/agent/data/hwcfg.dat"
		set rtn  [ file exists $cfg ]
		if { $rtn == "0" } {
			set len [ toe_send [ locate iso.*sunsymon.agent.base.mibman.modules.hardware.moduleTable.moduleEntry.modspec ] slicelength data ]
			for {set i "1" } {$i <= $len } {incr i 1 } {
				set module [ toe_send [ locate iso.*sunsymon.agent.base.mibman.modules.hardware.moduleTable.moduleEntry.modspec ] slookup data $i ]
				set head [ string range $module 0 12 ]
				if { $head == "Config-Reader" } {
					set f [ open $cfg w+ ]
					puts $f $module
					close $f
					break;
				}
			}
		}
	}
        return "$rtn"
}

#
# default properties log
#
proc defaultlog {} {
	global env
	set rtn [ catch { set threshold [ getAttribute data ] } obj ]
	if { $rtn == "0" } {
		if { $threshold == "2" } {
			return "$threshold"
		}
	}
	set rtn [ catch { valueOf default } obj ]
	if { $rtn == "0" } {
		set value [ valueOf default ]
		if { $value == "2" } {
			return $value
		}
        }

	set value 0
	set filename "$env(ESDIR)/PRM/agent/cfg/defaultlog.cfg"
	set fp [ open $filename r ]
	set counter 0
	while { [ gets $fp line ] >=0 } {
		if { [ string index $line 0 ] == "#" } {
			set out($counter) $line
			incr counter 1
			continue
		} else {
			set prop [ lindex $line 0 ]
			set interval [ lindex $line 1 ]
			set stat [ lindex $line 2 ]
			set rtn [ catch { locate iso.*$prop } ]
			if { $rtn == "0" } {
				toe_begin [ locate iso.*$prop ]
				set type [ lookup -d "scalar" internal childdimension ]
				set len [ slicelength historyChannel ]
				set time [ slicelength data ]

				if { $type == "scalar" } {
					if { $len != 0 } {
                                        	toe_end
						set out($counter) $line
						incr counter 1
                                        	continue
                                	}
					historyAddTarget {} file
					historyIntervalUpdate $interval
					set stat "Y"
				} elseif { $type == "vector" } {
					if { $len == $time } {
                                        	toe_end
						set out($counter) $line
						incr counter 1
                                        	continue
                                	}
					for {set i "1" } {$i <= $time } {incr i 1} {
						set target [ slookup nameByIndex $i ]
						historyAddTarget "$target" file
						historyIntervalUpdate $interval
					}
					set stat "Y"
				}
				toe_end
			}
			set out($counter) "$prop\t$interval\t$stat"
			incr counter 1 
		}  
		
	}
	close $fp
	set fp [ open $filename w+ ]
	for { set i "0" } {$i < $counter } {incr i 1} {
		puts $fp $out($i)
	}
	close $fp	
	return "$value"
}

#
# set or remove default properties log
#
proc setDefault { value } {
	global env
	set counter 0
        if { $value == "2" } { 
        	set filename "$env(ESDIR)/PRM/agent/cfg/defaultlog.cfg"
        	set fp [ open $filename r ]
        	while { [ gets $fp line ] >=0 } {
                	if { [ string index $line 0 ] == "#" } {
				set out($counter) $line
				incr counter 1
                        	continue
                	} else {
                        	set prop [ lindex $line 0 ]
                        	set interval [ lindex $line 1 ]
                        	set stat [ lindex $line 2]
				if { $stat == "N" } {
					set out($counter) $line
					incr counter 1
					continue
				}
                        	set rtn [ catch { locate iso.*$prop } ]
                        	if { $rtn == "0" } {
                                	toe_begin [ locate iso.*$prop ]
					set type [ lookup -d "scalar" internal childdimension ]
					set len [ slicelength historyChannel ]
					set time [ slicelength data ]

                                	if { $len == "0" } {
                                        	toe_end
						set out($counter) $line
						incr counter 1
                                        	continue
                                	}

                                	if { $type == "scalar" } {
                                        	historyRemoveTarget {}
						set stat "N"
                                	} elseif { $type == "vector" } {
                                        	for {set i "1" } {$i <= $time } {incr i 1} {
							set target [ slookup nameByIndex $i ]
                                                	historyRemoveTarget "$target" 
                                        	}
						set stat "N"
                                	}
                                	toe_end
                        	}
				set out($counter) "$prop\t$interval\t$stat"
				incr counter 1
                	}

        	}
        	close $fp
	}
	if { $value == "0" } {
	        set filename "$env(ESDIR)/PRM/agent/cfg/defaultlog.cfg"
        	set fp [ open $filename r ]

        	while { [ gets $fp line ] >=0 } {
                	if { [ string index $line 0 ] == "#" } {
				set out($counter) $line
				incr counter 1			
                        	continue
                	} else {
                        	set prop [ lindex $line 0 ]
                        	set interval [ lindex $line 1 ]
                        	set stat [ lindex $line 2]
                        	set rtn [ catch { locate iso.*$prop } ]
                        	if { $rtn == "0" } {
                                	toe_begin [ locate iso.*$prop ]
					set len [ slicelength historyChannel ]
					set time [ slicelength data ]
					set type [ lookup -d "scalar" internal childdimension ]
                                	if { $type == "scalar" } {
						if { $len != 0 } {
							toe_end
							set out($counter) "$prop\t$interval\t$stat"
							incr counter 1
							continue
						}
					        historyAddTarget {} file
                                        	historyIntervalUpdate $interval
						set stat "Y"
                                	} elseif { $type == "vector" } {
						if { $len == $time } {
                                                	toe_end
							set out($counter) "$prop\t$interval\t$stat"
							incr counter 1
                                                	continue
                                        	}
                                        	for {set i "1" } {$i <= $time } {incr i 1} {
							set target [ slookup nameByIndex $i ]
                                                	historyAddTarget "$target" file
                                                	historyIntervalUpdate $interval
                                        	}
						set stat "Y"
                                	}
                                	toe_end
				}
				set out($counter) "$prop\t$interval\t$stat"
				incr counter 1
                        }

                }
                close $fp
        }
        set fp [ open $filename w+ ]
        for { set i "0" } {$i < $counter } {incr i 1} {
                puts $fp $out($i)
        }
        close $fp
	set self_pos [ toe_self ]
	set prop_pos [ locate iso.*perftool.*default ]
	if { $self_pos == $prop_pos } {
		setAttribute data $value
	}
        return "$value"
}
