/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.wml;

import com.aligo.wml.exceptions.WmlAttributeCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementIndexOutOfBoundsException;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.exceptions.WmlTextCannotBeResetException;
import com.aligo.wml.exceptions.WmlTextCannotBeSetException;
import com.aligo.wml.exceptions.WmlTextNotSetException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Hashtable;
import java.util.Vector;

public class WmlElementCollection
implements WmlElement {
    Vector elements = new Vector();

    public String getName() {
        return "WmlElementCollection";
    }

    public String getXmlID() {
        return "";
    }

    public void addWmlElementAt(WmlElement element, int index) throws WmlElementCannotBeAddedException {
        this.elements.insertElementAt(element, index);
    }

    public void addWmlElement(WmlElement element) throws WmlElementCannotBeAddedException {
        this.elements.addElement(element);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.size();
    }

    public WmlElement wmlElementAt(int loc) throws WmlElementIndexOutOfBoundsException {
        try {
            return (WmlElement)this.elements.elementAt(loc);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new WmlElementIndexOutOfBoundsException(loc);
        }
    }

    public int wmlElementIndex(WmlElement wmlElement) throws WmlElementNotFoundException {
        int index = this.elements.indexOf(wmlElement);
        if (index == -1) {
            throw new WmlElementNotFoundException();
        }
        return this.elements.indexOf(wmlElement);
    }

    public void removeWmlElement(int index) throws WmlElementIndexOutOfBoundsException {
        try {
            this.elements.remove(index);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new WmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeWmlElement(WmlElement wmlElement) throws WmlElementNotFoundException {
        boolean present = this.elements.remove(wmlElement);
        if (!present) {
            throw new WmlElementNotFoundException();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areWmlChildrenSane() {
        return true;
    }

    public void addWmlAttribute(String name, String value) throws WmlAttributeCannotBeAddedException {
        throw new WmlAttributeCannotBeAddedException();
    }

    public String getWmlAttributeValue(String name) {
        return null;
    }

    public String changeWmlAttribute(String name, String value) {
        return null;
    }

    public void removeWmlAttribute(String name) {
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areWmlAttributesSane() {
        return true;
    }

    public int getNumberOfLines() {
        int count = 0;
        WmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.wmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += element.getNumberOfLines();
            ++i;
        }
        return count;
    }

    public String getStartTag() {
        return "";
    }

    public String getEndTag() {
        return "";
    }

    public String getHead() {
        return "";
    }

    public int getHeadLength() {
        return 0;
    }

    public String getTail() {
        return "";
    }

    public int getTailLength() {
        return 0;
    }

    public String getBody() {
        return "";
    }

    public int getBodyLength() {
        return 0;
    }

    public String getContents() {
        StringBuffer contentsBuf = new StringBuffer("");
        WmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.wmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            contentsBuf.append(element.getContents());
            ++i;
        }
        return contentsBuf.toString();
    }

    public int getContentsLength() {
        int length = 0;
        WmlElement element = null;
        int i = 0;
        while (i < this.elements.size()) {
            try {
                element = this.wmlElementAt(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            length += element.getContentsLength();
            ++i;
        }
        return length;
    }

    public void setText(String text) throws WmlTextCannotBeSetException {
        throw new WmlTextCannotBeSetException();
    }

    public String getText() throws WmlTextNotSetException {
        return null;
    }

    public int getTextLength() throws WmlTextNotSetException {
        return -1;
    }

    public int getWmlAttributeLength(String name) {
        return -1;
    }

    public void resetText() throws WmlTextCannotBeResetException {
        throw new WmlTextCannotBeResetException();
    }

    public void setWmlParentElement(WmlElement wmlParentElement) {
    }

    public WmlElement getWmlParentElement() {
        return null;
    }
}

