/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util.html;

import com.aligo.html.HtmlBr;
import com.aligo.util.AmlMultiStringTokenizer;
import java.util.Hashtable;
import java.util.Vector;

public class TextUtils {
    private static Hashtable textConversionTable = new Hashtable();
    private static Hashtable attrConversionTable = new Hashtable();
    private static Vector newlineRepresentation;
    private static Vector encodeNewlineRepresentation;

    public static int prepareOutput(String sText, int columns, Vector strContainer) throws NullPointerException {
        return TextUtils.prepareOutput(sText, columns, strContainer, true);
    }

    public static int prepareOutput(String sText, int columns, Vector strContainer, boolean encode) throws NullPointerException {
        int tokenLength = 0;
        int numberLines = 0;
        if (sText != null) {
            AmlMultiStringTokenizer st = null;
            st = encode ? new AmlMultiStringTokenizer(sText, encodeNewlineRepresentation) : new AmlMultiStringTokenizer(sText, newlineRepresentation);
            HtmlBr oHtmlBr = new HtmlBr();
            while (st.hasMoreTokens()) {
                int tokenLines;
                String sToken = st.nextToken();
                if (sToken.equals("")) {
                    tokenLength = 0;
                    tokenLines = 0;
                } else {
                    tokenLength = sToken.length();
                    tokenLines = tokenLength % columns == 0 ? tokenLength / columns : tokenLength / columns + 1;
                }
                int endIndex = 0;
                tokenLines = 0;
                char cSpace = " ".charAt(0);
                if (!sToken.equals("")) {
                    boolean done = false;
                    while (!done) {
                        int beginIndex = endIndex;
                        if ((endIndex = beginIndex + columns) > tokenLength) {
                            endIndex = tokenLength;
                            done = true;
                        }
                        String strElement = sToken.substring(beginIndex, endIndex);
                        if (endIndex > 0 && endIndex < tokenLength && (sToken.charAt(endIndex - 1) != cSpace || sToken.charAt(endIndex) != cSpace)) {
                            int strElementSize = strElement.length();
                            boolean spaceFound = false;
                            int j = --strElementSize;
                            while (j >= 0 && !spaceFound) {
                                if (strElement.charAt(j) == cSpace) {
                                    strElement = strElement.substring(0, j + 1);
                                    endIndex = beginIndex + j + 1;
                                    spaceFound = true;
                                }
                                --j;
                            }
                        }
                        ++tokenLines;
                        if (encode) {
                            strElement = TextUtils.transformText(strElement);
                        }
                        strContainer.addElement(strElement);
                    }
                }
                numberLines += tokenLines;
                if (!st.hasMoreTokens()) continue;
                strContainer.addElement(oHtmlBr.getContents());
                ++numberLines;
            }
        }
        return numberLines;
    }

    public static String transformText(String inputStr) {
        StringBuffer outputStr = new StringBuffer();
        int length = inputStr.length();
        int i = 0;
        while (i < length) {
            String charString = inputStr.substring(i, i + 1);
            String sReplacement = (String)textConversionTable.get(charString);
            if (sReplacement == null) {
                sReplacement = charString;
            }
            outputStr.append(sReplacement);
            ++i;
        }
        return outputStr.toString();
    }

    public static String transformAttr(String htmlName, String inputStr) {
        StringBuffer outputStr = new StringBuffer();
        int length = inputStr.length();
        Hashtable htmlNameTable = (Hashtable)attrConversionTable.get(htmlName);
        if (htmlNameTable != null) {
            int i = 0;
            while (i < length) {
                String charString = inputStr.substring(i, i + 1);
                String sReplacement = (String)htmlNameTable.get(charString);
                if (sReplacement == null) {
                    sReplacement = charString;
                }
                outputStr.append(sReplacement);
                ++i;
            }
            return outputStr.toString();
        }
        return inputStr;
    }

    public static String getText(int start, int end, Vector strContainer) {
        String outputText = "";
        int i = start;
        while (i < end) {
            outputText = outputText + (String)strContainer.elementAt(i);
            ++i;
        }
        return outputText;
    }

    static {
        textConversionTable.put("<", "&lt;");
        textConversionTable.put(">", "&gt;");
        textConversionTable.put("&", "&amp;");
        textConversionTable.put("\"", "&quot;");
        Hashtable<String, String> urlConversionTable = new Hashtable<String, String>();
        urlConversionTable.put("<", "&lt;");
        urlConversionTable.put(">", "&gt;");
        urlConversionTable.put("\"", "&quot;");
        urlConversionTable.put(" ", "+");
        attrConversionTable.put("url", urlConversionTable);
        attrConversionTable.put("href", urlConversionTable);
        attrConversionTable.put("value", textConversionTable);
        newlineRepresentation = new Vector();
        newlineRepresentation.addElement("\n");
        newlineRepresentation.addElement("\r\n");
        newlineRepresentation.addElement("<br>");
        newlineRepresentation.addElement("<Br>");
        newlineRepresentation.addElement("<BR>");
        newlineRepresentation.addElement("<bR>");
        newlineRepresentation.addElement("<br/>");
        newlineRepresentation.addElement("<Br/>");
        newlineRepresentation.addElement("<BR/>");
        newlineRepresentation.addElement("<bR/>");
        encodeNewlineRepresentation = new Vector();
        encodeNewlineRepresentation.addElement("\n");
        encodeNewlineRepresentation.addElement("\r\n");
    }
}

