/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.util.Params;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public abstract class URLMethod {
    private static String defaultEncoding = System.getProperty("file.encoding");
    private Hashtable headers = null;
    private Cookie[] cookies = null;
    private HttpServletRequest request = null;
    protected Params params = null;
    private PrintWriter writer = null;
    protected URL theUrl;
    protected String urlSpec;
    private String encoding = null;
    private String redirectURL;

    protected void setConnURL(String urlStr) throws MalformedURLException {
        this.theUrl = new URL(urlStr);
    }

    public void setURL(String urlStr) throws MalformedURLException {
        this.setConnURL(urlStr);
        this.urlSpec = urlStr;
    }

    public void setCookies(Cookie[] c) {
        this.cookies = c;
    }

    public void setHeaders(Hashtable ht) {
        this.headers = ht;
    }

    public void setRequest(HttpServletRequest req) {
        this.request = req;
    }

    public void setParams(Hashtable p) {
        this.params = new Params(p);
    }

    protected void sendRequestHeaders(URLConnection connection) {
        Enumeration headers = this.request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String key = (String)headers.nextElement();
            String value = this.request.getHeader(key);
            String param = key + ": " + value;
            if (key.equalsIgnoreCase("user-agent")) {
                connection.setRequestProperty("User-Agent", value);
            }
            connection.setRequestProperty(key, value);
        }
    }

    protected void sendStaticHeaders(URLConnection connection) {
        Enumeration keys = this.headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.headers.get(key);
            String param = key + ": " + value;
            if (key.equalsIgnoreCase("user-agent")) {
                connection.setRequestProperty("User-Agent", value);
            }
            connection.setRequestProperty(key, value);
        }
    }

    protected void sendCookies(URLConnection connection) throws IOException {
        String cookieString = this.getCookieString();
        System.out.println("..................COOKIES BEING SENT=" + cookieString);
        PrintWriter out = this.getWriter(connection);
        out.println(cookieString);
    }

    protected void sendHeaders(URLConnection connection) throws IOException {
        if (this.request != null) {
            this.sendRequestHeaders(connection);
        } else if (this.headers != null) {
            this.sendStaticHeaders(connection);
        } else if (this.cookies != null) {
            this.sendCookies(connection);
        }
    }

    public String getCookieString() {
        StringBuffer retVal = new StringBuffer();
        if (this.cookies != null && this.cookies.length > 0) {
            retVal.append("Cookie: ");
            int i = 0;
            while (i < this.cookies.length) {
                retVal.append(this.cookies[i].getName());
                retVal.append("=");
                retVal.append(this.cookies[i].getValue());
                retVal.append(";  ");
                ++i;
            }
        }
        return retVal.toString();
    }

    protected PrintWriter getWriter(URLConnection connection) throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(connection.getOutputStream());
        }
        return this.writer;
    }

    protected void closeWriter() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public String composeURL() {
        return URLMethod.composeURL(this.params);
    }

    public static String composeURL(Params p) {
        String paramsURL = "";
        if (p != null) {
            paramsURL = p.composeURL();
        }
        return paramsURL;
    }

    public static String composeURL(Hashtable p) {
        return URLMethod.composeURL(new Params(p));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        String enc = this.encoding;
        if (enc == null) {
            enc = defaultEncoding;
        }
        return enc;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    protected void checkRedirect(URLConnection connection) throws IOException {
        HttpURLConnection httpConn;
        this.redirectURL = null;
        if (connection instanceof HttpURLConnection && (httpConn = (HttpURLConnection)connection).getResponseCode() == 302) {
            this.redirectURL = httpConn.getHeaderField("Location");
        }
    }

    public abstract String doMethod() throws IOException;
}

