/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.parsing.XMLElement;
import com.aligo.parsing.XMLException;
import com.aligo.parsing.XMLHDOM;
import com.aligo.parsing.XMLParser;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class HeaderHash {
    public static final String HEADER_TAG = "header";
    private static final String HEADER_PATH = "/header/";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String END_LT = "</";
    private static final String LEFT_BRACE = "[";
    private static final String RIGHT_BRACE = "]";
    private String m_headerAccept;
    private String m_headerUserAgent;
    private String m_suggestedMediaType;
    private String m_remoteHost;
    private String m_remoteAddr;
    private HashMap m_headerHash = null;

    public HeaderHash(HttpServletRequest req) {
        this.buildHash(req);
    }

    public HeaderHash() {
    }

    public void buildHash(HttpServletRequest req) {
        this.setHeaderAccept(req.getHeader("accept"));
        this.setHeaderUserAgent(req.getHeader("user-agent"));
        this.assignImplicitMediaType();
        this.m_remoteAddr = req.getRemoteAddr();
        if (this.m_headerHash == null) {
            this.m_headerHash = new HashMap();
        }
        Enumeration enumeration = req.getHeaderNames();
        String name = null;
        String val = null;
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            val = req.getHeader(name);
            this.headerHashPut(name.toLowerCase(), val);
        }
    }

    public String getRemoteAddr() {
        return this.m_remoteAddr;
    }

    public String getHeaderAccept() {
        return this.m_headerAccept;
    }

    public String getHeaderUserAgent() {
        return this.m_headerUserAgent;
    }

    public String getImplicitMediaType() {
        return this.m_suggestedMediaType;
    }

    public void setHeaderAccept(String acceptHead) {
        this.m_headerAccept = acceptHead;
    }

    public void setHeaderUserAgent(String userAgent) {
        this.m_headerUserAgent = userAgent;
    }

    public void setImplicitMediaType(String mediaType) {
        this.m_suggestedMediaType = mediaType;
    }

    public void assignImplicitMediaType() {
        this.setImplicitMediaType("text/html");
        String headerAccept = this.getHeaderAccept();
        if (headerAccept != null && headerAccept.indexOf("vnd.wap.wml") > -1) {
            this.setImplicitMediaType("text/vnd.wap.wml");
        }
    }

    public synchronized void headerHashPut(String key, String val) {
        this.m_headerHash.put(key, val);
    }

    public synchronized String headerHashGet(String key) {
        return this.m_headerHash.get(key).toString();
    }

    public HashMap getHashMapHandle() {
        return this.m_headerHash;
    }

    public Iterator getHashMapIterator() {
        return this.m_headerHash.keySet().iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator itr = this.getHashMapIterator();
        String name = null;
        String val = null;
        while (itr.hasNext()) {
            name = (String)itr.next();
            val = this.headerHashGet(name);
            sb.append(name + "=" + val + "\n");
        }
        return sb.toString();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        Iterator itr = this.getHashMapIterator();
        String name = null;
        String val = null;
        sb.append(LT);
        sb.append(HEADER_TAG);
        sb.append(GT);
        while (itr.hasNext()) {
            name = (String)itr.next();
            val = this.headerHashGet(name);
            sb.append(LT);
            sb.append(name);
            sb.append(GT);
            sb.append(val);
            sb.append(END_LT);
            sb.append(name);
            sb.append(GT);
        }
        sb.append(END_LT);
        sb.append(HEADER_TAG);
        sb.append(GT);
        return sb.toString();
    }

    public void fromXml(String xml) throws XMLException {
        XMLParser parser = new XMLParser();
        XMLHDOM dom = parser.parse(xml);
        this.fromXml(dom);
    }

    private void fromXml(XMLHDOM dom) throws XMLException {
        if (this.m_headerHash == null) {
            this.m_headerHash = new HashMap();
        }
        try {
            Enumeration elements = dom.children(HEADER_PATH);
            while (elements.hasMoreElements()) {
                XMLElement element = (XMLElement)elements.nextElement();
                String name = element.getName();
                String value = element.getData();
                if (name == null || value == null) continue;
                this.m_headerHash.put(name, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

