/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

class DeltaTime {
    long startT;
    long stopT;
    long lastET;
    long counts;
    long avgET;
    String id;

    DeltaTime(String idstr) {
        this.id = idstr;
        this.reset();
    }

    public void reset() {
        this.stopT = -1L;
        this.startT = -1L;
        this.lastET = 0L;
        this.avgET = 0L;
        this.counts = 0L;
    }

    public void start() {
        this.startT = System.currentTimeMillis();
    }

    public void stop() {
        this.stopT = System.currentTimeMillis();
        this.elapsedTime();
    }

    private long elapsedTime() {
        if (this.startT == -1L) {
            return -1L;
        }
        if (this.stopT == -1L) {
            return -1L;
        }
        this.lastET = this.stopT - this.startT;
        this.averageET(this.lastET);
        return this.lastET;
    }

    private void averageET(long et) {
        this.avgET += et;
        ++this.counts;
    }

    public long getElapsedTime() {
        return this.lastET;
    }

    public long getAverageElapsedTime() {
        if (this.counts > 0L) {
            return this.avgET / this.counts;
        }
        return 0L;
    }

    public String toString() {
        return "lastET=" + this.getElapsedTime() + " averageET=" + this.getAverageElapsedTime();
    }

    public String toXML() {
        return "<DeltaTime id=\"" + this.id + "\" lastET=\"" + this.getElapsedTime() + "\" averageET=\"" + this.getAverageElapsedTime() + "\"/>";
    }
}

