/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import java.util.Vector;

public class AmlMultiStringTokenizer {
    private String sContents;
    private Vector oDelimiters;

    public AmlMultiStringTokenizer(String contents, Vector delimiters) {
        this.sContents = contents;
        this.oDelimiters = delimiters;
    }

    public boolean hasMoreTokens() {
        return this.sContents != null;
    }

    public String nextToken() {
        String delimiterStr = this.getDelimiter();
        String token = null;
        if (delimiterStr != null) {
            int index = this.sContents.indexOf(delimiterStr);
            int delimiterSize = delimiterStr.length();
            token = this.sContents.substring(0, index);
            this.sContents = this.sContents.substring(index + delimiterSize);
        } else {
            token = this.sContents;
            this.sContents = null;
        }
        return token;
    }

    private String getDelimiter() {
        String delimiter = null;
        int lastStartIndex = -1;
        int delimiterIndex = -1;
        boolean delimiterAvailable = false;
        int numberDelimiters = this.oDelimiters.size();
        int i = 0;
        while (i < numberDelimiters) {
            String itDelimiter = (String)this.oDelimiters.elementAt(i);
            int startIndex = this.sContents.indexOf(itDelimiter);
            boolean assignDelimiter = false;
            if (startIndex >= 0) {
                if (!delimiterAvailable) {
                    assignDelimiter = true;
                } else if (startIndex < lastStartIndex) {
                    assignDelimiter = true;
                }
            }
            if (assignDelimiter) {
                lastStartIndex = startIndex;
                delimiterIndex = i;
                delimiterAvailable = true;
            }
            ++i;
        }
        if (delimiterAvailable) {
            delimiter = (String)this.oDelimiters.elementAt(delimiterIndex);
        }
        return delimiter;
    }
}

