/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.xml;

import com.aligo.tools.interfaces.DOMXMLable;
import com.aligo.tools.xml.DOMWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtilities {
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$com$aligo$tools$interfaces$DOMXMLable;
    static /* synthetic */ Class class$java$lang$String;

    public static Element getFirstMatch(Element element, String tagName) {
        return XMLUtilities.getFirstMatch(element, tagName, false);
    }

    public static Element getFirstMatch(Element element, String tagName, boolean deep) {
        Element firstMatch = null;
        if (element != null) {
            if (deep) {
                NodeList list = element.getElementsByTagName(tagName);
                if (list != null && list.getLength() > 0) {
                    firstMatch = (Element)list.item(0);
                }
            } else {
                NodeList list = element.getChildNodes();
                if (list != null && list.getLength() > 0) {
                    int i = 0;
                    while (i < list.getLength()) {
                        Node next = list.item(i);
                        if (next instanceof Element && tagName.equals(((Element)next).getTagName())) {
                            firstMatch = (Element)next;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return firstMatch;
    }

    public static Element getFirstElementByCriteria(Element element, String tagName, String attribute, String value) {
        Element firstMatch = null;
        if (element != null && tagName != null && attribute != null && value != null) {
            NodeList list = element.getElementsByTagName(tagName);
            if (list == null || list.getLength() <= 0) {
                list = element.getElementsByTagName(tagName.toUpperCase());
            }
            if (list != null && list.getLength() > 0) {
                int i = 0;
                while (firstMatch == null && i < list.getLength()) {
                    if (list.item(i) instanceof Element) {
                        Element next = (Element)list.item(i);
                        String attr = next.getAttribute(attribute);
                        if (attr == null || attr.length() <= 0) {
                            attr = next.getAttribute(attribute.toUpperCase());
                        }
                        if (attr != null && attr.equals(value)) {
                            firstMatch = next;
                        }
                    }
                    ++i;
                }
            }
        }
        return firstMatch;
    }

    public static Element getFirstElement(Element element) {
        NodeList list;
        Element firstMatch = null;
        if (element != null && (list = element.getChildNodes()) != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength() && firstMatch == null) {
                Node next = list.item(i);
                if (next instanceof Element) {
                    firstMatch = (Element)next;
                }
                ++i;
            }
        }
        return firstMatch;
    }

    public static String getPCData(Element element, String textElementTagName) {
        Element child;
        String text = null;
        if (element != null && (child = XMLUtilities.getFirstMatch(element, textElementTagName)) != null) {
            text = XMLUtilities.getPCData(child);
        }
        return text;
    }

    public static String getPCData(Element element) {
        NodeList list;
        String text = null;
        if (element != null && (list = element.getChildNodes()) != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength()) {
                Node next = list.item(i);
                if (next instanceof Text) {
                    text = ((Text)next).getData();
                    break;
                }
                ++i;
            }
        }
        return text;
    }

    public static void setPCData(Document document, Element parent, String text) {
        if (document != null && parent != null) {
            CharacterData textNode = null;
            NodeList list = parent.getChildNodes();
            if (list != null && list.getLength() > 0) {
                int i = 0;
                while (textNode == null && i < list.getLength()) {
                    Node next = list.item(i);
                    if (next instanceof Text) {
                        textNode = (Text)next;
                    }
                    ++i;
                }
            }
            if (textNode == null) {
                textNode = document.createTextNode(text);
                parent.appendChild(textNode);
            } else {
                textNode.setData(text);
            }
        }
    }

    public static void createPCData(Document document, Element parent, String tagName, String text) {
        Element element = XMLUtilities.createElementWithText(document, tagName, text);
        if (element != null) {
            parent.appendChild(element);
        }
    }

    public static Element createElementWithText(Document document, String tagName, String text) {
        Element element = null;
        if (document != null && tagName != null) {
            Text textNode = null;
            element = document.createElement(tagName);
            if (text != null) {
                textNode = document.createTextNode(text);
                element.appendChild(textNode);
            }
        }
        return element;
    }

    public static List getMatchingChildren(Element element, String tagName) {
        return XMLUtilities.getMatchingChildren(element, tagName, false);
    }

    public static List getMatchingChildren(Element element, String tagName, boolean ignoreCase) {
        NodeList list;
        ArrayList<Node> matches = new ArrayList<Node>();
        if (element != null && tagName != null && (list = element.getChildNodes()) != null && list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength()) {
                Node next = list.item(i);
                if (next != null && next instanceof Element && (!ignoreCase && tagName.equals(((Element)next).getTagName()) || ignoreCase && tagName.equalsIgnoreCase(((Element)next).getTagName()))) {
                    matches.add(next);
                }
                ++i;
            }
        }
        return matches;
    }

    public static void printItem(Node node, String fileName) {
        XMLUtilities.printItem(node, fileName, false);
    }

    public static void printItem(Node node, String fileName, boolean htmlStyle) {
        XMLUtilities.printItem(node, fileName, htmlStyle, false);
    }

    public static void printItem(Node node, String fileName, boolean htmlStyle, boolean canonical) {
        XMLUtilities.printItem(node, fileName, htmlStyle, canonical, false);
    }

    public static void printItem(Node node, String fileName, boolean htmlStyle, boolean canonical, boolean beautify) {
        try {
            FileOutputStream fout = new FileOutputStream(fileName);
            XMLUtilities.printItem(node, fout, htmlStyle, canonical, beautify);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printItem(Node node, File file) {
        XMLUtilities.printItem(node, file, false);
    }

    public static void printItem(Node node, File file, boolean htmlStyle) {
        XMLUtilities.printItem(node, file, htmlStyle, false);
    }

    public static void printItem(Node node, File file, boolean htmlStyle, boolean canonical) {
        XMLUtilities.printItem(node, file, htmlStyle, canonical, false);
    }

    public static void printItem(Node node, File file, boolean htmlStyle, boolean canonical, boolean beautify) {
        try {
            FileOutputStream fout = new FileOutputStream(file);
            XMLUtilities.printItem(node, fout, htmlStyle, canonical, beautify);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printItem(Node node) {
        XMLUtilities.printItem(node, System.out);
    }

    public static void printItem(Node node, boolean htmlStyle) {
        XMLUtilities.printItem(node, System.out, htmlStyle, false);
    }

    public static void printItem(Node node, boolean htmlStyle, boolean canonical) {
        XMLUtilities.printItem(node, System.out, htmlStyle, canonical, false);
    }

    public static void printItem(Node node, boolean htmlStyle, boolean canonical, boolean beautify) {
        XMLUtilities.printItem(node, System.out, htmlStyle, canonical, beautify);
    }

    public static void printItem(Node node, OutputStream output) {
        XMLUtilities.printItem(node, output, false);
    }

    public static void printItem(Node node, OutputStream output, boolean htmlStyle) {
        XMLUtilities.printItem(node, output, htmlStyle, false);
    }

    public static void printItem(Node node, OutputStream output, boolean htmlStyle, boolean canonical) {
        XMLUtilities.printItem(node, output, htmlStyle, canonical, false);
    }

    public static void printItem(Node node, OutputStream output, boolean htmlStyle, boolean canonical, boolean beautify) {
        try {
            DOMWriter writer = new DOMWriter(output, canonical);
            writer.setHTMLStyle(htmlStyle);
            writer.setBeautify(beautify);
            writer.print(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printItem(Node node, Writer writer) {
        XMLUtilities.printItem(node, writer, false);
    }

    public static void printItem(Node node, Writer writer, boolean htmlStyle) {
        XMLUtilities.printItem(node, writer, htmlStyle, false);
    }

    public static void printItem(Node node, Writer writer, boolean htmlStyle, boolean canonical) {
        XMLUtilities.printItem(node, writer, htmlStyle, canonical, false);
    }

    public static void printItem(Node node, Writer writer, boolean htmlStyle, boolean canonical, boolean beautify) {
        try {
            DOMWriter domWriter = new DOMWriter(writer, canonical);
            domWriter.setHTMLStyle(htmlStyle);
            domWriter.setBeautify(beautify);
            domWriter.print(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String toXMLString(DOMXMLable xmlObject) {
        return XMLUtilities.toXMLString(xmlObject, false);
    }

    public static String toXMLString(DOMXMLable xmlObject, boolean htmlStyle) {
        return XMLUtilities.toXMLString(xmlObject.toXMLElement(), htmlStyle);
    }

    public static String toXMLString(DOMXMLable xmlObject, boolean htmlStyle, boolean canonical) {
        return XMLUtilities.toXMLString(xmlObject.toXMLElement(), htmlStyle, canonical);
    }

    public static String toXMLString(DOMXMLable xmlObject, boolean htmlStyle, boolean canonical, boolean beautify) {
        return XMLUtilities.toXMLString(xmlObject.toXMLElement(), htmlStyle, canonical, beautify);
    }

    public static String toXMLString(Node node) {
        return XMLUtilities.toXMLString(node, false);
    }

    public static String toXMLString(Node node, boolean htmlStyle) {
        return XMLUtilities.toXMLString(node, htmlStyle, false);
    }

    public static String toXMLString(Node node, boolean htmlStyle, boolean canonical) {
        return XMLUtilities.toXMLString(node, htmlStyle, canonical, false);
    }

    public static String toXMLString(Node node, boolean htmlStyle, boolean canonical, boolean beautify) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            XMLUtilities.printItem(node, writer, htmlStyle, canonical, beautify);
            xmlString = writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    public static void fromXMLList(String tag, String classNameToInstantiate, Element masterElement, Object thisClass, Method methodToCall) {
        try {
            Iterator items = XMLUtilities.getMatchingChildren(masterElement, tag).iterator();
            boolean i = false;
            while (items.hasNext()) {
                Element next = (Element)items.next();
                Constructor<?> constr = Class.forName(classNameToInstantiate).getConstructor(class$org$w3c$dom$Element == null ? XMLUtilities.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                Object act = constr.newInstance(next);
                methodToCall.invoke(thisClass, act);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List fromXMLList(String childTag, Class childClass, Element listElement) {
        ArrayList childList = new ArrayList();
        try {
            Iterator items = XMLUtilities.getMatchingChildren(listElement, childTag).iterator();
            Constructor constructor = null;
            while (items.hasNext()) {
                Element next = (Element)items.next();
                try {
                    constructor = childClass.getConstructor(class$org$w3c$dom$Element == null ? XMLUtilities.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element);
                }
                catch (Exception e) {
                    constructor = null;
                }
                if (constructor != null) {
                    childList.add(constructor.newInstance(next));
                    continue;
                }
                if ((class$com$aligo$tools$interfaces$DOMXMLable == null ? XMLUtilities.class$("com.aligo.tools.interfaces.DOMXMLable") : class$com$aligo$tools$interfaces$DOMXMLable).isAssignableFrom(childClass)) {
                    Object obj = childClass.newInstance();
                    ((DOMXMLable)obj).fromXMLElement(next);
                    childList.add(obj);
                    continue;
                }
                try {
                    constructor = childClass.getConstructor(class$java$lang$String == null ? XMLUtilities.class$("java.lang.String") : class$java$lang$String);
                }
                catch (Exception e) {
                    constructor = null;
                }
                if (constructor != null) {
                    String pcData = XMLUtilities.getPCData(next);
                    childList.add(constructor.newInstance(pcData));
                    continue;
                }
                throw new IllegalArgumentException("The Class passed into the fromXMLList method does not implement  DOMXMLable.  This can therfore not be fromXMLed....");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childList;
    }

    public static Element toXMLList(Collection list, Document document, String masterTag) {
        Element masterElement = null;
        try {
            masterElement = document.createElement(masterTag);
            XMLUtilities.toXMLList(list, document, masterElement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return masterElement;
    }

    public static void toXMLList(Collection list, Document document, Element masterElement) {
        try {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Object next;
                if (!(class$com$aligo$tools$interfaces$DOMXMLable == null ? XMLUtilities.class$("com.aligo.tools.interfaces.DOMXMLable") : class$com$aligo$tools$interfaces$DOMXMLable).isAssignableFrom((next = itr.next()).getClass())) continue;
                Element childElement = ((DOMXMLable)next).toXMLElement(document);
                masterElement.appendChild(childElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Element toXMLList(Collection list, Document document, String masterTag, String childTag) {
        Element masterElement = null;
        try {
            masterElement = document.createElement(masterTag);
            XMLUtilities.toXMLList(list, document, masterElement, childTag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return masterElement;
    }

    public static void toXMLList(Collection list, Document document, Element masterElement, String childTag) {
        try {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Object next;
                if ((class$com$aligo$tools$interfaces$DOMXMLable == null ? XMLUtilities.class$("com.aligo.tools.interfaces.DOMXMLable") : class$com$aligo$tools$interfaces$DOMXMLable).isAssignableFrom((next = itr.next()).getClass())) {
                    Element childElement = ((DOMXMLable)next).toXMLElement(document);
                    masterElement.appendChild(childElement);
                    continue;
                }
                XMLUtilities.createPCData(document, masterElement, childTag, next.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getXPath(Node node) {
        String xPath = "";
        xPath = node.getParentNode() != null && !(node.getParentNode() instanceof Document) ? XMLUtilities.getXPath(node.getParentNode()) : "";
        xPath = xPath + "/" + node.getNodeName();
        if (node.getParentNode() != null && !(node.getParentNode() instanceof Document)) {
            Node parent = node.getParentNode();
            NodeList list = parent.getChildNodes();
            int count = 1;
            int overAllCount = 0;
            int i = 0;
            while (i < list.getLength()) {
                Node next = list.item(i);
                if (next.getNodeName().equals(node.getNodeName())) {
                    ++overAllCount;
                    if (next == node) {
                        count = overAllCount;
                    }
                }
                ++i;
            }
            if (overAllCount > 1) {
                xPath = xPath + "[" + count + "]";
            }
        }
        return xPath;
    }

    public static Node getNodeFromSimpleXPath(String xPath, Node parent) {
        if (xPath != null && parent != null) {
            StringTokenizer tokenizer = new StringTokenizer(xPath, "/", false);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token != null && token.length() > 0) {
                    int index = 1;
                    if (token.indexOf("[") > 0 && token.indexOf("]") > 0) {
                        index = XMLUtilities.getIndexOfToken(token);
                        token = XMLUtilities.getIndexedToken(token);
                    }
                    if (i != 0) {
                        if (parent != null) {
                            NodeList list = parent.getChildNodes();
                            int count = 1;
                            Node child = null;
                            int x = 0;
                            while (child == null && list != null && x < list.getLength()) {
                                Node next = list.item(x);
                                if (next != null && next.getNodeName().equalsIgnoreCase(token)) {
                                    if (count == index) {
                                        child = next;
                                    } else {
                                        ++count;
                                    }
                                }
                                ++x;
                            }
                            if (child != null) {
                                parent = child;
                            }
                        } else {
                            System.err.println("PARENT : is null!");
                        }
                    }
                }
                ++i;
            }
        }
        return parent;
    }

    public static Node getMatchingChild(Node parent, String nodeName, int index) {
        NodeList list = parent.getChildNodes();
        int count = 1;
        Node child = null;
        int x = 0;
        while (child == null && list != null && x < list.getLength()) {
            Node next = list.item(x);
            if (next != null && next.getNodeName().equals(nodeName)) {
                if (count == index) {
                    child = next;
                } else {
                    ++count;
                }
            }
            ++x;
        }
        return child;
    }

    public static int getIndexOfToken(String token) {
        int index = 1;
        if (token.indexOf("[") > 0 && token.indexOf("]") > 0) {
            String indexString = token.substring(token.indexOf("[") + 1, token.indexOf("]"));
            try {
                index = Integer.parseInt(indexString);
            }
            catch (Exception e) {
                System.err.println("Parse : " + indexString);
                e.printStackTrace();
            }
        }
        return index;
    }

    public static String getIndexedToken(String token) {
        String justToken = token;
        if (token.indexOf("[") > 0 && token.indexOf("]") > 0) {
            justToken = token.substring(0, token.indexOf("["));
        }
        return justToken;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

