/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.xml;

import com.aligo.tools.xml.DefaultDOMXMLable;
import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLColor
extends DefaultDOMXMLable {
    public static final String COLOR_TAG = "Color";
    public static final String R_ATTR = "r";
    public static final String G_ATTR = "g";
    public static final String B_ATTR = "b";
    private Color color;

    public static Color createColorFromXML(Element element) {
        Color color = null;
        if (element != null) {
            XMLColor xmlColor = new XMLColor(element);
            color = xmlColor.getColor();
        }
        return color;
    }

    public XMLColor() {
        this(Color.black);
    }

    public XMLColor(Element element) {
        super(element);
    }

    public XMLColor(Color color) {
        this.setColor(color);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " : You can not use NULL as a Color!");
        }
        this.color = color;
    }

    public void fromXMLElement(Element element) {
        this.color = null;
        Color tempColor = null;
        if (element != null && COLOR_TAG.equals(element.getTagName())) {
            int red = 0;
            int green = 0;
            int blue = 0;
            try {
                String redString = element.getAttribute(R_ATTR);
                if (redString != null && redString.length() > 0) {
                    red = Integer.parseInt(redString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String greenString = element.getAttribute(G_ATTR);
                if (greenString != null && greenString.length() > 0) {
                    green = Integer.parseInt(greenString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                String blueString = element.getAttribute(B_ATTR);
                if (blueString != null && blueString.length() > 0) {
                    blue = Integer.parseInt(blueString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempColor = new Color(red, green, blue);
        }
        this.setColor(tempColor);
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(COLOR_TAG);
        if (this.color != null) {
            element.setAttribute(R_ATTR, String.valueOf(this.color.getRed()));
            element.setAttribute(G_ATTR, String.valueOf(this.color.getGreen()));
            element.setAttribute(B_ATTR, String.valueOf(this.color.getBlue()));
        }
        return element;
    }
}

