/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.xml;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.interfaces.Named;
import com.aligo.tools.resource.ResourceManager;
import com.aligo.tools.resource.ResourceManagerKey;
import com.aligo.tools.util.ConstantsPopulator;
import com.aligo.tools.util.DataRepresentationType;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.KeyedXMLAttribute;
import com.aligo.tools.xml.XMLUtilities;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultKeyedXMLAttribute
extends DefaultDOMXMLable
implements Named,
KeyedXMLAttribute,
Serializable {
    public static final String ATTRIBUTE_TAG = "Attribute";
    public static final String ID_TAG = "ID";
    public static final String KEY_TAG = "Key";
    public static final String REFERENCE_NAME_TAG = "ReferenceName";
    public static final String NAME_KEY_TAG = "NameKey";
    public static final String ATTRIBUTE_NAME_TAG = "AttributeName";
    public static final String DATA_REP_TYPE_TAG = "DataRepresentationType";
    public static final String DATA_REP_TYPE_LIST_TAG = "DataRepresentationTypeList";
    public static final String DEFAULT_VALUE_TAG = "DefaultValue";
    public static final String DEFAULT_DTD_VALUE_TAG = "DefaultDTDValue";
    public static final String REQUIRED_TAG = "Required";
    public static final String DEPRECATED_TAG = "Deprecated";
    public static final String URL_TAG = "Url";
    public static final String EDITABLE_TAG = "Editable";
    private Long id;
    private String referenceName;
    private String key;
    private String name;
    private String attributeName;
    private DataRepresentationType repType;
    private List repTypeList;
    private Object defaultValue;
    private Object defaultDTDValue;
    private boolean required;
    private boolean deprecated;
    private boolean url;
    private boolean editable;
    private boolean popupEditor;
    private ResourceManagerKey rmKey;

    public DefaultKeyedXMLAttribute(Element element) {
        this(element, ResourceManagerKey.GENERAL);
    }

    public DefaultKeyedXMLAttribute(Element element, ResourceManagerKey rmKey) {
        this.setResourceManagerKey(rmKey);
        this.fromXMLElement(element);
    }

    public ResourceManagerKey getResourceManagerKey() {
        return this.rmKey;
    }

    public void setResourceManagerKey(ResourceManagerKey rmKey) {
        this.rmKey = rmKey;
    }

    public boolean isConstraint() {
        return false;
    }

    public Long getID() {
        return this.id;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public DataRepresentationType getRepresentationType() {
        return this.repType;
    }

    public List getValidValues() {
        return this.repTypeList;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getDefaultDTDValue() {
        return this.defaultDTDValue;
    }

    public boolean getIsRequired() {
        return this.required;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isUrl() {
        return this.url;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isPopupEditor() {
        return this.popupEditor;
    }

    public boolean isValidValue(Object object) {
        boolean valid = false;
        if (this.getValidValues() != null) {
            Iterator values = this.getValidValues().iterator();
            while (values.hasNext() && !valid) {
                Object next = values.next();
                if (!next.equals(object)) continue;
                valid = true;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        this.id = null;
        this.referenceName = null;
        this.key = null;
        this.name = null;
        this.attributeName = null;
        this.repType = null;
        this.repTypeList = null;
        this.defaultValue = null;
        this.defaultDTDValue = null;
        this.required = false;
        this.deprecated = false;
        this.url = false;
        this.editable = true;
        this.popupEditor = false;
        if (element != null && ATTRIBUTE_TAG.equals(element.getTagName())) {
            String value = XMLUtilities.getPCData(element, ID_TAG);
            if (value != null && value.length() > 0) {
                this.id = Long.valueOf(value);
            }
            this.referenceName = XMLUtilities.getPCData(element, REFERENCE_NAME_TAG);
            this.key = XMLUtilities.getPCData(element, KEY_TAG);
            if (this.key == null || this.key.length() <= 0) {
                throw new IllegalStateException("MUST HAVE A KEY ON A ATTRIBUTE!!!");
            }
            value = XMLUtilities.getPCData(element, NAME_KEY_TAG);
            if (value != null && value.length() > 0) {
                this.name = ResourceManager.getInstance().getString(this.getResourceManagerKey(), value);
            }
            this.attributeName = XMLUtilities.getPCData(element, ATTRIBUTE_NAME_TAG);
            value = XMLUtilities.getPCData(element, DATA_REP_TYPE_TAG);
            if (value != null && value.length() > 0) {
                try {
                    this.repType = (DataRepresentationType)ConstantsPopulator.getObjectFromReflectString(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((value = XMLUtilities.getPCData(element, DATA_REP_TYPE_LIST_TAG)) != null && value.length() > 0) {
                try {
                    int lastIndex = value.lastIndexOf(".");
                    String classString = value.substring(0, lastIndex);
                    String constName = value.substring(lastIndex + 1);
                    Class<?> constClass = Class.forName(classString);
                    Method[] methods = constClass.getMethods();
                    int i = 0;
                    while (i < methods.length && this.repTypeList == null) {
                        Method nextMethod = methods[i];
                        if (nextMethod.getParameterTypes().length == 0 && nextMethod.getName().equals(constName)) {
                            this.repTypeList = (List)nextMethod.invoke(null, null);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            value = XMLUtilities.getPCData(element, DEFAULT_VALUE_TAG);
            this.defaultValue = this.buildValue(value);
            value = XMLUtilities.getPCData(element, DEFAULT_DTD_VALUE_TAG);
            this.defaultDTDValue = this.buildValue(value);
            value = XMLUtilities.getPCData(element, REQUIRED_TAG);
            this.required = Boolean.valueOf(value);
            value = XMLUtilities.getPCData(element, DEPRECATED_TAG);
            this.deprecated = Boolean.valueOf(value);
            value = XMLUtilities.getPCData(element, URL_TAG);
            this.url = Boolean.valueOf(value);
            value = XMLUtilities.getPCData(element, EDITABLE_TAG);
            if (value != null && value.equals("false")) {
                this.editable = false;
            }
        }
    }

    public Element toXMLElement(Document document) {
        return null;
    }

    private Object buildValue(String stringValue) {
        Object value = null;
        if (stringValue != null && this.repType != null) {
            if (DataRepresentationType.TEXT.equals(this.repType)) {
                value = stringValue;
            } else if (DataRepresentationType.BOOLEAN.equals(this.repType)) {
                value = Boolean.valueOf(stringValue);
            } else if (DataRepresentationType.LIST.equals(this.repType)) {
                value = ConstantsPopulator.getObjectFromReflectString(stringValue);
            } else if (DataRepresentationType.INT.equals(this.repType)) {
                value = Integer.valueOf(stringValue);
            } else if (DataRepresentationType.COLOR.equals(this.repType)) {
                value = ToolsUtilities.getColorFromString(stringValue);
            } else if (DataRepresentationType.EDITABLE_LIST.equals(this.repType)) {
                value = stringValue;
            } else if (DataRepresentationType.DOUBLE.equals(this.repType)) {
                value = Double.valueOf(stringValue);
            } else if (DataRepresentationType.BIG_DECIMAL.equals(this.repType)) {
                value = new BigDecimal(stringValue);
            }
        }
        return value;
    }
}

