/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.xml;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.interfaces.Named;
import com.aligo.tools.resource.ResourceManager;
import com.aligo.tools.util.DataRepresentationType;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.TypedXMLAttribute;
import com.aligo.tools.xml.XMLAttributeValue;
import com.aligo.tools.xml.XMLElement;
import com.aligo.tools.xml.XMLElementTypeInterface;
import com.aligo.tools.xml.XMLUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractXMLElement
extends DefaultDOMXMLable
implements XMLElement {
    private HashMap attributes;
    private ArrayList children;

    public AbstractXMLElement(Element element) {
        super(element);
    }

    public AbstractXMLElement() {
        this.attributes = new HashMap();
        this.initilizeXML();
    }

    protected void initilizeXML() {
        Iterator attrs = this.getAvailableAttributes();
        while (attrs != null && attrs.hasNext()) {
            TypedXMLAttribute attrType = (TypedXMLAttribute)attrs.next();
            if (attrType.getDefaultValue() == null) continue;
            this.setAttribute(attrType, attrType.getDefaultValue());
        }
    }

    public void fromXMLElement(Element element) {
        if (this.canHaveChildren()) {
            this.removeAllChildren();
        }
        this.attributes = new HashMap();
        this.initilizeXML();
        if (element != null && element.getTagName().equals(this.getElementTagName())) {
            Iterator children;
            Iterator attributes = this.getAvailableAttributes();
            if (attributes != null) {
                while (attributes.hasNext()) {
                    TypedXMLAttribute attribute = (TypedXMLAttribute)attributes.next();
                    String attributeValue = element.getAttribute(attribute.getAttributeName());
                    if (attributeValue == null || attributeValue.length() <= 0) continue;
                    Object trueValue = attributeValue;
                    if (DataRepresentationType.LIST.equals(attribute.getRepresentationType())) {
                        Iterator values = attribute.getValidValues().iterator();
                        while (values.hasNext()) {
                            XMLAttributeValue attrValue = (XMLAttributeValue)values.next();
                            if (!attrValue.getAttributeValue().equals(attributeValue)) continue;
                            trueValue = attrValue;
                            break;
                        }
                    } else if (DataRepresentationType.BOOLEAN.equals(attribute.getRepresentationType())) {
                        trueValue = new Boolean(attributeValue);
                    } else if (DataRepresentationType.INT.equals(attribute.getRepresentationType())) {
                        trueValue = new Integer(attributeValue);
                    } else if (DataRepresentationType.COLOR.equals(attribute.getRepresentationType())) {
                        trueValue = ToolsUtilities.getColorFromString(attributeValue);
                    }
                    this.setAttribute(attribute, trueValue);
                }
            }
            if ((children = this.getValidChildren()) != null) {
                while (children.hasNext()) {
                    XMLElementTypeInterface next = (XMLElementTypeInterface)children.next();
                    Iterator matches = XMLUtilities.getMatchingChildren(element, next.getElementName()).iterator();
                    while (matches.hasNext()) {
                        Element childElement = (Element)matches.next();
                        try {
                            XMLElement xmlElement = (XMLElement)next.getElementDefinitionClass().newInstance();
                            this.addElement(xmlElement);
                            xmlElement.fromXMLElement(childElement);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public void addElement(XMLElement element) {
        if (!this.canHaveChildren() || element == null) {
            throw new UnsupportedOperationException("If you want to add an element to an xml element, the parent must support the operation.");
        }
        this.getMyChildren().add(element);
    }

    public void removeElement(XMLElement element) {
        if (!this.canHaveChildren() || element == null) {
            throw new UnsupportedOperationException("If you want to add an element to an xml element, the parent must support the operation.");
        }
        this.getMyChildren().remove(element);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(TypedXMLAttribute type) {
        return this.attributes.get(type);
    }

    public void setAttribute(TypedXMLAttribute type, Object value) {
        this.attributes.put(type, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append(this.getElementTagName());
        Set keySet = this.attributes.keySet();
        if (keySet != null && keySet.size() > 0) {
            Iterator keys = keySet.iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object value = this.attributes.get(key);
                buffer.append(" -> (");
                buffer.append(key.toString());
                buffer.append(", ");
                if (value == null) {
                    buffer.append("null");
                } else {
                    buffer.append(value.toString());
                }
                buffer.append(")");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public void removeAllChildren() {
        if (this.getMyChildren() != null) {
            this.getMyChildren().clear();
        }
    }

    public boolean canHaveChildren() {
        return false;
    }

    public int getChildCount() {
        return this.getMyChildren() != null ? this.getMyChildren().size() : 0;
    }

    protected List getMyChildren() {
        if (this.canHaveChildren() && this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public Iterator getChildren() {
        return this.getMyChildren() != null ? this.getMyChildren().iterator() : null;
    }

    public Iterator getValidChildren() {
        return null;
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(this.getElementTagName());
        Set keySet = this.attributes.keySet();
        if (keySet != null && keySet.size() > 0) {
            Iterator keys = keySet.iterator();
            while (keys.hasNext()) {
                Object value;
                TypedXMLAttribute key = (TypedXMLAttribute)keys.next();
                if (key == null || (value = this.attributes.get(key)) == null) continue;
                String attrValue = null;
                attrValue = value instanceof XMLAttributeValue ? ((XMLAttributeValue)value).getAttributeValue() : (value instanceof Named ? ((Named)value).getName() : (value instanceof Color ? ToolsUtilities.getStringFromColor((Color)value) : value.toString()));
                try {
                    element.setAttribute(key.getAttributeName(), attrValue);
                }
                catch (Exception e) {
                    String message = ResourceManager.getInstance().getMessageFormat("AbstractXMLElement.ErrorAddingAttribute.MessageFormat").format(new Object[]{key.getAttributeName(), attrValue, this.getElementTagName()});
                    System.err.println(message);
                    e.printStackTrace();
                }
            }
        }
        if (this.canHaveChildren() && this.getChildCount() > 0) {
            Iterator children = this.getChildren();
            while (children.hasNext()) {
                XMLElement xmlElement = (XMLElement)children.next();
                element.appendChild(xmlElement.toXMLElement(document));
            }
        }
        return element;
    }

    public abstract Iterator getAvailableAttributes();

    public abstract String getElementTagName();
}

