/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.util.StringXMLProperty;
import com.aligo.tools.util.XMLProperty;
import com.aligo.tools.util.XMLPropertyType;
import com.aligo.tools.xml.DOMWriter;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.DocumentFactory;
import com.aligo.tools.xml.XMLUtilities;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLStringProperties
extends DefaultDOMXMLable {
    public static final String PROPERTIES_FILE_TAG = "XMLPropertiesFile";
    private Map propertyMap;
    private String fileLocation;

    public XMLStringProperties(Properties properties) {
        this.setProperties(properties);
    }

    public XMLStringProperties(Element element) {
        super(element);
    }

    public XMLStringProperties(String fileLocation) {
        this(fileLocation, true);
    }

    public XMLStringProperties(String fileLocation, boolean load) {
        this.fileLocation = fileLocation;
        if (load) {
            try {
                Document document = DocumentFactory.openDocumentFromFileAsDOM(fileLocation);
                if (document != null) {
                    this.fromXMLElement(document.getDocumentElement());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setProperty(StringXMLProperty property) {
        if (property != null && property.getName() != null) {
            this.propertyMap.put(property.getName(), property);
        }
    }

    public StringXMLProperty getProperty(String propertyName) {
        StringXMLProperty property = null;
        try {
            if (propertyName != null && this.propertyMap != null) {
                property = (StringXMLProperty)this.propertyMap.get(propertyName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return property;
    }

    public String getPropertyValue(String propertyName) {
        XMLProperty property = null;
        String value = null;
        if (propertyName != null && this.propertyMap != null && (property = (XMLProperty)this.propertyMap.get(propertyName)) != null) {
            value = (String)property.getPropertyValue();
        }
        return value;
    }

    public void saveProperties() {
        try {
            Document document = DocumentFactory.createDOMDocument();
            Element rootElement = document.createElement(PROPERTIES_FILE_TAG);
            document.appendChild(rootElement);
            Collection list = this.propertyMap.values();
            if (list != null) {
                Iterator properties = list.iterator();
                while (properties.hasNext()) {
                    XMLProperty property = (XMLProperty)properties.next();
                    rootElement.appendChild(property.toXMLElement(document));
                }
                FileOutputStream fout = new FileOutputStream(this.fileLocation);
                DOMWriter writer = new DOMWriter(fout, false);
                writer.print(document);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Element toXMLElement(Document document) {
        Element rootElement = null;
        try {
            rootElement = document.createElement(PROPERTIES_FILE_TAG);
            document.appendChild(rootElement);
            Collection list = this.propertyMap.values();
            if (list != null) {
                Iterator properties = list.iterator();
                while (properties.hasNext()) {
                    XMLProperty property = (XMLProperty)properties.next();
                    rootElement.appendChild(property.toXMLElement(document));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootElement;
    }

    public void fromXMLElement(Element element) {
        this.propertyMap = new TreeMap();
        try {
            int i;
            NodeList list;
            if (element != null && (list = element.getElementsByTagName("XMLProperty")) != null && list.getLength() > 0) {
                i = 0;
                while (i < list.getLength()) {
                    XMLProperty property = XMLProperty.createProperty((Element)list.item(i));
                    if (XMLPropertyType.STRING.equals(property.getPropertyType())) {
                        this.propertyMap.put(property.getName(), property);
                    }
                    ++i;
                }
            }
            if (element != null) {
                if (!PROPERTIES_FILE_TAG.equals(element.getTagName())) {
                    element = XMLUtilities.getFirstMatch(element, PROPERTIES_FILE_TAG);
                }
                if (element != null && PROPERTIES_FILE_TAG.equals(element.getTagName()) && (list = element.getChildNodes()) != null && list.getLength() > 0) {
                    i = 0;
                    while (i < list.getLength()) {
                        XMLProperty property;
                        Node next = list.item(i);
                        if (next != null && next instanceof Element && (property = XMLProperty.createProperty((Element)next)) != null && property.getName() != null && XMLPropertyType.STRING.equals(property.getPropertyType())) {
                            this.propertyMap.put(property.getName(), property);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection getProperties() {
        return new ArrayList(this.propertyMap.values());
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        this.fillProperties(properties);
        return properties;
    }

    public void fillProperties(Properties properties) {
        if (properties != null) {
            Iterator stringValues = this.getProperties().iterator();
            while (stringValues.hasNext()) {
                StringXMLProperty next = (StringXMLProperty)stringValues.next();
                if (next.getName() == null || next.getPropertyValue() == null) continue;
                properties.setProperty(next.getName(), (String)next.getPropertyValue());
            }
        }
    }

    public void addProperties(Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = properties.getProperty(name);
                this.setProperty(new StringXMLProperty(name, value));
            }
        }
    }

    public void setProperties(Properties properties) {
        if (this.propertyMap == null) {
            this.propertyMap = new TreeMap();
        } else {
            this.propertyMap.clear();
        }
        this.addProperties(properties);
    }
}

