/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public class TypedProperties
extends Properties {
    private File file;

    public TypedProperties() {
    }

    public TypedProperties(String fileLocation) {
        this(new File(fileLocation));
    }

    public TypedProperties(File file) {
        try {
            this.load(new FileInputStream(file));
            this.file = file;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TypedProperties(InputStream stream) {
        try {
            this.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getFile(String propertyName) {
        File file = null;
        String value = this.getProperty(propertyName);
        if (value != null) {
            try {
                file = new File(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public boolean getBoolean(String propertyName) {
        boolean state = false;
        String value = this.getProperty(propertyName);
        if (value != null) {
            try {
                state = Boolean.valueOf(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return state;
    }

    public int getInt(String propertyName) {
        int intValue = 0;
        String value = this.getProperty(propertyName);
        if (value != null) {
            try {
                intValue = Integer.parseInt(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intValue;
    }

    public void save() {
        if (this.file != null) {
            try {
                this.store(new PrintStream(new FileOutputStream(this.file)), "Property File Details...");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

