/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.util.XMLProperty;
import com.aligo.tools.util.XMLPropertyType;
import com.aligo.tools.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringXMLProperty
extends XMLProperty {
    public static final String STRING_PROPERTY_TAG = "StringXMLProperty";
    public static final String VALUE_ATTR = "value";
    public static final String VALUE_TAG = "Value";
    private String value;

    public StringXMLProperty(Element element) {
        super(element);
    }

    public StringXMLProperty(String name, String value) {
        super(name);
        this.value = value;
    }

    public Object getPropertyValue() {
        return this.value;
    }

    public XMLPropertyType getPropertyType() {
        return XMLPropertyType.STRING;
    }

    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        if (element != null) {
            if (!STRING_PROPERTY_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, STRING_PROPERTY_TAG);
            }
            if (element != null && STRING_PROPERTY_TAG.equals(element.getTagName())) {
                this.value = element.getAttribute(VALUE_ATTR);
                if (ToolsUtilities.isNullOrEmpty(this.value)) {
                    this.value = XMLUtilities.getPCData(element, VALUE_TAG);
                }
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = super.toXMLElement(document);
        if (this.value != null) {
            XMLUtilities.createPCData(document, element, VALUE_TAG, this.value);
        }
        return element;
    }
}

