/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MethodCallChain
extends DefaultDOMXMLable {
    public static final String METHOD_CALL_CHAIN_TAG = "MethodCallChain";
    public static final String METHOD_TAG = "Method";
    public static final String SOURCE_CLASS_TAG = "SourceClass";
    private MethodCallChain chain;
    private String method;
    private String sourceClass;

    public MethodCallChain() {
    }

    public MethodCallChain(Element element) {
        super(element);
    }

    public MethodCallChain getChain() {
        return this.chain;
    }

    public void setChain(MethodCallChain chain) {
        this.chain = chain;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(String sourceClass) {
        this.sourceClass = sourceClass;
    }

    public void fromXMLElement(Element element) {
        this.method = null;
        this.sourceClass = null;
        if (element != null) {
            if (!METHOD_CALL_CHAIN_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, METHOD_CALL_CHAIN_TAG);
            }
            if (element != null && METHOD_CALL_CHAIN_TAG.equals(element.getTagName())) {
                Element chainElement = XMLUtilities.getFirstMatch(element, METHOD_CALL_CHAIN_TAG);
                if (chainElement != null) {
                    this.chain = new MethodCallChain(chainElement);
                }
                this.method = XMLUtilities.getPCData(element, METHOD_TAG);
                this.sourceClass = XMLUtilities.getPCData(element, SOURCE_CLASS_TAG);
            }
        }
    }

    public String toString() {
        String append = "";
        if (this.chain != null) {
            append = this.chain.toString();
        }
        return this.method + ":" + append;
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(METHOD_CALL_CHAIN_TAG);
        if (this.chain != null) {
            element.appendChild(this.chain.toXMLElement(document));
        }
        if (this.method != null) {
            XMLUtilities.createPCData(document, element, METHOD_TAG, this.method);
        }
        if (this.sourceClass != null) {
            XMLUtilities.createPCData(document, element, SOURCE_CLASS_TAG, this.sourceClass);
        }
        return element;
    }
}

