/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.util.NamedComparator;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConstantsPopulator {
    public static MessageFormat SELF_CONSTANT = new MessageFormat("{0}.{1}");

    public static List getSelfConstants(Class classType) {
        return ConstantsPopulator.getSelfConstants(classType, true);
    }

    public static List getSelfConstants(Class classType, boolean sort) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Field[] fields = classType.getFields();
            int i = 0;
            while (i < fields.length) {
                Field nextField = fields[i];
                if (nextField.getType().isAssignableFrom(classType)) {
                    try {
                        Object arrayItem = nextField.get(null);
                        if (arrayItem != null) {
                            list.add(arrayItem);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sort) {
            Collections.sort(list, NamedComparator.getInstance());
        }
        return list;
    }

    public static String getReflectString(Object object) {
        String reflectString = null;
        try {
            Class<?> classType = object.getClass();
            Field[] fields = classType.getFields();
            int i = 0;
            while (i < fields.length && reflectString == null) {
                Field nextField = fields[i];
                if (nextField.getType().isAssignableFrom(classType)) {
                    try {
                        Object item = nextField.get(null);
                        if (item.equals(object)) {
                            reflectString = SELF_CONSTANT.format(new Object[]{classType.getName(), nextField.getName()});
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reflectString == null) {
            throw new IllegalArgumentException("There is no field in the passed in class that matches the same type as this!");
        }
        return reflectString;
    }

    public static Object getObjectFromReflectString(String reflectString) {
        Object value = null;
        try {
            int lastIndex = reflectString.lastIndexOf(".");
            String classString = reflectString.substring(0, lastIndex);
            String constName = reflectString.substring(lastIndex + 1);
            Class<?> constClass = Class.forName(classString);
            Field[] fields = constClass.getFields();
            int i = 0;
            while (i < fields.length && value == null) {
                Field nextField = fields[i];
                if (nextField.getType().isAssignableFrom(constClass) && nextField.getName().equals(constName)) {
                    value = nextField.get(null);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (value == null) {
            throw new IllegalArgumentException("Could not form a field out of the passed in string : " + (reflectString != null ? reflectString : "null reflectString") + ".");
        }
        return value;
    }
}

